/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.options;

import java.util.Locale;
import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionGroup;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public abstract class DoubleOption
extends Option<Double> {
    protected final boolean hasSpecialValue;
    protected final Double defaultValue;
    protected final Double defaultNormalValue;
    protected final Double minimumValue;
    protected final Double maximumValue;
    protected final String specialValueSyntax;
    protected final String optDialogDescr;
    protected final String optDialogSpecialText;
    protected final String optDialogNormalText;
    protected final String optDialogLabelText;

    public DoubleOption(String name, String description, Character cmdShort, String cmdLong, String cmdValue, double defaultValue, Double minimumValue, Double maximumValue, boolean showInDialog, String optDialogDescr, String optDialogLabelText) {
        this(name, description, cmdShort, cmdLong, cmdValue, defaultValue, minimumValue, maximumValue, showInDialog, optDialogDescr, optDialogLabelText, false, null, null, null, null);
    }

    public DoubleOption(String name, String description, Character cmdShort, String cmdLong, String cmdValue, Double defaultValue, Double minimumValue, Double maximumValue, boolean showInDialog, String optDialogDescr, String optDialogLabelText, boolean hasSpecialValue, Double defaultNormalValue, String specialValueSyntax, String optDialogSpecialText, String optDialogNormalText) {
        super(name, description, cmdShort, cmdLong, cmdValue, showInDialog);
        Assert.notNull((Object)cmdLong);
        Assert.check((!cmdLong.equals("*") ? 1 : 0) != 0);
        Assert.notNull((Object)cmdValue);
        Assert.implies((defaultValue == null ? 1 : 0) != 0, (boolean)hasSpecialValue);
        if (defaultValue != null) {
            Assert.check((!Double.isInfinite(defaultValue) ? 1 : 0) != 0);
            Assert.check((!Double.isNaN(defaultValue) ? 1 : 0) != 0);
        }
        if (defaultValue != null && defaultValue == 0.0) {
            defaultValue = 0.0;
        }
        Assert.ifAndOnlyIf((!showInDialog || !hasSpecialValue ? 1 : 0) != 0, (defaultNormalValue == null ? 1 : 0) != 0);
        if (defaultNormalValue != null) {
            Assert.check((!Double.isInfinite(defaultNormalValue) ? 1 : 0) != 0);
            Assert.check((!Double.isNaN(defaultNormalValue) ? 1 : 0) != 0);
        }
        if (defaultNormalValue != null && defaultNormalValue == 0.0) {
            defaultNormalValue = 0.0;
        }
        if (minimumValue != null) {
            Assert.check((!Double.isInfinite(minimumValue) ? 1 : 0) != 0);
            Assert.check((!Double.isNaN(minimumValue) ? 1 : 0) != 0);
            if (defaultValue != null) {
                Assert.check((minimumValue <= defaultValue ? 1 : 0) != 0);
            }
        }
        if (maximumValue != null) {
            Assert.check((!Double.isInfinite(maximumValue) ? 1 : 0) != 0);
            Assert.check((!Double.isNaN(maximumValue) ? 1 : 0) != 0);
            if (defaultValue != null) {
                Assert.check((defaultValue <= maximumValue ? 1 : 0) != 0);
            }
        }
        Assert.ifAndOnlyIf((boolean)showInDialog, (optDialogDescr != null ? 1 : 0) != 0);
        Assert.implies((!showInDialog ? 1 : 0) != 0, (optDialogLabelText == null ? 1 : 0) != 0);
        if (optDialogLabelText != null) {
            Assert.check((boolean)optDialogLabelText.endsWith(":"));
        }
        Assert.ifAndOnlyIf((boolean)hasSpecialValue, (specialValueSyntax != null ? 1 : 0) != 0);
        Assert.ifAndOnlyIf((hasSpecialValue && showInDialog ? 1 : 0) != 0, (optDialogSpecialText != null ? 1 : 0) != 0);
        Assert.ifAndOnlyIf((hasSpecialValue && showInDialog ? 1 : 0) != 0, (optDialogNormalText != null ? 1 : 0) != 0);
        this.defaultValue = defaultValue;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.optDialogDescr = optDialogDescr;
        this.optDialogLabelText = optDialogLabelText;
        this.hasSpecialValue = hasSpecialValue;
        this.defaultNormalValue = defaultNormalValue;
        this.specialValueSyntax = specialValueSyntax;
        this.optDialogSpecialText = optDialogSpecialText;
        this.optDialogNormalText = optDialogNormalText;
    }

    @Override
    public Double getDefault() {
        return this.defaultValue;
    }

    @Override
    public Double parseValue(String optName, String value) {
        double v;
        if (this.hasSpecialValue && value.equals(this.specialValueSyntax)) {
            return null;
        }
        try {
            v = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            String msg = Strings.fmt((String)"Invalid real number \"%s\".", (Object[])new Object[]{value});
            throw new InvalidOptionException(msg);
        }
        DoubleOption.checkValue(!Double.isInfinite(v), "Infinite values are not allowed.");
        DoubleOption.checkValue(!Double.isNaN(v), "NaN is not allowed.");
        if (this.minimumValue != null) {
            DoubleOption.checkValue(v >= this.minimumValue, v + " < " + String.valueOf(this.minimumValue));
        }
        if (this.maximumValue != null) {
            DoubleOption.checkValue(v <= this.maximumValue, v + " > " + String.valueOf(this.maximumValue));
        }
        if (v == 0.0) {
            return 0.0;
        }
        return v;
    }

    @Override
    public String[] getCmdLine(Object value) {
        if (value == null) {
            Assert.check((boolean)this.hasSpecialValue);
            return new String[]{"--" + this.cmdLong + "=" + this.specialValueSyntax};
        }
        return new String[]{"--" + this.cmdLong + "=" + String.valueOf(value)};
    }

    @Override
    public OptionGroup<Double> createOptionGroup(Composite page) {
        Assert.check((boolean)this.showInDialog);
        return new DoubleOptionGroup(page);
    }

    private class DoubleOptionGroup
    extends OptionGroup<Double>
    implements SelectionListener {
        private Button specialButton;
        private Button normalButton;
        private Label valueLabel;
        private Text valueText;

        public DoubleOptionGroup(Composite page) {
            super(page, DoubleOption.this);
        }

        @Override
        protected void addComponents(Group group) {
            Object[] valueLayout;
            if (DoubleOption.this.hasSpecialValue) {
                this.specialButton = new Button((Composite)group, 16);
                this.specialButton.setText(DoubleOption.this.optDialogSpecialText);
                this.normalButton = new Button((Composite)group, 16);
                this.normalButton.setText(DoubleOption.this.optDialogNormalText);
                this.specialButton.addSelectionListener((SelectionListener)this);
                this.normalButton.addSelectionListener((SelectionListener)this);
            }
            this.valueText = new Text((Composite)group, 2052);
            if (DoubleOption.this.optDialogLabelText == null) {
                valueLayout = new Control[]{this.valueText};
            } else {
                this.valueLabel = new Label((Composite)group, 0);
                this.valueLabel.setText(DoubleOption.this.optDialogLabelText);
                valueLayout = new Control[]{this.valueLabel, this.valueText};
            }
            Object[] layout = DoubleOption.this.hasSpecialValue ? new Object[]{this.specialButton, this.normalButton, valueLayout} : (DoubleOption.this.optDialogLabelText == null ? valueLayout : new Object[]{valueLayout});
            this.layoutGeneric(layout, DoubleOption.this.hasSpecialValue ? 32 : 0);
        }

        @Override
        public String getDescription() {
            return DoubleOption.this.optDialogDescr;
        }

        @Override
        public void setToValue(Double value) {
            if (value == null) {
                Assert.check((boolean)DoubleOption.this.hasSpecialValue);
                this.specialButton.setSelection(true);
                Event event = new Event();
                event.widget = this.specialButton;
                this.widgetSelected(new SelectionEvent(event));
                value = DoubleOption.this.defaultNormalValue;
            } else if (DoubleOption.this.hasSpecialValue) {
                this.normalButton.setSelection(true);
                Event event = new Event();
                event.widget = this.normalButton;
                this.widgetSelected(new SelectionEvent(event));
            }
            if (value == 0.0) {
                this.valueText.setText("0");
            } else {
                this.valueText.setText(value.toString().toLowerCase(Locale.US));
            }
        }

        @Override
        public String[] getCmdLine() {
            if (DoubleOption.this.hasSpecialValue && this.specialButton.getSelection()) {
                return new String[]{"--" + DoubleOption.this.cmdLong + "=" + DoubleOption.this.specialValueSyntax};
            }
            String arg = this.valueText.getText();
            return new String[]{"--" + DoubleOption.this.cmdLong + "=" + arg};
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == this.specialButton) {
                this.valueText.setEnabled(false);
            } else if (e.widget == this.normalButton) {
                this.valueText.setEnabled(true);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

