/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.options;

import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.StringOption;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.Triple;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;

public class HtmlFrequenciesOption
extends StringOption {
    private static final int MINIMUM_FREQUENCY = 1;
    private static final int MAXIMUM_FREQUENCY = 100000;
    private static final String DESCRIPTION = Strings.fmt((String)"The minimum, default, and maximum frequencies in number of times per second that the JavaScript code for the model is executed in generated HTML pages. First the minimum frequency is given (must be at least %,d), then a colon (:), then the default frequency (must be at least the minimum frequency and at most the maximum frequency), then another colon (:), and then the maximum frequency (must be greater than the minimum frequency, and at most %,d).", (Object[])new Object[]{1, 100000});
    private static final String DEFAULT_VALUE = "1:60:120";

    public HtmlFrequenciesOption() {
        super("HTML frequencies", Strings.fmt((String)"%s [DEFAULT=%s]", (Object[])new Object[]{DESCRIPTION, DEFAULT_VALUE}), null, "html-frequencies", "FREQS", DEFAULT_VALUE, false, true, DESCRIPTION, "Frequencies:");
    }

    public static Triple<Integer, Integer, Integer> getFrequencies() {
        int max;
        int def;
        int min;
        String optionTxt = (String)Options.get(HtmlFrequenciesOption.class);
        if (!optionTxt.matches("[0-9,]+:[0-9,]+:[0-9,]+")) {
            throw new InvalidOptionException(Strings.fmt((String)"Invalid HTML frequencies \"%s\": expected three non-negative integer numbers separated by colons.", (Object[])new Object[]{optionTxt}));
        }
        String[] optionParts = optionTxt.replace(",", "").split(":");
        Assert.areEqual((Object)optionParts.length, (Object)3);
        try {
            min = Integer.parseInt(optionParts[0]);
        }
        catch (NumberFormatException ex) {
            throw new InvalidOptionException(Strings.fmt((String)"Minimum HTML frequency \"%s\" can't be parsed as an integer number.", (Object[])new Object[]{optionParts[0]}), (Throwable)ex);
        }
        try {
            def = Integer.parseInt(optionParts[1]);
        }
        catch (NumberFormatException ex) {
            throw new InvalidOptionException(Strings.fmt((String)"Default HTML frequency \"%s\" can't be parsed as an integer number.", (Object[])new Object[]{optionParts[1]}), (Throwable)ex);
        }
        try {
            max = Integer.parseInt(optionParts[2]);
        }
        catch (NumberFormatException ex) {
            throw new InvalidOptionException(Strings.fmt((String)"Maximum HTML frequency \"%s\" can't be parsed as an integer number.", (Object[])new Object[]{optionParts[2]}), (Throwable)ex);
        }
        if (min < 1) {
            throw new InvalidOptionException(Strings.fmt((String)"Minimum frequency HTML \"%s\" is less than %,d.", (Object[])new Object[]{min, 1}));
        }
        if (max > 100000) {
            throw new InvalidOptionException(Strings.fmt((String)"Maximum frequency HTML \"%s\" is greater than %,d.", (Object[])new Object[]{max, 100000}));
        }
        if (min >= max) {
            throw new InvalidOptionException(Strings.fmt((String)"Minimum frequency HTML \"%s\" is greater than or equal to the maximum frequency (\"%s\").", (Object[])new Object[]{min, max}));
        }
        if (def < min) {
            throw new InvalidOptionException(Strings.fmt((String)"Default frequency HTML \"%s\" is less than the minimum frequency \"%s\".", (Object[])new Object[]{def, min}));
        }
        if (def > max) {
            throw new InvalidOptionException(Strings.fmt((String)"Default frequency HTML \"%s\" is greater than the maximum frequency (\"%s\").", (Object[])new Object[]{def, max}));
        }
        return Triple.triple((Object)min, (Object)def, (Object)max);
    }
}

