/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.variables;

import java.util.ArrayList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class JavaContentProviderFilter {
    public static Object[] filterVariables(Object[] variables, IPresentationContext context) throws DebugException {
        boolean filterConstants;
        boolean filterStatics = !JavaContentProviderFilter.includeStatic(context);
        boolean bl = filterConstants = !JavaContentProviderFilter.includeConstants(context);
        if (filterStatics || filterConstants) {
            ArrayList<Object> keep = new ArrayList<Object>(variables.length);
            Object[] objectArray = variables;
            int n = variables.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaVariable var;
                Object variable = objectArray[n2];
                boolean filter = false;
                if (variable instanceof IJavaVariable && (var = (IJavaVariable)variable).isStatic()) {
                    filter = var.isFinal() ? filterConstants : filterStatics;
                }
                if (!filter) {
                    keep.add(variable);
                }
                ++n2;
            }
            return keep.toArray(new Object[keep.size()]);
        }
        return variables;
    }

    private static boolean includeStatic(IPresentationContext context) {
        IPreferenceStore store = JDIDebugUIPlugin.getDefault().getPreferenceStore();
        String statics = context.getId() + "." + IJDIPreferencesConstants.PREF_SHOW_STATIC_VARIABLES;
        return store.getBoolean(statics);
    }

    private static boolean includeConstants(IPresentationContext context) {
        IPreferenceStore store = JDIDebugUIPlugin.getDefault().getPreferenceStore();
        String constants = context.getId() + "." + IJDIPreferencesConstants.PREF_SHOW_CONSTANTS;
        return store.getBoolean(constants);
    }
}

