/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.svg;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSEngineUserAgent;
import org.apache.batik.css.engine.value.ShorthandManager;
import org.apache.batik.css.engine.value.ValueManager;
import org.apache.batik.css.parser.ExtendedParser;
import org.apache.batik.dom.AbstractStylableDocument;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.gvt.GraphicsNode;
import org.eclipse.core.runtime.Platform;
import org.eclipse.escet.common.eclipse.ui.G2dSwtCanvas;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;
import org.eclipse.escet.common.svg.SvgCssParser;
import org.eclipse.escet.common.svg.SvgException;
import org.eclipse.escet.common.svg.SvgUserAgent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;

public class SvgCanvas
extends G2dSwtCanvas {
    private final Document document;
    private Consumer<SvgException> renderingExceptionHandler;
    private final GraphicsNode graphicsNode;
    private final BridgeContext bridgeContext;
    private final SvgUserAgent userAgent;
    private int width;
    private int height;
    public final boolean usePixelData;
    public final Object pixelDataLock = new Object();
    public byte[] pixelData = null;
    public String path = null;

    public SvgCanvas(Composite parent, Document document, boolean usePixelData) {
        super(parent);
        this.document = document;
        this.usePixelData = usePixelData;
        this.userAgent = new SvgUserAgent();
        this.bridgeContext = new BridgeContext((UserAgent)this.userAgent);
        this.bridgeContext.setDynamic(true);
        SVGOMDocument svgDocument = (SVGOMDocument)document;
        SVGDOMImplementation svgDocumentImpl = (SVGDOMImplementation)svgDocument.getImplementation();
        SvgCssParser parser = new SvgCssParser();
        parser.setErrorHandler(this.userAgent);
        CSSEngine cssEngine = svgDocumentImpl.createCSSEngine((AbstractStylableDocument)svgDocument, (CSSContext)this.bridgeContext, (ExtendedParser)parser, new ValueManager[0], new ShorthandManager[0]);
        cssEngine.setCSSEngineUserAgent((CSSEngineUserAgent)this.userAgent);
        svgDocument.setCSSEngine(cssEngine);
        GVTBuilder builder = new GVTBuilder();
        try {
            this.graphicsNode = builder.build(this.bridgeContext, document);
        }
        catch (BridgeException ex) {
            this.userAgent.displayError((Exception)((Object)ex));
            try {
                this.userAgent.reportProblem();
                throw new RuntimeException("Never reached.");
            }
            catch (SvgException ex2) {
                String msg = "Failed to process SVG image file. The SVG image is not valid.";
                throw new SvgException(msg, (Throwable)((Object)ex2));
            }
        }
        this.updateImageSize();
    }

    public Document getDocument() {
        return this.document;
    }

    public GraphicsNode getGraphicsNode() {
        return this.graphicsNode;
    }

    public BridgeContext getBridgeContext() {
        return this.bridgeContext;
    }

    public int getImageWidth() {
        return this.width;
    }

    public int getImageHeight() {
        return this.height;
    }

    public void setRenderingExceptionHandler(Consumer<SvgException> renderingExceptionHandler) {
        this.renderingExceptionHandler = renderingExceptionHandler;
    }

    protected Graphics2D createGraphics(BufferedImage image) {
        return GraphicsUtil.createGraphics((BufferedImage)image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g, int w, int h) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, w, h);
        Document document = this.document;
        synchronized (document) {
            this.graphicsNode.paint(g);
        }
        try {
            this.userAgent.reportProblem();
        }
        catch (SvgException ex) {
            String msg = this.path == null ? "SVG image rendering failed." : Strings.fmt((String)"SVG image rendering failed for file \"%s\".", (Object[])new Object[]{this.path});
            ex = new SvgException(msg, (Throwable)((Object)ex));
            if (this.renderingExceptionHandler == null) {
                throw ex;
            }
            this.renderingExceptionHandler.accept(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getImageToPaint(int width, int height) {
        if (this.usePixelData) {
            Object object = this.pixelDataLock;
            synchronized (object) {
                Assert.notNull((Object)this.pixelData);
                return this.pixelData;
            }
        }
        return super.getImageToPaint(width, height);
    }

    public void saveImage(String fileName) throws IOException {
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        this.paint(this.createGraphics(image), this.width, this.height);
        File outFile = new File(fileName);
        String imgFormat = Strings.slice((String)fileName, (Integer)-3, null);
        boolean rslt = ImageIO.write((RenderedImage)image, imgFormat, outFile);
        if (!rslt) {
            String msg = Strings.fmt((String)"Failed to save image to \"%s\": unknown or unsupported file extension.", (Object[])new Object[]{fileName});
            throw new IOException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateImageSize() {
        if (Display.getCurrent() == null) {
            final InvalidInputException[] ex = new InvalidInputException[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (SvgCanvas.this.isDisposed()) {
                        return;
                    }
                    try {
                        SvgCanvas.this.updateImageSize();
                    }
                    catch (InvalidInputException e) {
                        ex[0] = e;
                    }
                }
            });
            if (ex[0] != null) {
                throw ex[0];
            }
            return;
        }
        Document document = this.document;
        synchronized (document) {
            Dimension2D docsize = this.bridgeContext.getDocumentSize();
            this.width = (int)Math.ceil(docsize.getWidth());
            this.height = (int)Math.ceil(docsize.getHeight());
            if (this.width <= 0) {
                String msg = Strings.fmt((String)"SVG image width is %d, but must be positive.", (Object[])new Object[]{this.width});
                throw new InvalidInputException(msg);
            }
            if (this.height <= 0) {
                String msg = Strings.fmt((String)"SVG image height is %d, but must be positive.", (Object[])new Object[]{this.height});
                throw new InvalidInputException(msg);
            }
            this.setSize(this.width, this.height);
            if (!Platform.isRunning() || !PlatformUI.isWorkbenchRunning()) {
                Shell shell = this.getShell();
                Rectangle bounds = shell.getBounds();
                Rectangle client = shell.getClientArea();
                int extraWidth = bounds.width - client.width;
                int extraHeight = bounds.height - client.height;
                int shellWidth = this.width + extraWidth;
                int shellHeight = this.height + extraHeight;
                shell.setSize(shellWidth, shellHeight);
            }
        }
    }
}

