/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class CombinationIterator
implements Iterable<Set<Integer>>,
Iterator<Set<Integer>> {
    private int[] indexes = null;
    private int[] items = null;
    private final int combSize;
    private final int itemsSize;
    private boolean hasNext = true;

    public CombinationIterator(int combSize, int itemsSize) {
        this.combSize = combSize;
        this.itemsSize = itemsSize;
        this.items = new int[this.itemsSize];
        for (int i = 0; i < this.itemsSize; ++i) {
            this.items[i] = i;
        }
        this.computeNext();
    }

    public CombinationIterator(int combSize, Set<Integer> items) {
        this.combSize = combSize;
        this.itemsSize = items.size();
        this.items = new int[this.itemsSize];
        int i = 0;
        for (Integer item : items) {
            this.items[i++] = item;
        }
        this.computeNext();
    }

    public CombinationIterator(int combSize, BitSet items) {
        this(combSize, items, 0);
    }

    public CombinationIterator(int combSize, BitSet items, int offset) {
        this.combSize = combSize;
        this.itemsSize = items.cardinality();
        this.items = new int[this.itemsSize];
        int index = 0;
        int i = items.nextSetBit(0);
        while (i >= 0) {
            this.items[index++] = i + offset;
            i = items.nextSetBit(i + 1);
        }
        this.computeNext();
    }

    private void computeNext() {
        if (this.indexes == null) {
            this.indexes = new int[this.combSize];
            for (int i = 0; i < this.combSize; ++i) {
                this.indexes[i] = i;
            }
            return;
        }
        for (int j = this.combSize - 1; j >= 0; --j) {
            int n = j;
            this.indexes[n] = this.indexes[n] + 1;
            if (this.indexes[j] != this.itemsSize - this.combSize + j + 1) break;
            if (j != 0) continue;
            this.hasNext = false;
            return;
        }
        for (int k = j + 1; k < this.combSize; ++k) {
            this.indexes[k] = this.indexes[k - 1] + 1;
        }
    }

    @Override
    public Iterator<Set<Integer>> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Set<Integer> next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        HashSet<Integer> nextSet = new HashSet<Integer>();
        int[] nArray = this.indexes;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = nArray[i];
            nextSet.add(this.items[i2]);
        }
        this.computeNext();
        return nextSet;
    }

    public BitSet nextBitSet() {
        BitSet nextSet = new BitSet();
        int[] nArray = this.indexes;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = nArray[i];
            nextSet.set(this.items[i2]);
        }
        this.computeNext();
        return nextSet;
    }

    @Override
    public void remove() {
    }
}

