/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSearchUtility {
    private static SearchRequestor createRequestor(final List<SearchMatch> results) {
        return new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                int accuracy = match.getAccuracy();
                if (accuracy != 0) {
                    return;
                }
                results.add(match);
            }
        };
    }

    public static List<SearchMatch> findImplementorsOf(IType serviceType) throws CoreException {
        IJavaProject javaProject = serviceType.getJavaProject();
        List<SearchMatch> results = TypeSearchUtility.findImplementorsOf(serviceType, javaProject);
        return results;
    }

    public static List<SearchMatch> findImplementorsOf(IType serviceType, IJavaProject javaProject) throws CoreException {
        SearchEngine engine = new SearchEngine();
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)serviceType, (int)1);
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        IJavaElement[] elements = new IJavaElement[]{javaProject};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        ArrayList<SearchMatch> results = new ArrayList<SearchMatch>(3);
        SearchRequestor requestor = TypeSearchUtility.createRequestor(results);
        engine.search(pattern, participants, scope, requestor, null);
        return results;
    }

    public static boolean isConcreteClass(IType type) throws JavaModelException {
        boolean isClass = type.isClass();
        if (!isClass) {
            return false;
        }
        int flags = type.getFlags();
        boolean abstractType = Flags.isAbstract((int)flags);
        return !abstractType;
    }

    private TypeSearchUtility() {
    }
}

