var innerTextSupported = (document.getElementsByTagName("head")[0].innerText != undefined) ? true : false;

function processRequests() {
	var nextRequestAction = new testmgr.HttpRequest();
	nextRequestAction.setResponseHandler(handleRequest);
	nextRequestAction.setErrorHandler(handleHttpError);
	nextRequestAction.post("?action=nextrequest");
}

function handleRequest() {
	var request = this.getText().split("|");
	var requestType = request[0];
	var requestData = request[1].split("^");
	switch (requestType) {
		case "IDLE":
			processRequests();
			break;
		case "PROMPT":
			enablePrompt(requestData[0], requestData[1]);
			processRequests();
			break;
		case "END":
			disablePrompt();
			disableAbort();
			break;
		default:
			alert("Unsupported request received from test manager: " + eventType); 
	}
	delete this.req;
}

function handleHttpError() {
	// In case of errors, simply disable controls.
	disablePrompt();
	disableAbort();
	delete this.req;
}

function clickedConfirm() {
	disablePrompt();
	var confirmAction = new testmgr.HttpRequest();
	confirmAction.setErrorHandler(handleHttpError);
	confirmAction.post("?action=confirm");
	processRequests();
}

function clickedCancel() {
	disablePrompt();
	var cancelAction = new testmgr.HttpRequest();
	cancelAction.setErrorHandler(handleHttpError);
	cancelAction.post("?action=cancel");
	processRequests();
}

function clickedAbort() {
	if (confirm("Are you sure you want to abort the test run?")) {
		disablePrompt();
		disableAbort();
		var abortAction = new testmgr.HttpRequest();
		abortAction.post("?action=abort");
	}
}

function enablePrompt(prompt, testName) {
	getElementById('TestLabel').style.cssText = 'color:black';
	setInnerText(getElementById('TestLabel'), testName);
	getElementById('PromptLabel').style.cssText = 'color:black';
	setInnerText(getElementById('PromptLabel'), prompt);
	getElementById('ButtonConfirm').disabled = false;
	getElementById('ButtonCancel').disabled = false;
}

function disablePrompt() {
	getElementById('TestLabel').style.cssText = 'color:silver';
	getElementById('PromptLabel').style.cssText = 'color:silver';
	getElementById('ButtonConfirm').disabled = true;
	getElementById('ButtonCancel').disabled = true;
}

function disableAbort() {
		getElementById('ButtonAbort').disabled = true;
}

function getElementById(id) {
	return document.getElementById(id);
}

function setInnerText(elem, value) {
	if(innerTextSupported){
		elem.innerText = value;
	} else {
		elem.textContent = value;
	}
}

// Kick off handling confirmation requests
processRequests();
