/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testmanager.servlet;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.soda.dk.testagent.service.TestSynchronizationService;
import org.eclipse.soda.dk.testmanager.service.DistributedTestSessionService;

public class TestControl
implements TestSynchronizationService {
    private static final long MAX_WAIT_TIME = 2000L;
    private DistributedTestSessionService distributedTestSession;
    private List requests = new ArrayList();
    private int nextRequest;
    private Object confirmationLock = new Object();
    private boolean confirmationValue;
    private boolean finished;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmRequest(boolean confirmationValue) {
        Object object = this.confirmationLock;
        synchronized (object) {
            this.confirmationValue = confirmationValue;
            this.confirmationLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        if (!this.finished) {
            this.finished = true;
            this.distributedTestSession.interrupt();
            Object object = this.requests;
            synchronized (object) {
                this.requests.notify();
            }
            object = this.confirmationLock;
            synchronized (object) {
                this.confirmationLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestConfirmation(String prompt, String testName) throws InterruptedException {
        Request request = new Request("PROMPT", new String[]{prompt, testName});
        Object object = this.confirmationLock;
        synchronized (object) {
            List list = this.requests;
            synchronized (list) {
                this.requests.add(request);
                this.requests.notify();
            }
            this.confirmationLock.wait();
        }
        return this.confirmationValue;
    }

    public void setTestSessionManager(DistributedTestSessionService distributedTestSession) {
        this.distributedTestSession = distributedTestSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request waitForNextEvent() throws InterruptedException {
        List list = this.requests;
        synchronized (list) {
            if (this.nextRequest == this.requests.size() && !this.finished) {
                this.requests.wait(2000L);
            }
            if (this.nextRequest < this.requests.size()) {
                return (Request)this.requests.get(this.nextRequest++);
            }
        }
        if (this.finished) {
            return new Request("END");
        }
        return new Request("IDLE");
    }

    public static class Request {
        public static final String REQUEST_TYPE_IDLE = "IDLE";
        public static final String REQUEST_TYPE_PROMPT = "PROMPT";
        public static final String REQUEST_TYPE_END = "END";
        private String requestType;
        private String[] requestData;

        public Request(String requestType) {
            this.requestType = requestType;
        }

        public Request(String requestType, String[] requestData) {
            this.requestType = requestType;
            this.requestData = requestData;
        }

        public String[] getRequestData() {
            return this.requestData;
        }

        public String getRequestDataValues() {
            StringBuffer csv = new StringBuffer();
            if (this.requestData != null) {
                int i = 0;
                while (i < this.requestData.length) {
                    String value;
                    if (i > 0) {
                        csv.append('^');
                    }
                    if ((value = this.requestData[i]) != null) {
                        csv.append(value);
                    }
                    ++i;
                }
            }
            return csv.toString();
        }

        public String getRequestType() {
            return this.requestType;
        }
    }
}

