/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.generic.inventory.profile;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.generic.adapter.service.GenericInventoryListener;
import org.eclipse.soda.dk.generic.adapter.service.GenericInventoryListenerService;
import org.eclipse.soda.dk.generic.adapter.service.GenericInventoryService;
import org.eclipse.soda.dk.generic.inventory.profile.service.GenericInventoryProfileService;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.eclipse.soda.dk.rfid.inventory.profile.RfidInventoryProfile;

public class GenericInventoryProfile
extends RfidInventoryProfile
implements ProfileService,
GenericInventoryProfileService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.generic.inventory.profile.GenericInventoryProfile";
    private GenericInventoryService adapter;
    private GenericInventoryListener inventoryListener = new GenericInventoryListener(){

        public void receiveTagEvent(String tagId, Map tagData) {
            GenericInventoryProfile.this.handleTagEvent(tagId, tagData);
        }
    };

    public GenericInventoryProfile() {
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public void activate() {
        super.activate();
        GenericInventoryListenerService adapter = (GenericInventoryListenerService)this.getInventoryAdapterService();
        if (adapter != null) {
            adapter.setInventoryListener(this.inventoryListener);
        }
    }

    protected boolean autonomousModeOff() {
        if (this.adapter != null) {
            return this.adapter.turnOffRfid();
        }
        return false;
    }

    protected boolean autonomousModeOn() {
        if (this.adapter != null) {
            return this.adapter.turnOnRfid();
        }
        return false;
    }

    public DeviceService getDefaultDevice() {
        return null;
    }

    public String getDefaultKey() {
        return "GenericInventoryProfile";
    }

    public GenericInventoryService getInventoryAdapterService() {
        return this.adapter;
    }

    protected void handleTagEvent(String tagId, Map tagData) {
        if (this.isLogging(4)) {
            this.log(4, "Generic Inventory Profile receives tag: " + tagId);
        }
        Hashtable<String, Map> tagReportMap = new Hashtable<String, Map>();
        Map readData = tagData != null ? tagData : new Hashtable();
        tagReportMap.put(tagId, readData);
        this.notifyTagRead(tagReportMap, GenericInventoryProfile.getCurrentTimestamp());
    }

    private void initialize() {
    }

    public boolean isAdapterNeeded() {
        return true;
    }

    public boolean isDeviceNeeded() {
        return false;
    }

    public void setInventoryAdapterService(GenericInventoryService adapter) {
        this.adapter = adapter;
    }

    public void setup() {
        super.setup();
        this.setNotificationPriority(this.getInt("genericinventoryprofile.notificationpriority", this.getNotificationPriority()));
    }
}

