/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.transport.wizard;

import java.util.List;
import org.eclipse.soda.devicekit.generator.model.ConfigurationModel;
import org.eclipse.soda.devicekit.generator.model.elements.ConfigurationField;
import org.eclipse.soda.devicekit.generator.model.elements.CustomParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.EnumElement;
import org.eclipse.soda.devicekit.ui.transport.wizard.ByteValidator;
import org.eclipse.soda.devicekit.ui.transport.wizard.DeviceKitConnectionPage;
import org.eclipse.soda.devicekit.ui.transport.wizard.DoubleValidator;
import org.eclipse.soda.devicekit.ui.transport.wizard.FloatValidator;
import org.eclipse.soda.devicekit.ui.transport.wizard.IntegerValidator;
import org.eclipse.soda.devicekit.ui.transport.wizard.LongValidator;
import org.eclipse.soda.devicekit.ui.transport.wizard.ShortValidator;
import org.eclipse.soda.devicekit.ui.transport.wizard.Validator;
import org.eclipse.soda.devicekit.ui.wizard.DeviceKitPage;
import org.eclipse.soda.devicekit.ui.wizard.IWizardMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ConnectionModelPage
extends DeviceKitConnectionPage
implements SelectionListener {
    private IWizardMessages messages;
    private String key;
    private ConfigurationModel connectionModel;
    private final ConfigurationField[] fields;
    private Validator[] validators = new Validator[0];
    private String defaultMessage;

    public ConnectionModelPage(String pageName, DeviceKitPage previousPage, IWizardMessages messages, String defaultMesage) {
        super(pageName, previousPage);
        this.setKey(pageName);
        this.messages = messages;
        this.defaultMessage = defaultMesage;
        this.connectionModel = ConfigurationModel.getConnection((String)this.key);
        this.fields = this.connectionModel.getConfigurationFields();
        String title = this.connectionModel.getDescription();
        this.setTitle(title);
    }

    public void addValidator(Validator validator) {
        int length = this.validators.length;
        Validator[] validators = new Validator[length + 1];
        if (length > 0) {
            System.arraycopy(this.validators, 0, validators, 0, length);
        }
        validators[length] = validator;
        this.validators = validators;
    }

    protected void createCustom(Composite composite) {
        ConfigurationField[] fields = this.fields;
        int i = 0;
        while (i < fields.length) {
            boolean deprecated;
            ConfigurationField field = fields[i];
            CustomParameterElement customParameterElement = field.getCustomParameterElement();
            boolean bl = customParameterElement == null ? false : (deprecated = customParameterElement.getDeprecated() != null);
            if (!deprecated) {
                String name = field.getConfigurationNameQualified();
                String key = "connection." + name;
                String displayName = field.getDisplayName();
                String description = field.getDescription();
                String codeType = field.getCodeType();
                Validator validator = new Validator(this);
                if ("int".equals(codeType)) {
                    validator = new IntegerValidator(this);
                } else if ("long".equals(codeType)) {
                    validator = new LongValidator(this);
                } else if ("short".equals(codeType)) {
                    validator = new ShortValidator(this);
                } else if ("byte".equals(codeType)) {
                    validator = new ByteValidator(this);
                } else if ("double".equals(codeType)) {
                    validator = new DoubleValidator(this);
                } else if ("float".equals(codeType)) {
                    validator = new FloatValidator(this);
                }
                new Validator(this);
                String hint = description;
                String defaultValue = field.getValue();
                boolean required = customParameterElement != null ? "true".equals(customParameterElement.getRequired()) : false;
                String niceName = displayName != null ? displayName : name;
                Button button = new Button(composite, 16416);
                button.setData((Object)key);
                button.setEnabled(!required);
                button.setSelection(required);
                button.addSelectionListener((SelectionListener)this);
                if (hint != null && hint.length() > 0) {
                    button.setToolTipText("Select to enable " + hint);
                }
                button.addListener(24, (Listener)this);
                Label label = new Label(composite, 16384);
                label.setText(niceName);
                if (hint != null && hint.length() > 0) {
                    label.setToolTipText(hint);
                }
                if (required) {
                    label.setFont(this.getFontBold());
                }
                String[] items = new String[]{defaultValue};
                String comboValue = defaultValue;
                int comboStyle = 2048;
                if (customParameterElement != null) {
                    List list = customParameterElement.getAllChildrenWithTagCode(77);
                    int size = list.size();
                    if (size > 0) {
                        String[] eitems = new String[size];
                        comboStyle = 2056;
                        validator = null;
                        int j = 0;
                        while (j < size) {
                            String labelValue;
                            EnumElement enumElement = (EnumElement)list.get(j);
                            eitems[j] = labelValue = enumElement.getLabel();
                            if (j == 0) {
                                comboValue = labelValue;
                            }
                            ++j;
                        }
                        items = eitems;
                    } else {
                        String minimumString = customParameterElement.getMinimum();
                        String maximumString = customParameterElement.getMaximum();
                        try {
                            long range;
                            long minimum = Long.parseLong(minimumString);
                            validator.setMinimum(minimumString);
                            long defaultLong = Long.parseLong(defaultValue);
                            if (defaultLong < minimum) {
                                comboValue = minimumString;
                            }
                            long maximum = Long.parseLong(maximumString);
                            validator.setMaximum(maximumString);
                            if (defaultLong > maximum) {
                                comboValue = maximumString;
                            }
                            if ((range = maximum - minimum) < 21L) {
                                comboStyle = 2056;
                                validator = null;
                                items = new String[(int)range + 1];
                                int k = 0;
                                while ((long)k <= range) {
                                    items[k] = Long.toString(minimum + (long)k);
                                    ++k;
                                }
                            }
                        }
                        catch (Exception exception) {
                            items = new String[]{minimumString, maximumString};
                        }
                    }
                }
                Combo text = new Combo(composite, comboStyle);
                text.setItems(items);
                GridData data = new GridData(4);
                data.horizontalSpan = 1;
                data.verticalSpan = 1;
                data.horizontalAlignment = 4;
                data.grabExcessHorizontalSpace = true;
                data.grabExcessVerticalSpace = false;
                text.setLayoutData((Object)data);
                text.setToolTipText(hint);
                text.addListener(24, (Listener)this);
                this.putWidget(String.valueOf(key) + ".checkbox", (Widget)button);
                this.putWidget(key, (Widget)text);
                text.setText(comboValue);
                text.setEnabled(required);
                if (validator != null) {
                    validator.setButton(button);
                    validator.setLabel(label);
                    validator.setCombo(text);
                    this.addValidator(validator);
                }
            }
            ++i;
        }
    }

    protected String[] createItems(ConfigurationField field) {
        List list;
        int size;
        CustomParameterElement customParameterElement = field.getCustomParameterElement();
        if (customParameterElement != null && (size = (list = customParameterElement.getAllChildrenWithTagCode(77)).size()) > 0) {
            String[] items = new String[size];
            int i = 0;
            while (i < size) {
                String label;
                EnumElement enumElement = (EnumElement)list.get(i);
                items[i] = label = enumElement.getLabel();
                ++i;
            }
            return items;
        }
        String defaultValue = field.getValue();
        return new String[]{"", defaultValue};
    }

    public ConfigurationModel getConnectionModel() {
        return this.connectionModel;
    }

    protected String getKey() {
        return this.key;
    }

    public String getString(String key) {
        return this.messages.getString(key);
    }

    public Validator[] getValidators() {
        return this.validators;
    }

    public void performHelp() {
        super.performHelp();
    }

    public void setConnectionModel(ConfigurationModel connectionModel) {
        this.connectionModel = connectionModel;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValidators(Validator[] validators) {
        this.validators = validators;
    }

    protected boolean updatePageErrors() {
        int i = 0;
        while (i < this.validators.length) {
            boolean isValid = this.validators[i].isValid();
            if (!isValid) {
                return false;
            }
            ++i;
        }
        this.update(true, false, null, this.defaultMessage);
        return true;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Button button;
        Object data;
        if (e.widget instanceof Button && (data = (button = (Button)e.widget).getData()) != null) {
            Widget widget = this.getWidget(data.toString());
            if (widget instanceof Text) {
                ((Text)widget).setEditable(button.getSelection());
            } else if (widget instanceof Combo) {
                ((Combo)widget).setEnabled(button.getSelection());
            }
        }
    }
}

