/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.soda.sat.plugin.activator.ui.internal.util.FileManager;
import org.eclipse.soda.sat.plugin.activator.ui.internal.util.api.IPropertiesFileManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesFileManager
extends FileManager
implements IPropertiesFileManager {
    private Properties properties;
    private Map<String, String> updates;
    private Set<String> deletions;

    public PropertiesFileManager(IFile file) {
        super(file);
        this.setUpdates(new HashMap<String, String>(37));
        this.setDeletions(new HashSet<String>(37));
    }

    private void applyDeletions() throws CoreException, IOException {
        Properties properties = this.getProperties();
        Set<String> set = this.getDeletions();
        boolean empty = set.isEmpty();
        if (empty) {
            return;
        }
        for (String key : set) {
            properties.remove(key);
        }
        set.clear();
    }

    private void applyUpdates() throws CoreException, IOException {
        Map<String, String> map = this.getUpdates();
        boolean empty = map.isEmpty();
        if (empty) {
            return;
        }
        Properties properties = this.getProperties();
        Set<String> set = map.keySet();
        for (String key : set) {
            String value = map.get(key);
            properties.put(key, value);
        }
        map.clear();
    }

    private Properties createProperties() throws CoreException, IOException {
        Properties properties = new Properties();
        IFile file = this.getFile();
        InputStream stream = null;
        try {
            stream = file.getContents(true);
            properties.load(stream);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String key) {
        Object lock;
        Set<String> set = this.getDeletions();
        Object object = lock = this.getLock();
        synchronized (object) {
            set.add(key);
            this.setDirty(true);
        }
    }

    @Override
    protected String getContents() throws CoreException, IOException {
        String contents = this.toString();
        return contents;
    }

    private Set<String> getDeletions() {
        return this.deletions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getProperties() throws CoreException, IOException {
        PropertiesFileManager propertiesFileManager = this;
        synchronized (propertiesFileManager) {
            if (this.properties == null) {
                Properties properties = this.createProperties();
                this.setProperties(properties);
            }
        }
        return this.properties;
    }

    private Map<String, String> getUpdates() {
        return this.updates;
    }

    @Override
    protected void postApplyChanges() throws CoreException, IOException {
        Properties properties = this.createProperties();
        this.setProperties(properties);
    }

    @Override
    protected void preApplyChanges() throws CoreException, IOException {
        this.applyDeletions();
        this.applyUpdates();
    }

    @Override
    protected void printOn(StringBuffer buffer) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(150);
        Properties properties = this.getProperties();
        properties.store(stream, null);
        String value = stream.toString();
        buffer.append(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, String value) {
        Object lock;
        Map<String, String> map = this.getUpdates();
        Object object = lock = this.getLock();
        synchronized (object) {
            map.put(key, value);
            this.setDirty(true);
        }
    }

    private void setDeletions(Set<String> deletions) {
        this.deletions = deletions;
    }

    private void setProperties(Properties properties) {
        this.properties = properties;
    }

    private void setUpdates(Map<String, String> updates) {
        this.updates = updates;
    }
}

