/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal.pages;

import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.internal.resources.OS;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardModel;
import org.eclipse.soda.sat.plugin.activator.IExportedServiceDetails;
import org.eclipse.soda.sat.plugin.activator.IImportedServiceDetails;
import org.eclipse.soda.sat.plugin.activator.ui.internal.api.IActivatorWizard;
import org.eclipse.soda.sat.plugin.activator.ui.internal.bundle.Activator;
import org.eclipse.soda.sat.plugin.activator.ui.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.AbstractActivatorWizardPage;
import org.eclipse.soda.sat.plugin.ui.util.FactoryUtility;
import org.eclipse.soda.sat.plugin.ui.util.IHandyPromptDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiscellaneousActivatorWizardPage
extends AbstractActivatorWizardPage {
    private static final String CONFIRMATION_REQUIRED_KEY = "MiscellaneousActivatorWizardPage.ConfirmationRequired";
    private static final String CREATE_BUNDLE_ACTIVATOR_LAZILY_CONFIRMATION_KEY = "MiscellaneousActivatorWizardPage.CreateBundleActivatorLazilyConfirmation";
    private static final String CREATE_BUNDLE_ACTIVATOR_LAZILY_KEY = "MiscellaneousActivatorWizardPage.CreateBundleActivatorLazily";
    private static final String CUSTOM_ACTIVATE_AND_DEACTIVATE_KEY = "MiscellaneousActivatorWizardPage.CustomActivateAndDeactivate";
    private static final String CUSTOM_START_AND_STOP_KEY = "MiscellaneousActivatorWizardPage.CustomStartAndStop";
    private static final String DESCRIPTION_KEY = "MiscellaneousActivatorWizardPage.Description";
    private static final String FROM_FILE_SYSTEM_KEY = "MiscellaneousActivatorWizardPage.FromFileSystem";
    private static final String FROM_PACKAGE_RESOURCE_KEY = "MiscellaneousActivatorWizardPage.FromPackageResource";
    private static final String HAS_UNINSTALL_POLICY_KEY = "MiscellaneousActivatorWizardPage.HasUninstallPolicy";
    private static final String INVALID_FILENAME_KEY = "MiscellaneousActivatorWizardPage.InvalidFilename";
    private static final String LAZY_BUNDLE_ACTIVATOR_PROPERTIES_FILENAME_KEY = "MiscellaneousActivatorWizardPage.LazyBundleActivatorPropertiesFilename";
    private static final String LAZY_BUNDLE_ACTIVATOR_PROPERTIES_FILENAME_TOOL_TIP_KEY = "MiscellaneousActivatorWizardPage.LazyBundleActivatorPropertiesFilenameToolTip";
    private static final String LOAD_PROPERTIES_KEY = "MiscellaneousActivatorWizardPage.LoadProperties";
    private static final String NORMAL_PRIORITY_PLUS_ONE_KEY = "MiscellaneousActivatorWizardPage.NormalPriorityPlusOne";
    private static final String NORMAL_PRIORITY_KEY = "MiscellaneousActivatorWizardPage.NormalPriority";
    private static final String NORMAL_PRIORITY_MINUS_ONE_KEY = "MiscellaneousActivatorWizardPage.NormalPriorityMinusOne";
    private static final String NO_SELECTED_LOAD_PROPERTIES_POLICY_BUTTON_KEY = "MiscellaneousActivatorWizardPage.NoSelectedLoadPropertiesPolicyButton";
    private static final String NO_SELECTED_UNINSTALL_POLICY_BUTTON_KEY = "MiscellaneousActivatorWizardPage.NoSelectedUninstallPolicyButton";
    private static final String PROPERTIES_FILENAME_KEY = "MiscellaneousActivatorWizardPage.PropertiesFilename";
    private static final String PROPERTIES_FILENAME_TOOL_TIP_KEY = "MiscellaneousActivatorWizardPage.PropertiesFilenameToolTip";
    private static final String START_ASYNCHRONOUSLY_KEY = "MiscellaneousActivatorWizardPage.StartAsynchronously";
    private static final String TITLE_KEY = "MiscellaneousActivatorWizardPage.Title";
    private static final String TRANSIENT_KEY = "MiscellaneousActivatorWizardPage.Transient";
    private static final String UNINSTALLABLE_KEY = "MiscellaneousActivatorWizardPage.Uninstallable";
    private static final String UNRECOGNIZED_LOAD_PROPERTIES_POLICY = "MiscellaneousActivatorWizardPage.UnrecognizedLoadPropertiesPolicy";
    private static final String UNRECOGNIZED_START_ASYNCHRONOUSLY_PRIORITY_DELTA = "MiscellaneousActivatorWizardPage.UnrecognizedStartAsynchronouslyPriorityDelta";
    private static final String UNRECOGNIZED_UNINSTALL_POLICY = "MiscellaneousActivatorWizardPage.UnrecognizedUninstallPolicy";
    private static final String HELP_CONTEXT_ID = "org.eclipse.soda.sat.plugin.activator.ui.miscellaneousActivatorWizardPage";
    public static final String PAGE_NAME = MiscellaneousActivatorWizardPage.class.getName();
    private Button createBundleActivatorLazilyButton;
    private Button customActivateAndDeactivateButton;
    private Button customStartAndStopButton;
    private Button fromFileSystemButton;
    private Button fromPackageResourceButton;
    private Button hasUninstallPolicyButton;
    private Button loadPropertiesButton;
    private Button normalPriorityButton;
    private Button normalPriorityMinusOneButton;
    private Button normalPriorityPlusOneButton;
    private Button transientButton;
    private Button startAsynchronouslyButton;
    private Button uninstallableButton;
    private Label propertiesFilenameLabel;
    private Label lazyBundleActivatorPropertiesFilenameLabel;
    private Text propertiesFilenameText;
    private Text lazyBundleActivatorPropertiesFilenameText;
    private boolean createBundleActivatorLazilyConfirmed;

    public MiscellaneousActivatorWizardPage(IActivatorWizard parent) {
        super(PAGE_NAME, parent);
        this.setCreateBundleActivatorLazilyConfirmed(false);
    }

    private void buildCreateBundleActivatorLazilyRow(Composite parent) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MiscellaneousActivatorWizardPage.this.handleCreateBundleActivatorLazilyCheckboxButtonClicked();
            }
        };
        Button button = this.createButton(parent, 32, CREATE_BUNDLE_ACTIVATOR_LAZILY_KEY, (SelectionListener)listener);
        this.setCreateBundleActivatorLazilyButton(button);
        this.buildLazyBundleActivatorPropertiesRow(parent);
    }

    private void buildCustomActivateAndDeactivateRow(Composite parent) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MiscellaneousActivatorWizardPage.this.handleCustomActivateAndDeactivateCheckboxButtonClicked();
            }
        };
        Button button = this.createButton(parent, 32, CUSTOM_ACTIVATE_AND_DEACTIVATE_KEY, (SelectionListener)listener);
        this.setCustomActivateAndDeactivateButton(button);
        IActivatorWizardModel model = this.getModel();
        boolean state = model.getCustomActivateAndDeactivate();
        button.setSelection(state);
    }

    private void buildCustomStartAndStopRow(Composite parent) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MiscellaneousActivatorWizardPage.this.handleCustomStartAndStopCheckboxButtonClicked();
            }
        };
        Button button = this.createButton(parent, 32, CUSTOM_START_AND_STOP_KEY, (SelectionListener)listener);
        this.setCustomStartAndStopButton(button);
        IActivatorWizardModel model = this.getModel();
        boolean state = model.getCustomStartAndStop();
        button.setSelection(state);
    }

    private void buildFromFileSystemRow(Composite parent, SelectionListener listener) {
        Button button = this.createButton(parent, 16, FROM_FILE_SYSTEM_KEY, listener);
        Integer data = new Integer(2);
        button.setData((Object)data);
        this.setFromFileSystemButton(button);
    }

    private void buildFromPackageResourceRow(Composite parent, SelectionListener listener) {
        Button button = this.createButton(parent, 16, FROM_PACKAGE_RESOURCE_KEY, listener);
        Integer data = new Integer(1);
        button.setData((Object)data);
        this.setFromPackageResourceButton(button);
    }

    private void buildHasUninstallPolicyRow(Composite parent) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MiscellaneousActivatorWizardPage.this.handleHasUninstallPolicyCheckboxButtonClicked();
            }
        };
        Button button = this.createButton(parent, 32, HAS_UNINSTALL_POLICY_KEY, (SelectionListener)listener);
        this.setHasUninstallPolicyButton(button);
        IActivatorWizardModel model = this.getModel();
        int policy = model.getUninstallPolicy();
        boolean state = policy != 0;
        button.setSelection(state);
        this.buildUninstallPolicyRow(parent);
    }

    private void buildLazyBundleActivatorPropertiesFilenameRow(Composite parent) {
        Composite composite = this.createComposite(parent, 2, true, false);
        Label label = this.createLabel(composite, LAZY_BUNDLE_ACTIVATOR_PROPERTIES_FILENAME_KEY);
        this.setLazyBundleActivatorPropertiesFilenameLabel(label);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                MiscellaneousActivatorWizardPage.this.handleLazyBundleActivatorPropertiesFilenameTextChanged();
            }
        };
        Text text = this.createText(composite, listener, LAZY_BUNDLE_ACTIVATOR_PROPERTIES_FILENAME_TOOL_TIP_KEY);
        this.setLazyBundleActivatorPropertiesFilenameText(text);
        KeyListener keyListener = this.createFilenameKeyListener(true);
        text.addKeyListener(keyListener);
        IActivatorWizardModel model = this.getModel();
        String value = model.getLazyBundleActivatorPropertiesFilename();
        text.setText(value);
    }

    private void buildLazyBundleActivatorPropertiesRow(Composite parent) {
        Composite composite = this.createComposite(parent, 1, true, false);
        this.setMarginWidth(composite, 5);
        this.buildLazyBundleActivatorPropertiesFilenameRow(composite);
        IActivatorWizardModel model = this.getModel();
        boolean selection = model.getCreateBundleActivatorLazily();
        this.setCreateBundleActivatorLazilyButtonSelection(selection);
    }

    private void buildLoadPropertiesFileRow(Composite parent) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MiscellaneousActivatorWizardPage.this.handleLoadPropertiesFileCheckboxButtonClicked();
            }
        };
        Button button = this.createButton(parent, 32, LOAD_PROPERTIES_KEY, (SelectionListener)listener);
        this.setLoadPropertiesButton(button);
        IActivatorWizardModel model = this.getModel();
        int policy = model.getLoadPropertiesPolicy();
        boolean state = policy != 0;
        button.setSelection(state);
        this.buildPropertiesFilenameRow(parent);
        this.buildLoadPropertiesFromRow(parent);
    }

    private void buildLoadPropertiesFromRow(Composite parent) {
        Composite composite = this.createComposite(parent, 1, true, false);
        this.setMarginWidth(composite, 5);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                MiscellaneousActivatorWizardPage.this.handleLoadPropertiesButtonClicked(button);
            }
        };
        this.buildFromPackageResourceRow(composite, (SelectionListener)listener);
        this.buildFromFileSystemRow(composite, (SelectionListener)listener);
        IActivatorWizardModel model = this.getModel();
        int policy = model.getLoadPropertiesPolicy();
        this.setLoadPropertiesFromButtonSelection(policy);
    }

    private void buildNormalPriorityMinusOneRow(Composite parent, SelectionListener listener) {
        Button button = this.createButton(parent, 16, NORMAL_PRIORITY_MINUS_ONE_KEY, listener);
        Integer data = new Integer(-1);
        button.setData((Object)data);
        this.setNormalPriorityMinusOneButton(button);
    }

    private void buildNormalPriorityPlusOneRow(Composite parent, SelectionListener listener) {
        Button button = this.createButton(parent, 16, NORMAL_PRIORITY_PLUS_ONE_KEY, listener);
        Integer data = new Integer(1);
        button.setData((Object)data);
        this.setNormalPriorityPlusOneButton(button);
    }

    private void buildNormalPriorityRow(Composite parent, SelectionListener listener) {
        Button button = this.createButton(parent, 16, NORMAL_PRIORITY_KEY, listener);
        Integer data = new Integer(0);
        button.setData((Object)data);
        this.setNormalPriorityButton(button);
    }

    @Override
    protected void buildPage(Composite parent) {
        this.buildCustomStartAndStopRow(parent);
        this.buildCustomActivateAndDeactivateRow(parent);
        this.buildSeparator(parent);
        this.buildStartAsynchronouslyRow(parent);
        this.buildSeparator(parent);
        this.buildLoadPropertiesFileRow(parent);
        this.buildSeparator(parent);
        this.buildHasUninstallPolicyRow(parent);
        this.buildSeparator(parent);
        this.buildCreateBundleActivatorLazilyRow(parent);
    }

    private void buildPropertiesFilenameRow(Composite parent) {
        Composite composite = this.createComposite(parent, 2, true, false);
        this.setMarginWidth(composite, 5);
        Label label = this.createLabel(composite, PROPERTIES_FILENAME_KEY);
        this.setPropertiesFilenameLabel(label);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                MiscellaneousActivatorWizardPage.this.handlePropertiesFilenameTextChanged();
            }
        };
        Text text = this.createText(composite, listener, PROPERTIES_FILENAME_TOOL_TIP_KEY);
        this.setPropertiesFilenameText(text);
        KeyListener keyListener = this.createFilenameKeyListener();
        text.addKeyListener(keyListener);
        IActivatorWizardModel model = this.getModel();
        String value = model.getPropertiesFilename();
        text.setText(value);
    }

    private void buildStartAsynchronouslyPriorityRow(Composite parent) {
        Composite composite = this.createComposite(parent, 1, true, false);
        this.setMarginWidth(composite, 5);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                MiscellaneousActivatorWizardPage.this.handleStartAsynchronouslyPriorityButtonClicked(button);
            }
        };
        this.buildNormalPriorityPlusOneRow(composite, (SelectionListener)listener);
        this.buildNormalPriorityRow(composite, (SelectionListener)listener);
        this.buildNormalPriorityMinusOneRow(composite, (SelectionListener)listener);
        IActivatorWizardModel model = this.getModel();
        int delta = model.getStartAsynchronouslyNormalPriorityDelta();
        this.setStartAsynchronouslyPriorityButtonSelection(delta);
    }

    private void buildStartAsynchronouslyRow(Composite parent) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MiscellaneousActivatorWizardPage.this.handleStartAsynchronouslyCheckboxButtonClicked();
            }
        };
        Button button = this.createButton(parent, 32, START_ASYNCHRONOUSLY_KEY, (SelectionListener)listener);
        this.setStartAsynchronouslyButton(button);
        this.buildStartAsynchronouslyPriorityRow(parent);
        IActivatorWizardModel model = this.getModel();
        boolean state = model.getStartAsynchronously();
        this.setStartAsynchronouslyChangedSelection(state);
    }

    private void buildTransientRow(Composite parent, SelectionListener listener) {
        Button button = this.createButton(parent, 16, TRANSIENT_KEY, listener);
        Integer data = new Integer(2);
        button.setData((Object)data);
        this.setTransientButton(button);
    }

    private void buildUninstallableRow(Composite parent, SelectionListener listener) {
        Button button = this.createButton(parent, 16, UNINSTALLABLE_KEY, listener);
        Integer data = new Integer(1);
        button.setData((Object)data);
        this.setUninstallableButton(button);
    }

    private void buildUninstallPolicyRow(Composite parent) {
        Composite composite = this.createComposite(parent, 1, true, false);
        this.setMarginWidth(composite, 5);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                MiscellaneousActivatorWizardPage.this.handleUninstallPolicyButtonClicked(button);
            }
        };
        this.buildUninstallableRow(composite, (SelectionListener)listener);
        this.buildTransientRow(composite, (SelectionListener)listener);
        IActivatorWizardModel model = this.getModel();
        int policy = model.getUninstallPolicy();
        this.setUninstallPolicyButtonSelection(policy);
    }

    private KeyListener createFilenameKeyListener() {
        KeyListener listener = this.createFilenameKeyListener(false);
        return listener;
    }

    private KeyListener createFilenameKeyListener(final boolean allowSeparatorChar) {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                MiscellaneousActivatorWizardPage.this.handleFilenameKeyPressed(event, allowSeparatorChar);
            }
        };
    }

    private Button getCreateBundleActivatorLazilyButton() {
        return this.createBundleActivatorLazilyButton;
    }

    private Button getCustomActivateAndDeactivateButton() {
        return this.customActivateAndDeactivateButton;
    }

    private Button getCustomStartAndStopButton() {
        return this.customStartAndStopButton;
    }

    private Button getFromFileSystemButton() {
        return this.fromFileSystemButton;
    }

    private Button getFromPackageResourceButton() {
        return this.fromPackageResourceButton;
    }

    private Button getHasUninstallPolicyButton() {
        return this.hasUninstallPolicyButton;
    }

    @Override
    protected String getHelpContextId() {
        return HELP_CONTEXT_ID;
    }

    private String getLazyBundleActivatorPropertiesFilename() {
        Text text = this.getLazyBundleActivatorPropertiesFilenameText();
        String value = text.getText();
        return value;
    }

    private Label getLazyBundleActivatorPropertiesFilenameLabel() {
        return this.lazyBundleActivatorPropertiesFilenameLabel;
    }

    private Text getLazyBundleActivatorPropertiesFilenameText() {
        return this.lazyBundleActivatorPropertiesFilenameText;
    }

    private Button getLoadPropertiesButton() {
        return this.loadPropertiesButton;
    }

    @Override
    protected String getMessageString() {
        return Messages.getString(DESCRIPTION_KEY);
    }

    private Button getNormalPriorityButton() {
        return this.normalPriorityButton;
    }

    private Button getNormalPriorityMinusOneButton() {
        return this.normalPriorityMinusOneButton;
    }

    private Button getNormalPriorityPlusOneButton() {
        return this.normalPriorityPlusOneButton;
    }

    private String getPropertiesFilename() {
        Text text = this.getPropertiesFilenameText();
        String value = text.getText();
        return value;
    }

    private Label getPropertiesFilenameLabel() {
        return this.propertiesFilenameLabel;
    }

    private Text getPropertiesFilenameText() {
        return this.propertiesFilenameText;
    }

    private Button getStartAsynchronouslyButton() {
        return this.startAsynchronouslyButton;
    }

    @Override
    protected String getTitleString() {
        return Messages.getString(TITLE_KEY);
    }

    private Button getTransientButton() {
        return this.transientButton;
    }

    private Button getUninstallableButton() {
        return this.uninstallableButton;
    }

    @Override
    protected void handleBundleSymbolicNameChanged(String bundleSymbolicName) {
        super.handleBundleSymbolicNameChanged(bundleSymbolicName);
        IActivatorWizardModel model = this.getModel();
        String filename = model.getPropertiesFilename();
        Text text = this.getPropertiesFilenameText();
        text.setText(filename);
    }

    @Override
    protected void handleCreateBundleActivatorLazilyChanged(boolean selection) {
        this.setCreateBundleActivatorLazilyButtonSelection(selection);
    }

    private void handleCreateBundleActivatorLazilyCheckboxButtonClicked() {
        Button button = this.getCreateBundleActivatorLazilyButton();
        boolean selected = button.getSelection();
        IActivatorWizardModel model = this.getModel();
        model.setCreateBundleActivatorLazily(selected);
        if (!selected) {
            return;
        }
        boolean state = this.hasRequiredImportedServices();
        if (state) {
            return;
        }
        boolean confirmed = this.isCreateBundleActivatorLazilyConfirmed();
        if (confirmed) {
            return;
        }
        selected = this.openCreateBundleActivatorLazilyConfirmationDialog();
        model.setCreateBundleActivatorLazily(selected);
    }

    @Override
    protected void handleCustomActivateAndDeactivateChanged(boolean selection) {
        Button button = this.getCustomActivateAndDeactivateButton();
        button.setSelection(selection);
    }

    private void handleCustomActivateAndDeactivateCheckboxButtonClicked() {
        Button button = this.getCustomActivateAndDeactivateButton();
        boolean state = button.getSelection();
        IActivatorWizardModel model = this.getModel();
        model.setCustomActivateAndDeactivate(state);
    }

    @Override
    protected void handleCustomStartAndStopChanged(boolean selection) {
        Button button = this.getCustomStartAndStopButton();
        button.setSelection(selection);
    }

    private void handleCustomStartAndStopCheckboxButtonClicked() {
        Button button = this.getCustomStartAndStopButton();
        boolean state = button.getSelection();
        IActivatorWizardModel model = this.getModel();
        model.setCustomStartAndStop(state);
    }

    @Override
    protected void handleExportedServiceDetailsChanged(List<IExportedServiceDetails> details) {
        this.setCustomActivateAndDeactivateSelection();
    }

    private void handleFilenameKeyPressed(KeyEvent event, boolean allowSeparatorChar) {
        boolean valid = this.isSpecialKey(event);
        if (valid) {
            return;
        }
        char ch = event.character;
        valid = Character.isLetterOrDigit(ch);
        if (valid) {
            return;
        }
        boolean bl = valid = ch == '.' || ch == '-' || ch == '_';
        if (valid) {
            return;
        }
        if (allowSeparatorChar && ch == File.separatorChar) {
            int length;
            Text text = (Text)event.widget;
            int position = text.getCaretPosition();
            String value = text.getText();
            if (position > 0) {
                boolean bl2 = valid = value.charAt(position - 1) != File.separatorChar;
            }
            if (valid && position < (length = value.length())) {
                boolean bl3 = valid = value.charAt(position) != File.separatorChar;
            }
            if (valid) {
                return;
            }
        }
        event.doit = false;
    }

    private void handleHasUninstallPolicyCheckboxButtonClicked() {
        Button button = this.getHasUninstallPolicyButton();
        boolean selected = button.getSelection();
        IActivatorWizardModel model = this.getModel();
        if (!selected) {
            model.setUninstallPolicy(0);
        } else {
            selected = this.uninstallableButton.getSelection();
            if (selected) {
                model.setUninstallPolicy(1);
                return;
            }
            selected = this.transientButton.getSelection();
            if (selected) {
                model.setUninstallPolicy(2);
                return;
            }
            this.logErrorNoSelectedUninstallPolicyButton();
        }
    }

    @Override
    protected void handleImportedServiceDetailsChanged(List<IImportedServiceDetails> details) {
        this.setCustomActivateAndDeactivateSelection();
    }

    @Override
    protected void handleLazyBundleActivatorPropertiesFilenameChanged(String lazyBundleActivatorPropertiesFilename) {
        this.validatePage();
        String value = this.getLazyBundleActivatorPropertiesFilename();
        boolean equal = value.equals(lazyBundleActivatorPropertiesFilename);
        if (equal) {
            return;
        }
        Text text = this.getLazyBundleActivatorPropertiesFilenameText();
        text.setText(lazyBundleActivatorPropertiesFilename);
    }

    private void handleLazyBundleActivatorPropertiesFilenameTextChanged() {
        Text text = this.getLazyBundleActivatorPropertiesFilenameText();
        String value = text.getText();
        IActivatorWizardModel model = this.getModel();
        model.setLazyBundleActivatorPropertiesFilename(value);
    }

    private void handleLoadPropertiesButtonClicked(Button button) {
        Integer data = (Integer)button.getData();
        int value = data;
        IActivatorWizardModel model = this.getModel();
        model.setLoadPropertiesPolicy(value);
    }

    private void handleLoadPropertiesFileCheckboxButtonClicked() {
        Button button = this.getLoadPropertiesButton();
        boolean selected = button.getSelection();
        IActivatorWizardModel model = this.getModel();
        if (!selected) {
            model.setLoadPropertiesPolicy(0);
        } else {
            selected = this.fromFileSystemButton.getSelection();
            if (selected) {
                model.setLoadPropertiesPolicy(2);
                return;
            }
            selected = this.fromPackageResourceButton.getSelection();
            if (selected) {
                model.setLoadPropertiesPolicy(1);
                return;
            }
            this.logErrorNoSelectedLoadPropertiesFilePolicyButton();
        }
    }

    @Override
    protected void handleLoadPropertiesPolicyChanged(int policy) {
        this.setLoadPropertiesFromButtonSelection(policy);
    }

    @Override
    protected void handlePropertiesFilenameChanged(String propertiesFilename) {
        this.validatePage();
        String value = this.getPropertiesFilename();
        boolean equal = value.equals(propertiesFilename);
        if (equal) {
            return;
        }
        Text text = this.getPropertiesFilenameText();
        text.setText(propertiesFilename);
    }

    private void handlePropertiesFilenameTextChanged() {
        Text text = this.getPropertiesFilenameText();
        String value = text.getText();
        IActivatorWizardModel model = this.getModel();
        model.setPropertiesFilename(value);
    }

    @Override
    protected void handleStartAsynchronouslyChanged(boolean selection) {
        this.setStartAsynchronouslyChangedSelection(selection);
    }

    private void handleStartAsynchronouslyCheckboxButtonClicked() {
        Button button = this.getStartAsynchronouslyButton();
        boolean state = button.getSelection();
        IActivatorWizardModel model = this.getModel();
        model.setStartAsynchronously(state);
    }

    @Override
    protected void handleStartAsynchronouslyNormalPriorityDeltaChanged(int startAsynchronouslyNormalPriorityDelta) {
        this.setStartAsynchronouslyPriorityButtonSelection(startAsynchronouslyNormalPriorityDelta);
    }

    private void handleStartAsynchronouslyPriorityButtonClicked(Button button) {
        Integer data = (Integer)button.getData();
        int value = data;
        IActivatorWizardModel model = this.getModel();
        model.setStartAsynchronouslyNormalPriorityDelta(value);
    }

    private void handleUninstallPolicyButtonClicked(Button button) {
        Integer data = (Integer)button.getData();
        int value = data;
        IActivatorWizardModel model = this.getModel();
        model.setUninstallPolicy(value);
    }

    @Override
    protected void handleUninstallPolicyChanged(int uninstallPolicy) {
        this.setUninstallPolicyButtonSelection(uninstallPolicy);
    }

    private boolean hasRequiredImportedServices() {
        IActivatorWizardModel model = this.getModel();
        boolean state = model.hasImportedServices();
        if (!state) {
            return false;
        }
        List list = model.getImportedServicesDetails();
        for (IImportedServiceDetails details : list) {
            boolean required;
            boolean bl = required = !details.isOptional();
            if (!required) continue;
            return true;
        }
        return false;
    }

    private boolean isCreateBundleActivatorLazilyConfirmed() {
        return this.createBundleActivatorLazilyConfirmed;
    }

    private boolean isSpecialKey(KeyEvent event) {
        char ch = event.character;
        if (ch == '\u007f') {
            return true;
        }
        if (ch == '\b') {
            return true;
        }
        int keyCode = event.keyCode;
        if (keyCode == 0x1000003) {
            return true;
        }
        if (keyCode == 0x1000004) {
            return true;
        }
        if (keyCode == 0x1000007) {
            return true;
        }
        return keyCode == 0x1000008;
    }

    private boolean isValidFilename(String filename) {
        int length = filename.length();
        if (length == 0) {
            return false;
        }
        boolean valid = OS.isNameValid((String)filename);
        if (!valid) {
            return false;
        }
        return valid;
    }

    private boolean isValidLazyBundleActivatorPropertiesFilename() {
        String filename = this.getLazyBundleActivatorPropertiesFilename();
        boolean valid = this.isValidFilename(filename);
        return valid;
    }

    private boolean isValidPropertiesFilename() {
        String filename = this.getPropertiesFilename();
        boolean valid = this.isValidFilename(filename);
        return valid;
    }

    private void logError(String message) {
        this.logError(message, null);
    }

    private void logError(String message, Throwable throwable) {
        Activator activator = Activator.getDefault();
        activator.log(4, message, throwable);
    }

    private void logErrorNoSelectedLoadPropertiesFilePolicyButton() {
        String message = Messages.getString(NO_SELECTED_LOAD_PROPERTIES_POLICY_BUTTON_KEY);
        this.logError(message);
    }

    private void logErrorNoSelectedUninstallPolicyButton() {
        String message = Messages.getString(NO_SELECTED_UNINSTALL_POLICY_BUTTON_KEY);
        this.logError(message);
    }

    private void logErrorUnrecognizedLoadPropertiesPolicy(int policy) {
        String pattern = Messages.getString(UNRECOGNIZED_LOAD_PROPERTIES_POLICY);
        Object[] values = new Object[]{new Integer(policy)};
        String message = MessageFormat.format(pattern, values);
        this.logError(message);
    }

    private void logErrorUnrecognizedStartAsynchronouslyPriorityDelta(int priority) {
        String pattern = Messages.getString(UNRECOGNIZED_START_ASYNCHRONOUSLY_PRIORITY_DELTA);
        Object[] values = new Object[]{new Integer(priority)};
        String message = MessageFormat.format(pattern, values);
        this.logError(message);
    }

    private void logErrorUnrecognizedUninstallPolicy(int policy) {
        String pattern = Messages.getString(UNRECOGNIZED_UNINSTALL_POLICY);
        Object[] values = new Object[]{new Integer(policy)};
        String message = MessageFormat.format(pattern, values);
        this.logError(message);
    }

    private boolean openCreateBundleActivatorLazilyConfirmationDialog() {
        FactoryUtility utility = FactoryUtility.getInstance();
        Shell shell = this.getShell();
        String prompt = Messages.getString(CREATE_BUNDLE_ACTIVATOR_LAZILY_CONFIRMATION_KEY);
        IHandyPromptDialog dialog = utility.createHandyPromptDialog(shell, prompt);
        String title = Messages.getString(CONFIRMATION_REQUIRED_KEY);
        dialog.setTitle(title);
        dialog.useWarningIcon();
        dialog.setCancelButtonText(null);
        dialog.defaultButtonIsNo();
        int rc = dialog.open();
        boolean confirmed = rc == 2;
        this.setCreateBundleActivatorLazilyConfirmed(confirmed);
        boolean state = rc == 2 || rc == 1;
        return state;
    }

    private void setCreateBundleActivatorLazilyButton(Button createBundleActivatorLazilyButton) {
        this.createBundleActivatorLazilyButton = createBundleActivatorLazilyButton;
    }

    private void setCreateBundleActivatorLazilyButtonSelection(boolean selection) {
        Button button = this.getCreateBundleActivatorLazilyButton();
        button.setSelection(selection);
        Label label = this.getLazyBundleActivatorPropertiesFilenameLabel();
        label.setEnabled(selection);
        Text text = this.getLazyBundleActivatorPropertiesFilenameText();
        text.setEnabled(selection);
    }

    private void setCreateBundleActivatorLazilyConfirmed(boolean createBundleActivatorLazilyConfirmed) {
        this.createBundleActivatorLazilyConfirmed = createBundleActivatorLazilyConfirmed;
    }

    private void setCustomActivateAndDeactivateButton(Button customActivateAndDeactivateButton) {
        this.customActivateAndDeactivateButton = customActivateAndDeactivateButton;
    }

    private void setCustomActivateAndDeactivateSelection() {
        IActivatorWizardModel model = this.getModel();
        boolean hasImportedServices = model.hasImportedServices();
        boolean hasExportedServices = model.hasExportedServices();
        boolean empty = !hasImportedServices && !hasExportedServices;
        Button button = this.getCustomActivateAndDeactivateButton();
        button.setEnabled(empty);
        if (!empty) {
            model.setCustomActivateAndDeactivate(true);
        }
    }

    private void setCustomStartAndStopButton(Button customStartAndStopButton) {
        this.customStartAndStopButton = customStartAndStopButton;
    }

    private void setFromFileSystemButton(Button fromFileSystemButton) {
        this.fromFileSystemButton = fromFileSystemButton;
    }

    private void setFromPackageResourceButton(Button fromPackageResourceButton) {
        this.fromPackageResourceButton = fromPackageResourceButton;
    }

    private void setHasUninstallPolicyButton(Button hasUninstallPolicyButton) {
        this.hasUninstallPolicyButton = hasUninstallPolicyButton;
    }

    private void setLazyBundleActivatorPropertiesFilenameLabel(Label lazyBundleActivatorPropertiesFilenameLabel) {
        this.lazyBundleActivatorPropertiesFilenameLabel = lazyBundleActivatorPropertiesFilenameLabel;
    }

    private void setLazyBundleActivatorPropertiesFilenameText(Text lazyBundleActivatorPropertiesFilenameText) {
        this.lazyBundleActivatorPropertiesFilenameText = lazyBundleActivatorPropertiesFilenameText;
    }

    private void setLoadPropertiesButton(Button loadPropertiesFileButton) {
        this.loadPropertiesButton = loadPropertiesFileButton;
    }

    private void setLoadPropertiesFromButtonSelection(int policy) {
        Label label = this.getPropertiesFilenameLabel();
        Text text = this.getPropertiesFilenameText();
        Button fromPackageResourceButton = this.getFromPackageResourceButton();
        Button fromFileSystemButton = this.getFromFileSystemButton();
        boolean state = policy != 0;
        label.setEnabled(state);
        text.setEnabled(state);
        fromPackageResourceButton.setEnabled(state);
        fromFileSystemButton.setEnabled(state);
        if (policy == 1 || policy == 0) {
            fromPackageResourceButton.setSelection(true);
            fromFileSystemButton.setSelection(false);
        } else if (policy == 2) {
            fromPackageResourceButton.setSelection(false);
            fromFileSystemButton.setSelection(true);
        } else {
            this.logErrorUnrecognizedLoadPropertiesPolicy(policy);
            return;
        }
    }

    private void setNormalPriorityButton(Button normalPriorityButton) {
        this.normalPriorityButton = normalPriorityButton;
    }

    private void setNormalPriorityMinusOneButton(Button normalPriorityMinusOneButton) {
        this.normalPriorityMinusOneButton = normalPriorityMinusOneButton;
    }

    private void setNormalPriorityPlusOneButton(Button normalPriorityPlusOneButton) {
        this.normalPriorityPlusOneButton = normalPriorityPlusOneButton;
    }

    private void setPropertiesFilenameLabel(Label propertiesFilenameLabel) {
        this.propertiesFilenameLabel = propertiesFilenameLabel;
    }

    private void setPropertiesFilenameText(Text propertiesFilenameText) {
        this.propertiesFilenameText = propertiesFilenameText;
    }

    private void setStartAsynchronouslyButton(Button startAsynchronouslyButton) {
        this.startAsynchronouslyButton = startAsynchronouslyButton;
    }

    private void setStartAsynchronouslyChangedSelection(boolean selection) {
        Button button = this.getStartAsynchronouslyButton();
        button.setSelection(selection);
        Button control = this.getNormalPriorityPlusOneButton();
        control.setEnabled(selection);
        control = this.getNormalPriorityButton();
        control.setEnabled(selection);
        control = this.getNormalPriorityMinusOneButton();
        control.setEnabled(selection);
    }

    private void setStartAsynchronouslyPriorityButtonSelection(int priority) {
        Button button;
        if (priority == -1) {
            button = this.getNormalPriorityMinusOneButton();
        } else if (priority == 0) {
            button = this.getNormalPriorityButton();
        } else if (priority == 1) {
            button = this.getNormalPriorityPlusOneButton();
        } else {
            this.logErrorUnrecognizedStartAsynchronouslyPriorityDelta(priority);
            return;
        }
        button.setSelection(true);
    }

    private void setTransientButton(Button transientButton) {
        this.transientButton = transientButton;
    }

    private void setUninstallableButton(Button uninstallableButton) {
        this.uninstallableButton = uninstallableButton;
    }

    private void setUninstallPolicyButtonSelection(int policy) {
        Button uninstallableButton = this.getUninstallableButton();
        Button transientButton = this.getTransientButton();
        boolean state = policy != 0;
        uninstallableButton.setEnabled(state);
        transientButton.setEnabled(state);
        if (policy == 1 || policy == 0) {
            uninstallableButton.setSelection(true);
            transientButton.setSelection(false);
        } else if (policy == 2) {
            uninstallableButton.setSelection(false);
            transientButton.setSelection(true);
        } else {
            this.logErrorUnrecognizedUninstallPolicy(policy);
            return;
        }
    }

    private void validatePage() {
        boolean validPropertiesFilename = this.isValidPropertiesFilename();
        if (!validPropertiesFilename) {
            String filename = this.getPropertiesFilename();
            Object[] values = new Object[]{filename};
            String pattern = Messages.getString(INVALID_FILENAME_KEY);
            String message = MessageFormat.format(pattern, values);
            this.setErrorMessage(message);
            this.setPageComplete(false);
            return;
        }
        boolean validLazyBundleActivatorPropertiesFilename = this.isValidLazyBundleActivatorPropertiesFilename();
        if (!validLazyBundleActivatorPropertiesFilename) {
            String filename = this.getLazyBundleActivatorPropertiesFilename();
            Object[] values = new Object[]{filename};
            String pattern = Messages.getString(INVALID_FILENAME_KEY);
            String message = MessageFormat.format(pattern, values);
            this.setErrorMessage(message);
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }
}

