/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.util;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.soda.sat.core.framework.interfaces.ICharBuffer;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.internal.util.ConsoleLog;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.eclipse.soda.sat.core.util.MessageFormatter;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class LogProxy
implements LogService {
    private static final String LOG_LEVEL_UNKNOWN_KEY = "LogLevelIsUnknown";
    private static final char DATE_DELIMETER = '-';
    private static final int DEFAULT_BUFFER_SIZE = 5120;
    private static final char TIME_DELIMETER = ':';
    private static final char WHITESPACE = ' ';
    private static final char ZERO_PADDING = '0';
    private static final Calendar CALENDAR = Calendar.getInstance();
    private LogService log;
    private LogService consoleLog;
    private int logLevel;
    private ICharBuffer buffer;

    private static Calendar getCalendar() {
        Date now = new Date();
        CALENDAR.setTime(now);
        return CALENDAR;
    }

    public LogProxy() {
    }

    public LogProxy(LogService log) {
        this.setLog(log);
    }

    private void appendDate(Calendar calendar) {
        ICharBuffer buffer = this.getBuffer();
        int year = calendar.get(1);
        buffer.append(year);
        buffer.append('-');
        int month = calendar.get(2) + 1;
        if (month < 10) {
            buffer.append('0');
        }
        buffer.append(month);
        buffer.append('-');
        int day = calendar.get(5);
        if (day < 10) {
            buffer.append('0');
        }
        buffer.append(day);
    }

    private void appendTime(Calendar calendar) {
        ICharBuffer buffer = this.getBuffer();
        int hour = calendar.get(11);
        if (hour < 10) {
            buffer.append('0');
        }
        buffer.append(hour);
        buffer.append(':');
        int minute = calendar.get(12);
        if (minute < 10) {
            buffer.append('0');
        }
        buffer.append(minute);
        buffer.append(':');
        int second = calendar.get(13);
        if (second < 10) {
            buffer.append('0');
        }
        buffer.append(second);
        buffer.append('.');
        int millisecond = calendar.get(14);
        if (millisecond < 100) {
            buffer.append('0');
        }
        if (millisecond < 10) {
            buffer.append('0');
        }
        buffer.append(millisecond);
    }

    private void checkLevel(int level) {
        if (level >= 1 && level <= 4) {
            return;
        }
        String pattern = Messages.getString(LOG_LEVEL_UNKNOWN_KEY);
        String message = MessageFormatter.format(pattern, new Integer(level));
        throw new IllegalArgumentException(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatMessage(String message) {
        String formattedMessage;
        ICharBuffer buffer;
        ICharBuffer iCharBuffer = buffer = this.getBuffer();
        synchronized (iCharBuffer) {
            buffer.setLength(0);
            Calendar calendar = LogProxy.getCalendar();
            this.appendDate(calendar);
            buffer.append(' ');
            this.appendTime(calendar);
            buffer.append(' ');
            buffer.append('-');
            buffer.append(' ');
            buffer.append(message);
            formattedMessage = buffer.toString();
        }
        return formattedMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICharBuffer getBuffer() {
        LogProxy logProxy = this;
        synchronized (logProxy) {
            if (this.buffer == null) {
                FactoryUtility utility = FactoryUtility.getInstance();
                ICharBuffer buffer = utility.createCharBuffer(5120);
                this.setBuffer(buffer);
            }
            return this.buffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogService getConsoleLog() {
        LogProxy logProxy = this;
        synchronized (logProxy) {
            if (this.consoleLog == null) {
                this.setConsoleLog(new ConsoleLog());
            }
            return this.consoleLog;
        }
    }

    private LogService getLog() {
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLogLevel() {
        LogProxy logProxy = this;
        synchronized (logProxy) {
            return this.logLevel;
        }
    }

    private boolean isLogging(int level) {
        int threshold = this.getLogLevel();
        boolean logging = threshold >= level;
        return logging;
    }

    public void log(int level, String message) {
        this.log(null, level, message, null);
    }

    public void log(int level, String message, Throwable throwable) {
        this.log(null, level, message, throwable);
    }

    public void log(ServiceReference reference, int level, String message) {
        this.log(reference, level, message, null);
    }

    public void log(ServiceReference reference, int level, String message, Throwable throwable) {
        boolean logging = this.isLogging(level);
        if (!logging) {
            return;
        }
        LogService log = this.getLog();
        if (log == null) {
            log = this.getConsoleLog();
        }
        String formattedMessage = this.formatMessage(message);
        log.log(reference, level, formattedMessage, throwable);
    }

    private void setBuffer(ICharBuffer buffer) {
        this.buffer = buffer;
    }

    private void setConsoleLog(LogService consoleLog) {
        this.consoleLog = consoleLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLog(LogService log) {
        if (this.equals(log)) {
            return;
        }
        if (this.log != null && log != null) {
            return;
        }
        LogProxy logProxy = this;
        synchronized (logProxy) {
            this.log = log;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogLevel(int logLevel) {
        this.checkLevel(logLevel);
        LogProxy logProxy = this;
        synchronized (logProxy) {
            this.logLevel = logLevel;
        }
    }
}

