/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.record;

import org.eclipse.soda.sat.core.internal.framework.bundle.BundleDependencyManager;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.internal.record.ServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IImportServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IImportServiceRecordOwner;
import org.eclipse.soda.sat.core.util.Assertion;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.sat.core.util.MessageFormatter;
import org.eclipse.soda.sat.core.util.ServiceReferenceUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public final class ImportServiceRecord
extends ServiceRecord
implements IImportServiceRecord {
    private static final String ACQUIRED_SERVICE_KEY = "ImportServiceRecord.AcquiredService";
    private static final String ACQUIRED_SERVICE_MATCHING_FILTER_KEY = "ImportServiceRecord.AcquiredServiceMatchingFilter";
    private static final String FAILED_TO_ACQUIRE_SERVICE_KEY = "ImportServiceRecord.FailedToAcquireService";
    private static final String FAILED_TO_ACQUIRE_SERVICE_MATCHING_FILTER_KEY = "ImportServiceRecord.FailedToAcquireServiceMatchingFilter";
    private static final String LOCK_MUST_NOT_BE_NULL_KEY = "ImportServiceRecord.LockMustNotBeNull";
    private static final ServiceReference[] NO_SERVICE_REFERENCES = new ServiceReference[0];
    private static final String SAT_CORE_KEY = "Common.SatCore";
    private Filter filter;
    private String name;
    private volatile IImportServiceRecordOwner owner;
    private ServiceReference serviceReference;

    public ImportServiceRecord(BundleContext bundleContext, String name, Filter filter) {
        super(bundleContext);
        this.setName(name);
        this.basicSetFilter(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            ServiceReference reference;
            boolean acquired = this.isAcquired();
            if (acquired) {
                return;
            }
            this.registerAsServiceListener();
            BundleContext bundleContext = this.getBundleContext();
            boolean filtered = this.hasFilter();
            if (filtered) {
                reference = this.acquireFilteredServiceFromFramework();
            } else {
                String name = this.getName();
                reference = bundleContext.getServiceReference(name);
            }
            if (reference != null) {
                this.setServiceReference(reference);
                Object service = bundleContext.getService(reference);
                this.setService(service);
                this.logTraceAcquiredService();
                IImportServiceRecordOwner owner = this.getOwner();
                if (owner == null) {
                    return;
                }
                owner.serviceAcquired(this);
            } else {
                this.logTraceFailedToAcquireService();
            }
        }
    }

    private ServiceReference acquireFilteredServiceFromFramework() {
        ServiceReference reference = null;
        ServiceReference[] references = this.getFilteredServiceReferences();
        int length = references.length;
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            reference = references[0];
        } else {
            ServiceReferenceUtility utility = ServiceReferenceUtility.getInstance();
            reference = utility.select(references);
        }
        return reference;
    }

    private void applyFilter() {
        boolean acquired = this.isAcquired();
        if (acquired) {
            Filter filter = this.getFilter();
            if (filter == null) {
                return;
            }
            ServiceReference reference = this.getServiceReference();
            boolean match = filter.match(reference);
            if (match) {
                return;
            }
            this.release(false);
            this.acquire();
            return;
        }
        boolean listening = this.isRegisteredForServiceEvents();
        if (!listening) {
            return;
        }
        this.acquire();
    }

    private void basicSetFilter(Filter filter) {
        this.filter = filter;
    }

    protected String createServiceFilter() {
        String name = this.getName();
        int length = name.length();
        int size = 14 + length;
        StringBuffer buffer = new StringBuffer(size);
        this.createServiceFilterOn(buffer, name);
        String result = buffer.toString();
        return result;
    }

    protected int estimateToStringBufferSize() {
        return super.estimateToStringBufferSize() + 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter getFilter() {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            return this.filter;
        }
    }

    private ServiceReference[] getFilteredServiceReferences() {
        BundleContext bundleContext = this.getBundleContext();
        String name = this.getName();
        Filter filter = this.getFilter();
        String filterString = filter.toString();
        ServiceReference[] references = null;
        try {
            references = bundleContext.getServiceReferences(name, filterString);
        }
        catch (InvalidSyntaxException exception) {
            this.handleInvalidSyntaxException(exception);
        }
        if (references == null) {
            references = NO_SERVICE_REFERENCES;
        }
        return references;
    }

    protected Object getLock() {
        Object lock;
        IImportServiceRecordOwner owner = this.getOwner();
        if (owner != null) {
            lock = owner.getLock();
            Assertion.checkIsNotNull(lock, LOCK_MUST_NOT_BE_NULL_KEY, this);
        } else {
            lock = super.getLock();
        }
        return lock;
    }

    public String getName() {
        return this.name;
    }

    private IImportServiceRecordOwner getOwner() {
        return this.owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceReference getServiceReference() {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            return this.serviceReference;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleModifiedService(ServiceReference serviceReference) {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            boolean filtered = this.hasFilter();
            if (!filtered) {
                return;
            }
            this.applyFilter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRegisteredService(ServiceReference serviceReference) {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            boolean acquired = this.isAcquired();
            if (acquired) {
                return;
            }
            this.acquire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleUnregisteringService(ServiceReference serviceReference) {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            ServiceReference reference = this.getServiceReference();
            boolean equal = serviceReference.equals(reference);
            if (!equal) {
                return;
            }
            this.release(false);
            this.acquire();
        }
    }

    private boolean hasFilter() {
        Filter filter = this.getFilter();
        boolean result = filter != null;
        return result;
    }

    public boolean isAcquired() {
        ServiceReference reference = this.getServiceReference();
        boolean acquired = reference != null;
        return acquired;
    }

    private void logTraceAcquiredService() {
        boolean tracing = LogUtility.isTracing();
        if (!tracing) {
            return;
        }
        Bundle bundle = this.getBundle();
        if (bundle == null) {
            return;
        }
        String source = bundle.getSymbolicName();
        String name = this.getName();
        Filter filter = this.getFilter();
        Object[] values = new Object[]{source, name, filter};
        String key = filter == null ? ACQUIRED_SERVICE_KEY : ACQUIRED_SERVICE_MATCHING_FILTER_KEY;
        String pattern = Messages.getString(key);
        String message = MessageFormatter.format(pattern, values);
        String component = Messages.getString(SAT_CORE_KEY);
        LogUtility.logTrace((Object)component, message);
    }

    private void logTraceFailedToAcquireService() {
        boolean tracing = LogUtility.isTracing();
        if (!tracing) {
            return;
        }
        Bundle bundle = this.getBundle();
        if (bundle == null) {
            return;
        }
        String source = bundle.getSymbolicName();
        String name = this.getName();
        Filter filter = this.getFilter();
        Object[] values = new Object[]{source, name, filter};
        String key = filter == null ? FAILED_TO_ACQUIRE_SERVICE_KEY : FAILED_TO_ACQUIRE_SERVICE_MATCHING_FILTER_KEY;
        String pattern = Messages.getString(key);
        String message = MessageFormatter.format(pattern, values);
        String component = Messages.getString(SAT_CORE_KEY);
        LogUtility.logTrace((Object)component, message);
    }

    private void printFilterOn(StringBuffer buffer) {
        Filter filter = this.getFilter();
        buffer.append(", filter=");
        buffer.append(filter);
    }

    private void printNameOn(StringBuffer buffer) {
        String name = this.getName();
        buffer.append(", name=");
        buffer.append((Object)name);
    }

    protected void printOn(StringBuffer buffer) {
        super.printOn(buffer);
        this.printNameOn(buffer);
        this.printFilterOn(buffer);
    }

    private void registerBundleRelationship() {
        Bundle importer = this.getBundle();
        if (importer == null) {
            return;
        }
        ServiceReference reference = this.getServiceReference();
        Bundle exporter = reference.getBundle();
        if (exporter == null) {
            return;
        }
        BundleDependencyManager manager = BundleDependencyManager.getInstance();
        manager.register(importer, exporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            this.release(true);
        }
    }

    private void release(boolean unregister) {
        boolean acquired = this.isAcquired();
        if (acquired) {
            boolean reacquired;
            ServiceReference reference = this.getServiceReference();
            this.setServiceReference(null);
            IImportServiceRecordOwner owner = this.getOwner();
            if (owner != null) {
                owner.serviceReleased(this);
            }
            if (!(reacquired = this.isAcquired())) {
                this.setService(null);
            }
            BundleContext bundleContext = this.getBundleContext();
            try {
                bundleContext.ungetService(reference);
            }
            catch (IllegalStateException illegalStateException) {}
        }
        if (unregister) {
            this.unregisterAsServiceListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(Filter filter) {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            if (this.filter != null && this.filter.equals((Object)filter)) {
                return;
            }
            this.basicSetFilter(filter);
            this.applyFilter();
        }
    }

    private void setName(String name) {
        Assertion.checkArgumentIsNotNull(name, "name");
        this.name = name;
    }

    public void setOwner(IImportServiceRecordOwner owner) {
        this.owner = owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setServiceReference(ServiceReference serviceReference) {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            if (this.serviceReference != null) {
                this.unregisterBundleRelationship();
            }
            this.serviceReference = serviceReference;
            if (this.serviceReference != null) {
                this.registerBundleRelationship();
            }
        }
    }

    private void unregisterBundleRelationship() {
        ServiceReference reference = this.getServiceReference();
        Bundle exporter = reference.getBundle();
        if (exporter == null) {
            return;
        }
        BundleDependencyManager bdm = BundleDependencyManager.getInstance();
        boolean uninstallable = bdm.isRegisteredAsUninstallable(exporter);
        if (!uninstallable) {
            Bundle importer = this.getBundle();
            if (importer == null) {
                return;
            }
            bdm.unregister(importer, exporter);
        }
    }
}

