/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.log.internal.bundle;

import org.eclipse.soda.sat.core.framework.interfaces.ICharBuffer;
import org.eclipse.soda.sat.core.log.internal.ILogReaderAggregator;
import org.eclipse.soda.sat.core.log.internal.LogReaderAggregator;
import org.eclipse.soda.sat.core.record.interfaces.IServiceDetecter;
import org.eclipse.soda.sat.core.record.interfaces.ServiceDetecterListener;
import org.eclipse.soda.sat.core.util.Assertion;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogReaderService;

class AggregatorModel {
    private static final String LOG_READER_SERVICE_NAME;
    private BundleContext bundleContext;
    private ILogReaderAggregator aggregator;
    private IServiceDetecter detecter;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.log.LogReaderService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG_READER_SERVICE_NAME = clazz.getName();
    }

    AggregatorModel(BundleContext bundleContext) {
        this.setBundleContext(bundleContext);
    }

    private void addLogReaderService(LogReaderService reader) {
        ILogReaderAggregator aggregator = this.getAggregator();
        aggregator.addLogReaderService(reader);
    }

    private void basicPrintOn(ICharBuffer buffer) {
        String value = super.toString();
        buffer.append((Object)value);
    }

    private IServiceDetecter createServiceDetecter() {
        FactoryUtility utility = FactoryUtility.getInstance();
        BundleContext bundleContext = this.getBundleContext();
        IServiceDetecter detecter = utility.createServiceDetecter(bundleContext, LOG_READER_SERVICE_NAME);
        ServiceDetecterListener listener = this.createServiceDetecterListener();
        detecter.addServiceDetecterListener(listener);
        return detecter;
    }

    private ServiceDetecterListener createServiceDetecterListener() {
        return new ServiceDetecterListener(){

            public void serviceAdded(IServiceDetecter detecter, ServiceReference serviceReference, Object service) {
                LogReaderService reader = (LogReaderService)service;
                AggregatorModel.this.addLogReaderService(reader);
            }

            public void serviceRemoved(IServiceDetecter detecter, ServiceReference serviceReference, Object service) {
                LogReaderService reader = (LogReaderService)service;
                AggregatorModel.this.removeLogReaderService(reader);
            }
        };
    }

    ILogReaderAggregator getAggregator() {
        return this.aggregator;
    }

    private BundleContext getBundleContext() {
        return this.bundleContext;
    }

    private IServiceDetecter getDetecter() {
        return this.detecter;
    }

    private void printAggregatorOn(ICharBuffer buffer) {
        ILogReaderAggregator object = this.getAggregator();
        buffer.append(", aggregator=");
        buffer.append((Object)object);
    }

    private void printBundleContextOn(ICharBuffer buffer) {
        BundleContext object = this.getBundleContext();
        buffer.append(", bundleContext=");
        buffer.append((Object)object);
    }

    private void printDetecterOn(ICharBuffer buffer) {
        IServiceDetecter object = this.getDetecter();
        buffer.append(", detecter=");
        buffer.append((Object)object);
    }

    private void printOn(ICharBuffer buffer) {
        this.basicPrintOn(buffer);
        this.printBundleContextOn(buffer);
        this.printAggregatorOn(buffer);
        this.printDetecterOn(buffer);
    }

    private void removeLogReaderService(LogReaderService reader) {
        ILogReaderAggregator aggregator = this.getAggregator();
        aggregator.removeLogReaderService(reader);
    }

    private void setAggregator(ILogReaderAggregator aggregator) {
        this.aggregator = aggregator;
    }

    private void setBundleContext(BundleContext bundleContext) {
        Assertion.checkArgumentIsNotNull((Object)bundleContext, (String)"bundleContext");
        this.bundleContext = bundleContext;
    }

    private void setDetecter(IServiceDetecter detecter) {
        this.detecter = detecter;
    }

    void start() {
        LogReaderAggregator aggregator = new LogReaderAggregator();
        this.setAggregator(aggregator);
        IServiceDetecter detecter = this.createServiceDetecter();
        this.setDetecter(detecter);
        aggregator.start();
        detecter.acquire();
    }

    void stop() {
        IServiceDetecter detector = this.getDetecter();
        detector.release();
        ILogReaderAggregator aggregator = this.getAggregator();
        aggregator.stop();
        this.setDetecter(null);
        this.setAggregator(null);
    }

    public String toString() {
        FactoryUtility utility = FactoryUtility.getInstance();
        ICharBuffer buffer = utility.createCharBuffer(500);
        this.printOn(buffer);
        String value = buffer.toString();
        return value;
    }
}

