/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.framework.bundle.cm.test;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.internal.framework.bundle.cm.test.customer.Customer;
import org.eclipse.soda.sat.core.internal.framework.bundle.cm.test.customer.CustomerManagedServiceFactory;
import org.eclipse.soda.sat.core.internal.framework.bundle.cm.test.hotdog.HotdogVendor;
import org.eclipse.soda.sat.core.internal.framework.bundle.cm.test.hotdog.HotdogVendorManagedServiceFactory;
import org.eclipse.soda.sat.core.internal.framework.bundle.cm.test.hotdog.VendorService;
import org.eclipse.soda.sat.core.junit.internal.cm.AbstractManagedServiceFactoryActivationManagerTestCase;
import org.eclipse.soda.sat.core.junit.internal.cm.ConfigurationAdminConfigurator;
import org.eclipse.soda.sat.core.junit.internal.cm.IManagedServiceFactoryActivationDelegate;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;

public class ManagedServiceFactoryActivationManagerTestCase
extends AbstractManagedServiceFactoryActivationManagerTestCase {
    private static final Integer FIVE = new Integer(5);
    private IManagedServiceFactoryActivationDelegate hotdogVendorFactory;
    private IManagedServiceFactoryActivationDelegate customerFactory;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.framework.bundle.cm.test.ManagedServiceFactoryActivationManagerTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public ManagedServiceFactoryActivationManagerTestCase(String name) {
        super(name);
    }

    private Configuration createCustomerConfiguration(Object id, int spiciness) throws IOException, InterruptedException {
        Hashtable<String, Object> properties = new Hashtable<String, Object>(17);
        ((Dictionary)properties).put("id", id);
        ((Dictionary)properties).put("spiciness", new Integer(spiciness));
        IManagedServiceFactoryActivationDelegate factory = this.getCustomerFactory();
        Configuration configuration = this.createConfiguration(factory, id, properties);
        return configuration;
    }

    private IManagedServiceFactoryActivationDelegate createCustomerManagedServiceFactory() {
        String location = this.getLocation();
        CustomerManagedServiceFactory factory = new CustomerManagedServiceFactory("CustomerFactory", location);
        return factory;
    }

    private Configuration createHogdogVendorConfiguration(Object id, int spiciness) throws IOException, InterruptedException {
        Hashtable<String, Object> properties = new Hashtable<String, Object>(17);
        ((Dictionary)properties).put("id", id);
        ((Dictionary)properties).put("spiciness", new Integer(spiciness));
        IManagedServiceFactoryActivationDelegate factory = this.getHotdogVendorFactory();
        Configuration configuration = this.createConfiguration(factory, id, properties);
        return configuration;
    }

    private IManagedServiceFactoryActivationDelegate createHotdogVendorManagedServiceFactory() {
        String location = this.getLocation();
        HotdogVendorManagedServiceFactory factory = new HotdogVendorManagedServiceFactory("HotdogVendorFactory", location);
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IManagedServiceFactoryActivationDelegate getCustomerFactory() {
        ManagedServiceFactoryActivationManagerTestCase managedServiceFactoryActivationManagerTestCase = this;
        synchronized (managedServiceFactoryActivationManagerTestCase) {
            if (this.customerFactory == null) {
                IManagedServiceFactoryActivationDelegate factory = this.createCustomerManagedServiceFactory();
                this.setCustomerFactory(factory);
            }
        }
        return this.customerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IManagedServiceFactoryActivationDelegate getHotdogVendorFactory() {
        ManagedServiceFactoryActivationManagerTestCase managedServiceFactoryActivationManagerTestCase = this;
        synchronized (managedServiceFactoryActivationManagerTestCase) {
            if (this.hotdogVendorFactory == null) {
                IManagedServiceFactoryActivationDelegate factory = this.createHotdogVendorManagedServiceFactory();
                this.setHotdogVendorFactory(factory);
            }
        }
        return this.hotdogVendorFactory;
    }

    private void setCustomerFactory(IManagedServiceFactoryActivationDelegate customerFactory) {
        this.customerFactory = customerFactory;
    }

    private void setHotdogVendorFactory(IManagedServiceFactoryActivationDelegate hotdogVendorFactory) {
        this.hotdogVendorFactory = hotdogVendorFactory;
    }

    private void startCustomerFactory() throws Exception {
        IManagedServiceFactoryActivationDelegate factory = this.getCustomerFactory();
        BundleContext context = this.getBundleContext();
        factory.start(context);
    }

    private void startHotdogVendorFactory() throws Exception {
        IManagedServiceFactoryActivationDelegate factory = this.getHotdogVendorFactory();
        BundleContext context = this.getBundleContext();
        factory.start(context);
    }

    private void stopCustomerFactory() throws Exception {
        IManagedServiceFactoryActivationDelegate factory = this.getCustomerFactory();
        BundleContext context = this.getBundleContext();
        factory.stop(context);
    }

    private void stopHotdogVendorFactory() throws Exception {
        IManagedServiceFactoryActivationDelegate factory = this.getHotdogVendorFactory();
        BundleContext context = this.getBundleContext();
        factory.stop(context);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test() throws Exception {
        try {
            this.startHotdogVendorFactory();
            this.startCustomerFactory();
            String hotdog1Id = "HD1";
            int hotdog1Spiciness = 5;
            Configuration hotdog1Configuration = this.createHogdogVendorConfiguration(hotdog1Id, hotdog1Spiciness);
            String id = hotdog1Id;
            Object object = this.hotdogVendorFactory.getObjectWithId(id);
            Assert.assertTrue((boolean)(object instanceof VendorService));
            Assert.assertTrue((boolean)(object instanceof HotdogVendor));
            VendorService vendor = (VendorService)object;
            int expectedSpiciness = hotdog1Spiciness;
            int actualSpiciness = vendor.getSpiciness();
            Assert.assertEquals((int)expectedSpiciness, (int)actualSpiciness);
            String hotdog2Id = "HD2";
            int hotdog2Spiciness = 10;
            Configuration hotdog2Configuration = this.createHogdogVendorConfiguration(hotdog2Id, hotdog2Spiciness);
            id = hotdog2Id;
            object = this.hotdogVendorFactory.getObjectWithId(id);
            Assert.assertTrue((boolean)(object instanceof VendorService));
            Assert.assertTrue((boolean)(object instanceof HotdogVendor));
            vendor = (VendorService)object;
            expectedSpiciness = hotdog2Spiciness;
            actualSpiciness = vendor.getSpiciness();
            Assert.assertEquals((int)expectedSpiciness, (int)actualSpiciness);
            String customer1Id = "C1";
            int customer1Spiciness = 5;
            Configuration customer1Configuration = this.createCustomerConfiguration(customer1Id, customer1Spiciness);
            id = customer1Id;
            object = this.customerFactory.getObjectWithId(id);
            Assert.assertTrue((boolean)(object instanceof Customer));
            Customer customer = (Customer)object;
            expectedSpiciness = customer1Spiciness;
            actualSpiciness = customer.getSpiciness();
            Assert.assertEquals((int)expectedSpiciness, (int)actualSpiciness);
            vendor = customer.getVendor();
            expectedSpiciness = customer.getSpiciness();
            actualSpiciness = vendor.getSpiciness();
            Assert.assertEquals((int)expectedSpiciness, (int)actualSpiciness);
            String customer2Id = "C2";
            int customer2Spiciness = 10;
            Configuration customer2Configuration = this.createCustomerConfiguration(customer2Id, customer2Spiciness);
            id = customer2Id;
            object = this.customerFactory.getObjectWithId(id);
            Assert.assertTrue((boolean)(object instanceof Customer));
            customer = (Customer)object;
            expectedSpiciness = customer2Spiciness;
            actualSpiciness = customer.getSpiciness();
            Assert.assertEquals((int)expectedSpiciness, (int)actualSpiciness);
            vendor = customer.getVendor();
            expectedSpiciness = customer.getSpiciness();
            actualSpiciness = vendor.getSpiciness();
            Assert.assertEquals((int)expectedSpiciness, (int)actualSpiciness);
            ConfigurationAdminConfigurator configurator = this.getConfigurator();
            configurator.delete(this.customerFactory, customer2Id, customer2Configuration);
            object = this.customerFactory.getObjectWithId(customer2Id);
            Assert.assertNull((Object)object);
            configurator.delete(this.customerFactory, customer1Id, customer1Configuration);
            object = this.customerFactory.getObjectWithId(customer1Id);
            Assert.assertNull((Object)object);
            configurator.delete(this.hotdogVendorFactory, hotdog2Id, hotdog2Configuration);
            object = this.hotdogVendorFactory.getObjectWithId(hotdog2Id);
            Assert.assertNull((Object)object);
            configurator.delete(this.hotdogVendorFactory, hotdog1Id, hotdog1Configuration);
            object = this.hotdogVendorFactory.getObjectWithId(hotdog1Id);
            Assert.assertNull((Object)object);
        }
        catch (Throwable throwable) {
            Object var20_21 = null;
            this.stopCustomerFactory();
            this.stopHotdogVendorFactory();
            throw throwable;
        }
        {
            Object var20_22 = null;
        }
        this.stopCustomerFactory();
        this.stopHotdogVendorFactory();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_create() throws Exception {
        try {
            this.startHotdogVendorFactory();
            String hotdog1Id = "HD1";
            int hotdog1Spiciness = 5;
            Configuration hotdog1Configuration = this.createHogdogVendorConfiguration(hotdog1Id, hotdog1Spiciness);
            String id = hotdog1Id;
            Object object = this.hotdogVendorFactory.getObjectWithId(id);
            Assert.assertTrue((boolean)(object instanceof VendorService));
            Assert.assertTrue((boolean)(object instanceof HotdogVendor));
            VendorService vendor = (VendorService)object;
            int expectedSpiciness = hotdog1Spiciness;
            int actualSpiciness = vendor.getSpiciness();
            Assert.assertEquals((int)expectedSpiciness, (int)actualSpiciness);
            String hotdog2Id = "HD2";
            int hotdog2Spiciness = 10;
            Configuration hotdog2Configuration = this.createHogdogVendorConfiguration(hotdog2Id, hotdog2Spiciness);
            id = hotdog2Id;
            object = this.hotdogVendorFactory.getObjectWithId(id);
            Assert.assertTrue((boolean)(object instanceof VendorService));
            Assert.assertTrue((boolean)(object instanceof HotdogVendor));
            vendor = (VendorService)object;
            expectedSpiciness = hotdog2Spiciness;
            actualSpiciness = vendor.getSpiciness();
            Assert.assertEquals((int)expectedSpiciness, (int)actualSpiciness);
            ConfigurationAdminConfigurator admin = this.getConfigurator();
            IManagedServiceFactoryActivationDelegate factory = this.getHotdogVendorFactory();
            admin.delete(factory, hotdog1Id, hotdog1Configuration);
            admin.delete(factory, hotdog2Id, hotdog2Configuration);
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            this.stopHotdogVendorFactory();
            throw throwable;
        }
        {
            Object var14_16 = null;
        }
        this.stopHotdogVendorFactory();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_createWithDependenciesAcquired() throws Exception {
        String hotdog1Id = "HD1";
        String hotdog2Id = "HD2";
        String customer1Id = "C1";
        String customer2Id = "C2";
        Configuration hotdog1Configuration = null;
        Configuration hotdog2Configuration = null;
        Configuration customer1Configuration = null;
        Configuration customer2Configuration = null;
        try {
            this.startHotdogVendorFactory();
            this.startCustomerFactory();
            int hotdog1Spiciness = 5;
            hotdog1Configuration = this.createHogdogVendorConfiguration(hotdog1Id, hotdog1Spiciness);
            int hotdog2Spiciness = 10;
            hotdog2Configuration = this.createHogdogVendorConfiguration(hotdog2Id, hotdog2Spiciness);
            int customer1Spiciness = 5;
            customer1Configuration = this.createCustomerConfiguration(customer1Id, customer1Spiciness);
            String id = customer1Id;
            Object object = this.customerFactory.getObjectWithId(id);
            Assert.assertTrue((boolean)(object instanceof Customer));
            Customer customer = (Customer)object;
            int expectedSpiciness = customer1Spiciness;
            int actualSpiciness = customer.getSpiciness();
            Assert.assertEquals((int)expectedSpiciness, (int)actualSpiciness);
            VendorService vendor = customer.getVendor();
            expectedSpiciness = customer.getSpiciness();
            actualSpiciness = vendor.getSpiciness();
            Assert.assertEquals((int)expectedSpiciness, (int)actualSpiciness);
            int customer2Spiciness = 10;
            customer2Configuration = this.createCustomerConfiguration(customer2Id, customer2Spiciness);
            id = customer2Id;
            object = this.customerFactory.getObjectWithId(id);
            Assert.assertTrue((boolean)(object instanceof Customer));
            customer = (Customer)object;
            expectedSpiciness = customer2Spiciness;
            actualSpiciness = customer.getSpiciness();
            Assert.assertEquals((int)expectedSpiciness, (int)actualSpiciness);
            vendor = customer.getVendor();
            expectedSpiciness = customer.getSpiciness();
            actualSpiciness = vendor.getSpiciness();
            Assert.assertEquals((int)expectedSpiciness, (int)actualSpiciness);
        }
        catch (Throwable throwable) {
            Object var19_20 = null;
            ConfigurationAdminConfigurator admin = this.getConfigurator();
            IManagedServiceFactoryActivationDelegate factory = this.getHotdogVendorFactory();
            admin.delete(factory, hotdog1Id, hotdog1Configuration);
            admin.delete(factory, hotdog2Id, hotdog2Configuration);
            this.stopHotdogVendorFactory();
            factory = this.getCustomerFactory();
            admin.delete(factory, customer1Id, customer1Configuration);
            admin.delete(factory, customer2Id, customer2Configuration);
            this.stopCustomerFactory();
            throw throwable;
        }
        {
            Object var19_21 = null;
        }
        ConfigurationAdminConfigurator admin = this.getConfigurator();
        IManagedServiceFactoryActivationDelegate factory = this.getHotdogVendorFactory();
        admin.delete(factory, hotdog1Id, hotdog1Configuration);
        admin.delete(factory, hotdog2Id, hotdog2Configuration);
        this.stopHotdogVendorFactory();
        factory = this.getCustomerFactory();
        admin.delete(factory, customer1Id, customer1Configuration);
        admin.delete(factory, customer2Id, customer2Configuration);
        this.stopCustomerFactory();
    }

    public void test_createWithDependenciesLost() throws Exception {
        this.startHotdogVendorFactory();
        this.startCustomerFactory();
        String hotdog1Id = "HD1";
        int hotdog1Spiciness = 5;
        Configuration hotdog1Configuration = this.createHogdogVendorConfiguration(hotdog1Id, hotdog1Spiciness);
        String hotdog2Id = "HD2";
        int hotdog2Spiciness = 10;
        Configuration hotdog2Configuration = this.createHogdogVendorConfiguration(hotdog2Id, hotdog2Spiciness);
        String customer1Id = "C1";
        int customer1Spiciness = 5;
        Configuration customer1Configuration = this.createCustomerConfiguration(customer1Id, customer1Spiciness);
        String customer2Id = "C2";
        int customer2Spiciness = 10;
        Configuration customer2Configuration = this.createCustomerConfiguration(customer2Id, customer2Spiciness);
        ConfigurationAdminConfigurator configurator = this.getConfigurator();
        configurator.delete(this.hotdogVendorFactory, hotdog2Id, hotdog2Configuration);
        Object object = this.hotdogVendorFactory.getObjectWithId(hotdog2Id);
        Assert.assertNull((Object)object);
        object = this.customerFactory.getObjectWithId(customer2Id);
        Assert.assertNull((Object)object);
        Dictionary customer2Properties = customer2Configuration.getProperties();
        customer2Properties.put("spiciness", FIVE);
        configurator.update(this.customerFactory, customer2Properties, customer2Configuration);
        object = this.customerFactory.getObjectWithId(customer2Id);
        Assert.assertNotNull((Object)object);
        configurator.delete(this.hotdogVendorFactory, hotdog1Id, hotdog1Configuration);
        object = this.hotdogVendorFactory.getObjectWithId(hotdog1Id);
        Assert.assertNull((Object)object);
        object = this.customerFactory.getObjectWithId(customer1Id);
        Assert.assertNull((Object)object);
        object = this.customerFactory.getObjectWithId(customer2Id);
        Assert.assertNull((Object)object);
        configurator.delete(this.customerFactory, customer1Id, customer1Configuration);
        configurator.delete(this.customerFactory, customer2Id, customer2Configuration);
        this.stopCustomerFactory();
        this.stopHotdogVendorFactory();
    }

    public void test_delete() throws Exception {
        this.startHotdogVendorFactory();
        String hotdog1Id = "HD1";
        Configuration hotdog1Configuration = this.createHogdogVendorConfiguration(hotdog1Id, 5);
        String hotdog2Id = "HD2";
        Configuration hotdog2Configuration = this.createHogdogVendorConfiguration(hotdog2Id, 10);
        ConfigurationAdminConfigurator configurator = this.getConfigurator();
        configurator.delete(this.hotdogVendorFactory, hotdog2Id, hotdog2Configuration);
        Object object = this.hotdogVendorFactory.getObjectWithId(hotdog2Id);
        Assert.assertNull((Object)object);
        configurator.delete(this.hotdogVendorFactory, hotdog1Id, hotdog1Configuration);
        object = this.hotdogVendorFactory.getObjectWithId(hotdog1Id);
        Assert.assertNull((Object)object);
        this.stopHotdogVendorFactory();
    }
}

