/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.transport;

import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.epcglobal.llrp.transport.EpcglobalLlrpMessage;
import org.eclipse.soda.dk.epcglobal.llrp.transport.messages.EpcglobalLlrpTransportMessages;
import org.eclipse.soda.dk.epcglobal.llrp.transport.service.EpcglobalLlrpTransportService;
import org.eclipse.soda.dk.message.ParameterMessage;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.SimpleParameter;
import org.eclipse.soda.dk.parameter.service.ParameterService;
import org.eclipse.soda.dk.rfid.transport.service.RfidTransportService;
import org.eclipse.soda.dk.tcpip.connection.TcpipConnection;
import org.eclipse.soda.dk.tcpip.connection.service.TcpipConnectionService;
import org.eclipse.soda.dk.transport.ResponseTransport;
import org.eclipse.soda.dk.transport.service.TransportService;

public class EpcglobalLlrpTransport
extends ResponseTransport
implements TransportService,
RfidTransportService,
EpcglobalLlrpTransportService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.epcglobal.llrp.transport.EpcglobalLlrpTransport";
    protected static final byte[] KEEPALIVE_ACK_BYTES = (byte[])EpcglobalLlrpTransportMessages.getMsg_KEEPALIVE_ACK().getBytes().clone();
    protected ParameterMessage noActivityMessage;
    private int messageIdSeed;

    public EpcglobalLlrpTransport() {
        byte[] byArray = new byte[20];
        byArray[0] = 4;
        byArray[1] = 3;
        byArray[5] = 20;
        byArray[6] = 64;
        byArray[12] = -36;
        byArray[14] = 9;
        byArray[15] = 1;
        byArray[18] = 19;
        byArray[19] = -120;
        this.noActivityMessage = new ParameterMessage(byArray, EpcglobalLlrpTransportMessages.getFilter_SET_READER_CONFIG_KEEPALIVESPEC(), (ParameterService)new SimpleParameter("", null, 16, 4));
        this.messageIdSeed = 0x3FFFFFFF;
    }

    private synchronized int generateMessageId() {
        if (++this.messageIdSeed == Integer.MAX_VALUE) {
            this.messageIdSeed /= 2;
        }
        return this.messageIdSeed;
    }

    protected int processInput(byte[] bytes, int length) throws Exception {
        Object timestamp = null;
        int msg_beg_index = 0;
        while (length - msg_beg_index >= 10) {
            int messageLength;
            int bytesread = msg_beg_index;
            int messageType = (bytes[bytesread++] & 3) << 8 | bytes[bytesread++] & 0xFF;
            if (length - msg_beg_index < (messageLength = (bytes[bytesread++] & 0xFF) << 24 | (bytes[bytesread++] & 0xFF) << 16 | (bytes[bytesread++] & 0xFF) << 8 | bytes[bytesread++] & 0xFF)) break;
            if (messageType == 62) {
                try {
                    byte[] msgRawBytes = new byte[KEEPALIVE_ACK_BYTES.length];
                    System.arraycopy(KEEPALIVE_ACK_BYTES, 0, msgRawBytes, 0, KEEPALIVE_ACK_BYTES.length);
                    msgRawBytes[6] = bytes[bytesread++];
                    msgRawBytes[7] = bytes[bytesread++];
                    msgRawBytes[8] = bytes[bytesread++];
                    msgRawBytes[9] = bytes[bytesread++];
                    try {
                        this.write(msgRawBytes, -1L);
                    }
                    catch (Exception exception) {
                        this.handleError(exception, 2030, (Object)new EpcglobalLlrpMessage(msgRawBytes), this.getHistory());
                    }
                    this.updateInputMessageCount();
                }
                catch (RuntimeException e) {
                    this.handleError(e, 3);
                    return msg_beg_index;
                }
                msg_beg_index += messageLength;
                continue;
            }
            byte[] llrpMessageBytes = new byte[messageLength];
            System.arraycopy(bytes, msg_beg_index, llrpMessageBytes, 0, messageLength);
            msg_beg_index += messageLength;
            boolean maybeResponse = true;
            switch (messageType) {
                case 61: 
                case 63: {
                    maybeResponse = false;
                    break;
                }
                default: {
                    maybeResponse = true;
                }
            }
            if (timestamp == null) {
                timestamp = EpcglobalLlrpTransport.getCurrentTimestamp();
            }
            this.parsedMessage(messageType, llrpMessageBytes, maybeResponse, timestamp);
        }
        return msg_beg_index;
    }

    public int startup(boolean output) throws Exception {
        this.messageIdSeed = 0x3FFFFFFF;
        return 4;
    }

    public MessageService noActivityProcessingMessage() {
        return this.noActivityMessage;
    }

    public void parsedMessage(int messageType, byte[] bytes, boolean maybeResponse, Object timestamp) {
        MessageService sentMsg = maybeResponse ? this.getSentMessage() : null;
        EpcglobalLlrpMessage msg = new EpcglobalLlrpMessage(bytes, sentMsg);
        if (maybeResponse) {
            this.fireMessageReceived(timestamp, (MessageService)msg);
        } else {
            this.fireMessageReceivedNoResponse(timestamp, (MessageService)msg);
        }
    }

    public void setupCustom() {
        super.setupCustom();
    }

    public void shutdown(boolean output) {
        this.writeAndReport(EpcglobalLlrpTransportMessages.getCloseConnectionMessage());
        super.shutdown(output);
    }

    public void startupMessageReceived(TransportService source, Object timestamp, MessageService message) {
        MessageService msg_readerEventNotification_connectionAttemp = EpcglobalLlrpTransportMessages.getReaderEventNotification_ConnectionAttempt();
        if (msg_readerEventNotification_connectionAttemp.matches(message) != null) {
            Integer obStatus = (Integer)msg_readerEventNotification_connectionAttemp.decodeMessage(message);
            int status = obStatus;
            switch (status) {
                case 0: {
                    this.setState(5);
                    try {
                        long timeout = this.getNoActivityTimeout();
                        if (timeout > 0L) {
                            long newTime = timeout > 2000L ? timeout - 1000L : timeout;
                            this.noActivityMessage.encodeMessage((MessageService)this.noActivityMessage, (Object)EpcglobalLlrpTransport.createNumber((long)newTime));
                            this.write(this.noActivityProcessingMessage().getBytes(), 0L);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    return;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.handleError(new IllegalStateException("READER_EVENT_NOTIFICATION.ConnectionAttempt.status=" + status), 2029);
                    return;
                }
                case 4: {
                    return;
                }
            }
            this.handleError(new IllegalStateException(), 2006, message, this.getHistory());
            return;
        }
        if (EpcglobalLlrpTransportMessages.getCloseConnectionResponseMessage().matches(message) == null) {
            this.handleError(new IllegalStateException(), 2006, message, this.getHistory());
        }
    }

    protected void write(byte[] bytes, long responseTimeout) throws Exception {
        int bytes_length = bytes.length;
        byte[] sendBytes = new byte[bytes_length];
        System.arraycopy(bytes, 0, sendBytes, 0, bytes_length);
        sendBytes[2] = (byte)(bytes_length >> 24 & 0xFF);
        sendBytes[3] = (byte)(bytes_length >> 16 & 0xFF);
        sendBytes[4] = (byte)(bytes_length >> 8 & 0xFF);
        sendBytes[5] = (byte)(bytes_length & 0xFF);
        if (sendBytes[6] == 0 && sendBytes[7] == 0 && sendBytes[8] == 0 && sendBytes[9] == 0) {
            int messageId = this.generateMessageId();
            sendBytes[6] = (byte)(messageId >> 24 & 0xFF);
            sendBytes[7] = (byte)(messageId >> 16 & 0xFF);
            sendBytes[8] = (byte)(messageId >> 8 & 0xFF);
            sendBytes[9] = (byte)(messageId & 0xFF);
        }
        super.write(sendBytes, responseTimeout);
    }

    public ConnectionService getDefaultConnection() {
        return this.getDefaultTcpipConnection();
    }

    public long getDefaultResponseTimeout() {
        return this.getLong("epcgloballlrptransport.responsetimeout", 1000L);
    }

    public TcpipConnectionService getDefaultTcpipConnection() {
        return new TcpipConnection(this.getString("epcgloballlrptransport.localhost", "0.0.0.0"), this.getInt("epcgloballlrptransport.localport", -1), this.getString("epcgloballlrptransport.remotehost", "localhost"), this.getInt("epcgloballlrptransport.remoteport", 5084), this.getInt("epcgloballlrptransport.readtimeout", 1000), this.getInt("epcgloballlrptransport.readsize", -1), this.getInt("epcgloballlrptransport.writesize", -1), this.getInt("epcgloballlrptransport.linger", -1));
    }

    public void setup() {
        super.setup();
        this.setRetryTime(this.getLong("epcgloballlrptransport.retrytime", this.getRetryTime()));
        this.setPriority(this.getInt("epcgloballlrptransport.priority", this.getPriority()));
        this.setNotificationPriority(this.getInt("epcgloballlrptransport.notificationpriority", this.getNotificationPriority()));
        this.setTransmitRetries(this.getInt("epcgloballlrptransport.transmitretries", this.getTransmitRetries()));
        this.setNoActivityTimeout(this.getLong("epcgloballlrptransport.noactivitytimeout", this.getNoActivityTimeout()));
    }
}

