/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.command;

import org.eclipse.soda.dk.command.SimpleDataCommand;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.transform.service.TransformService;
import org.eclipse.soda.dk.transport.service.ResponseListener;
import org.eclipse.soda.dk.transport.service.TransportService;

public class SimpleTransformCommand
extends SimpleDataCommand {
    private TransformService transform;

    public SimpleTransformCommand(String key, MessageService message) {
        this(key, message, null);
    }

    public SimpleTransformCommand(String key, MessageService message, TransformService transform) {
        super(key, message);
        this.setTransform(transform);
    }

    public Object decode(Object data) {
        TransformService transform = this.getTransform();
        if (transform == null) {
            return data;
        }
        return transform.decode(data);
    }

    public Object encode(Object data) {
        TransformService transform = this.getTransform();
        if (transform == null) {
            return data;
        }
        return transform.encode(data);
    }

    public void execute(ChannelService channel, Object data) {
        if (data == null) {
            this.execute(channel);
        } else {
            try {
                Object writeData = this.encode(data);
                MessageService newMessage = (MessageService)this.getMessage().clone();
                this.getDevice().send(channel, newMessage.encodeMessage(newMessage, writeData), (ResponseListener)this);
            }
            catch (Exception exception) {
                this.log(1, this.toString(), exception);
            }
        }
    }

    public TransformService getTransform() {
        return this.transform;
    }

    public void messageReceived(TransportService transportService, Object timestamp, ChannelService channel, MessageService message) {
        CommandListener commandListener = this.getCommandListener();
        if (commandListener != null) {
            try {
                MessageService matchMessage = this.getMessage().matches(message);
                if (matchMessage != null) {
                    this.fireCommandExecuted(commandListener, timestamp, channel, this.decode(matchMessage.decodeMessage(message)));
                }
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
        }
    }

    public void messageReceived(TransportService transportService, Object timestamp, MessageService message) {
        this.messageReceived(transportService, timestamp, null, message);
    }

    public void setTransform(TransformService transform) {
        this.transform = transform;
    }
}

