/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.data;

import java.util.StringTokenizer;
import org.eclipse.soda.dk.data.Data;
import org.eclipse.soda.dk.data.Fraction;

public class Degree
extends Fraction {
    private static final long serialVersionUID = 2818915107918640254L;
    public static final int THOUSAND = 1000;
    private static final long MILLION_LONG = 1000000L;
    private static final long BILLION_LONG = 1000000000L;
    public static final int SECONDS_PER_DEGREE = 3600;
    public static final long SECONDS_PER_DEGREE_LONG = 3600L;
    public static final int DENOMINATOR = 3600000;
    public static final float FLOAT_DENOMINATOR = 3600000.0f;
    public static final double DOUBLE_DENOMINATOR = 3600000.0;
    private static final int MAX_PLACES = 9;
    private int thousandSeconds;

    public Degree(int thousandSeconds) {
        this.thousandSeconds = thousandSeconds;
    }

    public Degree(int degrees, int minutes, int seconds) {
        this.thousandSeconds = degrees * 3600000 + minutes * 60 * 1000 + seconds;
    }

    public Degree(String value) throws NumberFormatException {
        int index = value.indexOf(78, 0);
        if (index == -1) {
            index = value.indexOf(69, 0);
        }
        if (index > -1) {
            this.thousandSeconds = Degree.parseBillionDegree(value.substring(0, index));
        } else {
            index = value.indexOf(83, 0);
            if (index == -1) {
                index = value.indexOf(87, 0);
            }
            this.thousandSeconds = index > -1 ? -Degree.parseBillionDegree(value.substring(0, index)) : Degree.parseBillionDegree(value);
        }
    }

    public static long parse(String value) throws NumberFormatException {
        long thousandDegree = 0L;
        int index = value.indexOf(46, 0);
        if (index == -1) {
            thousandDegree = (long)Data.parseInt(value) * 1000000000L;
        } else {
            int length;
            int places;
            if (index > 0) {
                thousandDegree = (long)Data.parseInt(value, 0, index) * 1000000000L;
            }
            if ((places = (length = value.length()) - index - 1) > 0) {
                long thousandFraction = Data.parseUlong(value, index + 1, length);
                long fraction = 9 - places;
                if (fraction > 0L) {
                    int i = 0;
                    while ((long)i < fraction) {
                        thousandFraction *= 10L;
                        ++i;
                    }
                } else if (fraction < 0L) {
                    int i = 0;
                    while ((long)i < -fraction) {
                        thousandFraction /= 10L;
                        ++i;
                    }
                }
                thousandDegree = thousandDegree < 0L ? (thousandDegree -= thousandFraction) : (thousandDegree += thousandFraction);
            }
        }
        return thousandDegree;
    }

    public static int parseBillionDegree(String value) throws NumberFormatException {
        return (int)(Degree.parse(value) * 3600L / 1000000L);
    }

    public static int parseMetarDegree(String value) throws NumberFormatException {
        String tvalue = value;
        boolean minus = false;
        int length = tvalue.length();
        char character = tvalue.charAt(length - 1);
        if ('N' == character || 'E' == character) {
            tvalue = tvalue.substring(0, length - 1);
        }
        if ('S' == character || 'W' == character) {
            tvalue = tvalue.substring(0, length - 1);
            minus = true;
        }
        int thousandDegree = 0;
        long times = 3600L;
        StringTokenizer tokenizer = new StringTokenizer(tvalue, "-");
        while (tokenizer.hasMoreTokens()) {
            long pvalue = Degree.parse(tokenizer.nextToken());
            thousandDegree = (int)((long)thousandDegree + pvalue * times / 1000000L);
            times /= 60L;
        }
        if (minus) {
            thousandDegree = -thousandDegree;
        }
        return thousandDegree;
    }

    public static int parseNmeaDegree(String value) throws NumberFormatException {
        int index;
        long thousandDegree = 0L;
        if (value.length() > 2) {
            index = value.indexOf(46, 0);
            if (index == -1) {
                index = value.length();
            }
        } else {
            throw new NumberFormatException(value);
        }
        long minutes = Degree.parse(value.substring(index - 2));
        thousandDegree = (int)(minutes * 60L / 1000000L);
        int tdegrees = Data.parseInt(value, 0, index - 2) * 3600000;
        return (int)(thousandDegree += (long)tdegrees);
    }

    public static String toDegreeString(int value, String additions) {
        int tvalue = value;
        StringBuffer buffer = new StringBuffer(64);
        if (value < 0) {
            tvalue = -tvalue;
        }
        int ttvalue = tvalue / 1000;
        buffer.append(Data.toString(ttvalue / 3600));
        buffer.append('\u00b0');
        int fraction = tvalue % 3600000;
        if (fraction > 0) {
            int minutes = fraction / 60;
            buffer.append(Data.toString(minutes / 1000));
            buffer.append('\'');
            int seconds = tvalue % 60000;
            if (seconds > 0) {
                buffer.append(Data.toString(seconds / 1000));
                int fseconds = seconds % 1000;
                if (fseconds > 0) {
                    buffer.append('.');
                    String fractionString = Integer.toString(fseconds);
                    int i = fractionString.length() - 1;
                    while (i > 0) {
                        if (fractionString.charAt(i) != '0') break;
                        --i;
                    }
                    buffer.append(fractionString.substring(0, i + 1));
                }
                buffer.append('\"');
            }
        }
        buffer.append(additions);
        return buffer.toString();
    }

    public static String toNmeaString(int value, String additions) {
        int tvalue = value;
        StringBuffer buffer = new StringBuffer(64);
        if (value < 0) {
            tvalue = -tvalue;
        }
        int ttvalue = tvalue / 1000;
        buffer.append(Data.toString(ttvalue / 3600));
        int fraction = tvalue % 3600000;
        int minutes = fraction / 60;
        int minuteWhole = minutes / 1000;
        if (minuteWhole < 10) {
            buffer.append('0');
        }
        buffer.append(Data.toString(minuteWhole));
        int seconds = minutes % 1000;
        if (seconds > 0) {
            buffer.append('.');
            if (seconds < 100) {
                buffer.append('0');
            }
            if (seconds < 10) {
                buffer.append('0');
            }
            buffer.append(Data.toString(seconds));
        }
        buffer.append(additions);
        return buffer.toString();
    }

    public static String toString(int value) {
        int degree;
        int tvalue = value;
        StringBuffer buffer = new StringBuffer(64);
        if (tvalue < 0) {
            buffer.append('-');
            tvalue = -tvalue;
        }
        if ((degree = tvalue / 3600000) > 0) {
            buffer.append(Data.toUString(degree));
        }
        int fraction = tvalue % 3600000;
        if ((fraction /= 36) != 0) {
            buffer.append('.');
            String fractionString = Data.toUString(fraction + 100000).substring(1);
            int i = fractionString.length() - 1;
            while (i > 0) {
                if (fractionString.charAt(i) != '0') break;
                --i;
            }
            buffer.append(fractionString.substring(0, i + 1));
        }
        return buffer.toString();
    }

    public Number add(Number value) {
        return new Degree((int)(value.doubleValue() * 1000.0) + this.thousandSeconds);
    }

    public Number divide(Number value) {
        return null;
    }

    public double doubleValue() {
        return (double)this.thousandSeconds / 3600000.0;
    }

    public boolean equals(Object compare) {
        if (compare instanceof Degree) {
            return this.getThousandSeconds() == ((Degree)compare).getThousandSeconds();
        }
        return false;
    }

    public float floatValue() {
        return (float)((double)this.thousandSeconds / 3600000.0);
    }

    public int getFixedDegree() {
        return this.thousandSeconds;
    }

    public int getThousandSeconds() {
        return this.thousandSeconds;
    }

    public int intDenominator() {
        return 3600000;
    }

    public int intNumerator() {
        return this.thousandSeconds;
    }

    public int intValue() {
        return this.thousandSeconds / 3600000;
    }

    public long longDenominator() {
        return 3600000L;
    }

    public long longNumerator() {
        return this.thousandSeconds;
    }

    public long longValue() {
        return this.thousandSeconds / 3600000;
    }

    public Number multiply(Number value) {
        return null;
    }

    public Number negate() {
        return new Degree(-this.thousandSeconds);
    }

    public Number reciprocal() {
        return null;
    }

    public Number subtract(Number value) {
        return new Degree(this.thousandSeconds - value.intValue() * 1000);
    }

    public String toString() {
        return Degree.toString(this.thousandSeconds);
    }
}

