/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.samples.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.soda.devicekit.ui.samples.SamplePlugin;
import org.eclipse.soda.devicekit.ui.samples.extension.WizardContent;
import org.eclipse.soda.devicekit.ui.samples.extension.project.EclipseProject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;

public class SampleWizardPage
extends WizardPage
implements Listener {
    protected Tree tree;
    CheckboxTreeViewer checkboxViewer = null;
    private WizardContent[] wizardContent;
    private String filter = "*";
    private Combo filterText = null;
    SelectionListener selectionListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent arg0) {
            Boolean bool = (Boolean)arg0.widget.getData();
            SampleWizardPage.this.selectAll(bool);
        }
    };
    IContentProvider contentProvider = new ITreeContentProvider(){

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof WizardContent) {
                WizardContent wizardContent = (WizardContent)parentElement;
                return wizardContent.getEclipseProjects();
            }
            return new Object[0];
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public Object getParent(Object element) {
            if (element instanceof EclipseProject) {
                EclipseProject eclipseProject = (EclipseProject)element;
                return eclipseProject.getWizardContent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof WizardContent;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    };
    ICheckStateListener checkStateListener = new ICheckStateListener(){

        public void checkStateChanged(CheckStateChangedEvent event) {
            boolean checked = event.getChecked();
            Object element = event.getElement();
            if (element instanceof WizardContent) {
                WizardContent content = (WizardContent)element;
                SampleWizardPage.this.update(content, checked);
            } else if (element instanceof EclipseProject) {
                EclipseProject content = (EclipseProject)element;
                content.setInstall(checked);
                content.getWizardContent().increaseInstallCount(checked);
                SampleWizardPage.this.updateWizardContentViewer(content.getWizardContent());
            }
            SampleWizardPage.this.getWizard().getContainer().updateButtons();
            SampleWizardPage.this.checkboxViewer.refresh();
        }
    };
    ILabelProvider labelProvider = new LabelProvider(){

        public String getText(Object element) {
            if (element instanceof WizardContent) {
                WizardContent wizardContent = (WizardContent)element;
                if (wizardContent.isPartial()) {
                    return String.valueOf(wizardContent.getGroup()) + " (partial)";
                }
                return wizardContent.getGroup();
            }
            if (element instanceof EclipseProject) {
                String name = ((EclipseProject)element).getProjectName();
                return name;
            }
            return String.valueOf(element);
        }
    };

    public SampleWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public SampleWizardPage(String pageName, String pageDescription, WizardContent[] wizardContent) {
        super(pageName);
        this.wizardContent = wizardContent;
        this.setTitle(pageName);
        this.setDescription(pageDescription);
    }

    private void addButtons(Composite parent) {
        Composite composite = this.createComposite(parent, 4, 5, 128);
        Label label = new Label(composite, 16384);
        label.setText(SamplePlugin.getResourceString("wizard.button.filter"));
        String hint = SamplePlugin.getResourceString("wizard.button.filter.hint");
        this.filterText = new Combo(composite, 2048);
        if (hint != null && hint.length() > 0) {
            label.setToolTipText(hint);
            this.filterText.setToolTipText(hint);
        }
        String[] items = new String[]{"*", "*.test*", "*.testcase*", "*.adapter.test*", "*.connection.test*", "*.device.test*", "*.profile.test*", "*.transport.test*", "*.adapter*", "*.device*", "*.profile*", "*.transport*"};
        this.filterText.setItems(items);
        this.filterText.setText(this.getFilter());
        this.filterText.addListener(24, (Listener)this);
        Button selectAll = new Button(composite, 8);
        selectAll.setText(SamplePlugin.getResourceString("wizard.button.selectall"));
        hint = SamplePlugin.getResourceString("wizard.button.selectall.hint");
        if (hint != null && hint.length() > 0) {
            selectAll.setToolTipText(hint);
        }
        selectAll.setData((Object)Boolean.TRUE);
        selectAll.addSelectionListener(this.selectionListener);
        Button deselectAll = new Button(composite, 8);
        deselectAll.setText(SamplePlugin.getResourceString("wizard.button.deselectall"));
        hint = SamplePlugin.getResourceString("wizard.button.deselectall.hint");
        if (hint != null && hint.length() > 0) {
            deselectAll.setToolTipText(hint);
        }
        deselectAll.setData((Object)Boolean.FALSE);
        deselectAll.addSelectionListener(this.selectionListener);
    }

    private void addTable(Composite parent) {
        this.sortWizardContent();
        this.tree = new Tree(parent, 2080);
        this.checkboxViewer = new CheckboxTreeViewer(this.tree);
        this.checkboxViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.checkboxViewer.setContentProvider(this.contentProvider);
        this.checkboxViewer.addCheckStateListener(this.checkStateListener);
        this.checkboxViewer.setInput((Object)this.wizardContent);
        GridData gd = new GridData(1808);
        gd.heightHint = 0;
        this.checkboxViewer.getTree().setLayoutData((Object)gd);
        int i = 0;
        while (i < this.wizardContent.length) {
            this.updateWizardContentViewer(this.wizardContent[i]);
            ++i;
        }
        this.checkboxViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Object element = event.getElement();
                if (element instanceof WizardContent) {
                    WizardContent wizardContent = (WizardContent)element;
                    SampleWizardPage.this.updateChildrenViewer(wizardContent);
                    return;
                }
                SampleWizardPage.this.updateAll();
            }
        });
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    private Composite createComposite(Composite parent, int columns, int marginWidth, int gridDataStyle) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = marginWidth;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(gridDataStyle);
        composite.setLayoutData((Object)gd);
        return composite;
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1, 0, 1808);
        this.addTable(composite);
        this.addButtons(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)parent);
    }

    public String getFilter() {
        return this.filter;
    }

    public Tree getTree() {
        return this.tree;
    }

    public void handleEvent(Event event) {
        if (event.type == 24 && this.filterText != null) {
            this.filter = this.filterText.getText();
            this.updateAll();
            this.checkboxViewer.refresh();
        }
    }

    public boolean isPageComplete() {
        int i = 0;
        while (i < this.wizardContent.length) {
            if (this.wizardContent[i].doInstall()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean matchesFilter(String name) {
        String filter = this.getFilter();
        if (filter != null && filter.length() > 1) {
            if (filter.startsWith("*")) {
                if (filter.endsWith("*")) {
                    return name.indexOf(filter.substring(1, filter.length() - 1)) >= 0;
                }
                return name.endsWith(filter.substring(1));
            }
            if (filter.endsWith("*")) {
                return name.startsWith(filter.substring(0, filter.length() - 1));
            }
        }
        return true;
    }

    void selectAll(boolean selection) {
        this.checkboxViewer.setAllChecked(selection);
        int i = 0;
        while (i < this.wizardContent.length) {
            this.update(this.wizardContent[i], selection);
            ++i;
        }
        this.getWizard().getContainer().updateButtons();
        this.checkboxViewer.refresh();
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setTree(Tree tree) {
        this.tree = tree;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    private void sortWizardContent() {
        ArrayList primaries = new ArrayList();
        ArrayList secondaries = new ArrayList();
        int i = 0;
        while (i < this.wizardContent.length) {
            if (this.wizardContent[i].isPrimary()) {
                this.sortedAdd(this.wizardContent[i], primaries);
            } else {
                this.sortedAdd(this.wizardContent[i], secondaries);
            }
            ++i;
        }
        this.wizardContent = new WizardContent[primaries.size() + secondaries.size()];
        i = 0;
        while (i < primaries.size()) {
            this.wizardContent[i] = (WizardContent)primaries.get(i);
            ++i;
        }
        i = primaries.size();
        while (i < secondaries.size() + primaries.size()) {
            this.wizardContent[i] = (WizardContent)secondaries.get(i - primaries.size());
            ++i;
        }
    }

    private void sortedAdd(WizardContent content, List list) {
        if (list.size() == 0) {
            list.add(content);
        } else {
            int index = list.size();
            while (index > 0) {
                WizardContent contentFromList = (WizardContent)list.get(index - 1);
                int compare = contentFromList.getGroup().compareTo(content.getGroup());
                if (compare < 0 || compare == 0 && contentFromList.toString().compareTo(content.toString()) < 0) break;
                --index;
            }
            list.add(index, content);
        }
    }

    protected void update(WizardContent content, boolean checked) {
        content.installAll(checked);
        this.updateWizardContentViewer(content);
        this.updateChildren(content, checked);
    }

    protected void updateAll() {
        int i = 0;
        while (i < this.wizardContent.length) {
            boolean install = this.wizardContent[i].doInstall();
            this.updateChildren(this.wizardContent[i], install);
            ++i;
        }
    }

    protected void updateChildren(WizardContent content, boolean checked) {
        EclipseProject[] projects = content.getEclipseProjects();
        if (!content.isPartial()) {
            int i = 0;
            while (i < projects.length) {
                boolean match = this.matchesFilter(projects[i].getProjectName());
                if (match) {
                    projects[i].setInstall(checked);
                    this.checkboxViewer.setChecked((Object)projects[i], checked);
                    this.checkboxViewer.setGrayed((Object)projects[i], false);
                } else {
                    this.checkboxViewer.setChecked((Object)projects[i], false);
                    this.checkboxViewer.setGrayed((Object)projects[i], true);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < projects.length) {
                boolean match = this.matchesFilter(projects[i].getProjectName());
                if (match) {
                    this.checkboxViewer.setGrayed((Object)projects[i], false);
                } else {
                    this.checkboxViewer.setGrayed((Object)projects[i], true);
                }
                ++i;
            }
        }
    }

    protected void updateChildrenViewer(WizardContent content) {
        EclipseProject[] projects = content.getEclipseProjects();
        int j = 0;
        while (j < projects.length) {
            this.checkboxViewer.setChecked((Object)projects[j], projects[j].isInstall());
            ++j;
        }
    }

    protected void updateWizardContentViewer(WizardContent content) {
        this.checkboxViewer.setChecked((Object)content, content.doInstall());
        this.checkboxViewer.setGrayed((Object)content, content.isPartial());
    }
}

