/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

public class BytesGenerator {
    public static final int[] BIT_MASKS = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    public static final int[] MASKS = new int[]{255, 127, 63, 31, 15, 7, 3, 1};
    public static final int[] SET_MASKS;
    public static final int[] SET_TOP_MASKS;
    protected StringBuffer buffer = new StringBuffer();
    protected byte[] bytes = new byte[1];
    protected StringBuffer commentBuffer = new StringBuffer();
    protected int count = 0;
    protected byte[] filterBytes = new byte[1];
    protected boolean filterValid = true;
    protected int length = 0;
    protected int offset = 0;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 15;
        nArray[5] = 31;
        nArray[6] = 63;
        nArray[7] = 127;
        SET_MASKS = nArray;
        SET_TOP_MASKS = new int[]{128, 192, 224, 240, 248, 252, 254, 255};
    }

    public static byte[] expand(byte[] bytes, int offset, int length) {
        if (offset % 8 == 0 && length % 8 == 0) {
            int index = offset >> 3;
            int size = length >> 3;
            byte[] returnBytes = new byte[size + bytes.length];
            System.arraycopy(bytes, 0, returnBytes, 0, index);
            System.arraycopy(bytes, index, returnBytes, index + size, bytes.length - index);
            return returnBytes;
        }
        int size = length + 7 >> 3;
        byte[] returnBytes = new byte[size + bytes.length];
        BytesGenerator.setBytes(returnBytes, 0, offset, bytes);
        int upperLength = (bytes.length << 3) - offset;
        byte[] upperBytes = BytesGenerator.getBytes(bytes, offset, upperLength);
        BytesGenerator.setBytes(returnBytes, offset + length, upperLength, upperBytes);
        return returnBytes;
    }

    public static byte[] getBytes(byte[] bytes, int offset, int length) {
        int ioffset = offset >= 0 ? offset : -offset;
        int resultsLength = length + 7 >> 3;
        byte[] results = new byte[resultsLength];
        if (ioffset % 8 == 0) {
            System.arraycopy(bytes, ioffset >> 3, results, 0, resultsLength);
            int bitOffset = length % 8;
            if (bitOffset != 0) {
                results[resultsLength - 1] = (byte)(results[resultsLength - 1] & SET_TOP_MASKS[bitOffset - 1]);
            }
        } else if (length <= 64) {
            long value = BytesGenerator.getUnsignedLong(bytes, ioffset, length);
            BytesGenerator.setBits(results, 0, length, value);
        } else {
            int count = (length + 63) / 64;
            int toffset = ioffset;
            int tnewOffset = 0;
            int i = 0;
            while (i < count) {
                int tlength = length - i * 64;
                if (tlength > 64) {
                    tlength = 64;
                }
                long value = BytesGenerator.getUnsignedLong(bytes, toffset, tlength);
                BytesGenerator.setBits(results, tnewOffset, tlength, value);
                tnewOffset += 64;
                toffset += 64;
                tlength = length - i * 64;
                ++i;
            }
        }
        return results;
    }

    public static short getDefaultStyle() {
        return 0;
    }

    public static long getLong(byte[] bytes, int offset, int length) {
        int ioffset = offset >= 0 ? offset : -offset;
        long result = 0L;
        int currentOffset = ioffset;
        int currentLength = length;
        int index = ioffset >> 3;
        boolean negative = false;
        boolean first = true;
        while (currentLength > 0) {
            int currentBit = currentOffset % 8;
            int shiftAmount = 8 - currentBit;
            byte byteValue = bytes[index++];
            if (first) {
                negative = (byteValue & BIT_MASKS[currentBit]) != 0;
                first = false;
            }
            int value = byteValue & MASKS[currentBit];
            int shiftEnd = 8 - currentBit - currentLength;
            if (shiftEnd > 0) {
                shiftAmount -= shiftEnd;
                value >>= shiftEnd;
            }
            result = (result << shiftAmount) + (long)value;
            currentOffset += shiftAmount;
            currentLength -= shiftAmount;
        }
        if (negative) {
            int deltaShift = 64 - length;
            if (deltaShift > 0) {
                result <<= deltaShift;
                result >>= deltaShift;
            }
            return result;
        }
        return result;
    }

    public static long getUnsignedLong(byte[] bytes, int offset, int length) {
        int ioffset = offset >= 0 ? offset : -offset;
        long result = 0L;
        int currentOffset = ioffset;
        int currentLength = length;
        int index = ioffset >> 3;
        while (currentLength > 0) {
            int currentBit = currentOffset % 8;
            int shiftAmount = 8 - currentBit;
            int value = bytes[index++] & MASKS[currentBit];
            int shiftEnd = 8 - currentBit - currentLength;
            if (shiftEnd > 0) {
                shiftAmount -= shiftEnd;
                value >>= shiftEnd;
            }
            result = (result << shiftAmount) + (long)value;
            currentOffset += shiftAmount;
            currentLength -= shiftAmount;
        }
        return result;
    }

    public static void main(String[] arguments) {
        BytesGenerator bytesGenerator = new BytesGenerator();
        byte[] byArray = new byte[4];
        byArray[1] = -1;
        byArray[2] = 2;
        byArray[3] = 3;
        bytesGenerator.add(31, byArray, true, "i0");
        bytesGenerator.add(1, new byte[]{-1}, false, "i1");
        bytesGenerator.add(1, -1L, true, "true");
        bytesGenerator.add(64, 1234L, false, "true");
        bytesGenerator.add(64, 0L, false, "false");
        System.out.println("bytes   " + bytesGenerator.getBytesCode());
        System.out.println("filter  " + bytesGenerator.getFilterBytesCode());
        bytesGenerator.reduce();
        System.out.println("bytes   " + bytesGenerator.getBytesCode());
        System.out.println("comment " + bytesGenerator.getCodeComment());
    }

    public static byte[] setBits(byte[] bytes, int offset, int length, long value) {
        int ioffset = offset >= 0 ? offset : -offset;
        long currentValue = value;
        int currentOffset = ioffset + length - 1;
        int currentLength = length;
        int index = currentOffset >> 3;
        while (currentLength > 0) {
            int currentBit = currentOffset % 8;
            int shiftAmount = currentBit + 1;
            int tvalue = bytes[index];
            int mask = SET_MASKS[7 - currentBit];
            int startBit = currentBit - currentLength;
            if (startBit >= 0) {
                mask |= SET_TOP_MASKS[startBit];
            }
            tvalue &= mask;
            int newValue = (int)(currentValue & (long)MASKS[7 - currentBit]);
            int extraShift = 8 - shiftAmount;
            if (extraShift > 0) {
                newValue <<= extraShift;
            }
            currentValue >>>= shiftAmount;
            bytes[index--] = (byte)(tvalue | newValue);
            currentOffset -= shiftAmount;
            currentLength -= shiftAmount;
        }
        return bytes;
    }

    public static byte[] setBytes(byte[] bytes, int offset, int length, byte[] data) {
        int ioffset;
        byte[] tbytes = bytes;
        if (offset < 0) {
            tbytes = BytesGenerator.expand(bytes, -offset, length);
        }
        int n = ioffset = offset >= 0 ? offset : -offset;
        if (ioffset % 8 == 0 && length % 8 == 0) {
            System.arraycopy(data, 0, tbytes, ioffset >> 3, length >> 3);
        } else if (length <= 64) {
            long value = BytesGenerator.getUnsignedLong(data, 0, length);
            BytesGenerator.setBits(tbytes, ioffset, length, value);
        } else {
            int count = (length + 63) / 64;
            int toffset = ioffset;
            int tnewOffset = 0;
            int i = 0;
            while (i < count) {
                int tlength = length - i * 64;
                if (tlength > 64) {
                    tlength = 64;
                }
                long value = BytesGenerator.getLong(data, toffset - ioffset, tlength);
                BytesGenerator.setBits(tbytes, toffset, tlength, value);
                tnewOffset += 64;
                toffset += 64;
                tlength = length - i * 64;
                ++i;
            }
        }
        return tbytes;
    }

    public void add(int length, byte[] data, boolean care, String comment) {
        ++this.count;
        this.checkBytes(this.offset, length);
        this.bytes = BytesGenerator.setBytes(this.bytes, this.offset, length, data);
        if (this.commentBuffer.length() > 0) {
            this.commentBuffer.append("\n// ");
        } else {
            this.commentBuffer.append("// ");
        }
        this.commentBuffer.append('[');
        this.commentBuffer.append(this.toStringComment(data));
        this.commentBuffer.append("],\t");
        if (length < 100) {
            this.commentBuffer.append(' ');
        }
        if (length < 10) {
            this.commentBuffer.append(' ');
        }
        this.commentBuffer.append(length);
        if (length == 1) {
            this.commentBuffer.append(" bit ");
        } else {
            this.commentBuffer.append(" bits");
        }
        if (comment.length() > 0) {
            this.commentBuffer.append('\t');
            this.commentBuffer.append(comment);
        }
        this.filterBytes = care && this.isFilterValid() ? BytesGenerator.setBits(this.filterBytes, this.offset, length, -1L) : BytesGenerator.setBits(this.filterBytes, this.offset, length, 0L);
        this.update(length);
    }

    public void add(int offset, int length, byte[] bytes) {
        this.checkBytes(offset, length);
        this.bytes = BytesGenerator.setBytes(this.bytes, offset, length, bytes);
    }

    public void add(int length, long data, boolean care, String comment) {
        ++this.count;
        this.checkBytes(this.offset, length);
        this.bytes = BytesGenerator.setBits(this.bytes, this.offset, length, data);
        if (this.commentBuffer.length() > 0) {
            this.commentBuffer.append("\n// ");
        } else {
            this.commentBuffer.append("// ");
        }
        this.commentBuffer.append(Long.toString(data));
        if (data > 9L) {
            this.commentBuffer.append('\t');
            this.commentBuffer.append(Long.toHexString(data));
            this.commentBuffer.append(",\t");
        } else {
            this.commentBuffer.append(",\t\t");
        }
        if (length < 100) {
            this.commentBuffer.append(' ');
        }
        if (length < 10) {
            this.commentBuffer.append(' ');
        }
        this.commentBuffer.append(length);
        if (length == 1) {
            this.commentBuffer.append(" bit ");
        } else {
            this.commentBuffer.append(" bits");
        }
        if (comment.length() > 0) {
            this.commentBuffer.append('\t');
            this.commentBuffer.append(comment);
        }
        this.filterBytes = care && this.isFilterValid() ? BytesGenerator.setBits(this.filterBytes, this.offset, length, -1L) : BytesGenerator.setBits(this.filterBytes, this.offset, length, 0L);
        this.update(length);
    }

    protected void checkBytes(int offset, int length) {
        int end = offset + length;
        int size = end + 7 >> 3;
        if (this.bytes.length < size) {
            byte[] newBytes = new byte[size];
            System.arraycopy(this.bytes, 0, newBytes, 0, this.bytes.length);
            this.bytes = newBytes;
            newBytes = new byte[size];
            System.arraycopy(this.filterBytes, 0, newBytes, 0, this.filterBytes.length);
            this.filterBytes = newBytes;
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getBytesCode() {
        return this.toString(this.bytes);
    }

    public String getCodeComment() {
        if (this.count > 1) {
            this.commentBuffer.append("\n// {");
            this.commentBuffer.append(this.toStringComment(this.bytes));
            this.commentBuffer.append('}');
        }
        return this.commentBuffer.toString();
    }

    public String getFilterBytesCode() {
        return this.toString(this.filterBytes);
    }

    public String getFilterComment() {
        return this.commentBuffer.toString();
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isFilterValid() {
        return this.filterValid;
    }

    public void reduce() {
        int count = 0;
        int i = this.getLength() - 1;
        while (i >= 0) {
            if (BytesGenerator.getUnsignedLong(this.filterBytes, i, 1) == 1L) break;
            BytesGenerator.setBits(this.bytes, i, 1, 0L);
            ++count;
            --i;
        }
        this.setLength(this.getLength() - count);
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public void setFilterValid(boolean filterValid) {
        this.filterValid = filterValid;
    }

    public void setLength(int length) {
        this.length = length;
        if (length < this.bytes.length * 8) {
            byte[] newBytes = new byte[length + 7 >> 3];
            System.arraycopy(this.bytes, 0, newBytes, 0, newBytes.length);
            this.bytes = newBytes;
        }
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public String toString() {
        return this.toString(this.bytes);
    }

    public String toString(byte[] bytes) {
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append("new byte[] {");
        int i = 0;
        while (i < bytes.length) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(bytes[i]);
            ++i;
        }
        buffer.append('}');
        return buffer.toString();
    }

    public String toStringComment(byte[] bytes) {
        StringBuffer buffer = new StringBuffer(1024);
        int i = 0;
        while (i < bytes.length) {
            if (i > 0) {
                buffer.append(' ');
            }
            if ((bytes[i] & 0xFF) < 16) {
                buffer.append('0');
            }
            buffer.append(Integer.toHexString(bytes[i] & 0xFF));
            ++i;
        }
        return buffer.toString();
    }

    protected void update(int length) {
        this.offset += length;
        this.length += length;
    }
}

