/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.filelog.rotate;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.rdfpatch.filelog.rotate.FileMgr;
import org.apache.jena.rdfpatch.filelog.rotate.FileRotateException;
import org.apache.jena.rdfpatch.filelog.rotate.Filename;
import org.apache.jena.rdfpatch.filelog.rotate.Roller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RollerDate
implements Roller {
    private static final Logger LOG = LoggerFactory.getLogger(RollerDate.class);
    private final Path directory;
    private final String baseFilename;
    private Path latestFilename = null;
    private LocalDate current = LocalDate.now();
    private static final Pattern patternFilenameDate = Pattern.compile("(.*)(-)(\\d{4}-\\d{2}-\\d{2})");
    private static final String DATE_SEP = "-";
    private static final DateTimeFormatter fmtDate = DateTimeFormatter.ISO_LOCAL_DATE;
    private static final Comparator<Filename> cmpDate = (x, y) -> {
        LocalDate xdt = RollerDate.filenameToDate(x);
        LocalDate ydt = RollerDate.filenameToDate(y);
        return xdt.compareTo(ydt);
    };
    private ZoneId zoneId = ZoneId.systemDefault();

    private static LocalDate filenameToDate(Filename filename) {
        return LocalDate.parse(filename.modifier, fmtDate);
    }

    RollerDate(Path directory, String baseFilename) {
        this.directory = directory;
        this.baseFilename = baseFilename;
        this.init(directory, baseFilename);
    }

    private void init(Path directory, String baseFilename) {
        List<Filename> filenames = FileMgr.scan(directory, baseFilename, patternFilenameDate);
        if (filenames.isEmpty()) {
            this.latestFilename = null;
        } else {
            LocalDate dateLast = RollerDate.filenameToDate(Collections.max(filenames, cmpDate));
            LocalDate dateFirst = RollerDate.filenameToDate(Collections.min(filenames, cmpDate));
            int problems = 0;
            if (dateLast.isAfter(this.current)) {
                ++problems;
                FmtLog.warn(LOG, "Latest output file is dated after today: %s > %s", dateLast, this.current);
            }
            if (dateFirst.isAfter(this.current)) {
                ++problems;
                FmtLog.warn(LOG, "First output file is dated after today: %s > %s", dateFirst, this.current);
            }
            if (problems > 0) {
                throw new FileRotateException("Existing files dated into the future");
            }
            this.latestFilename = this.filename(dateLast);
        }
    }

    @Override
    public Stream<Filename> files() {
        List<Filename> filenames = FileMgr.scan(this.directory, this.baseFilename, patternFilenameDate);
        return filenames.stream().sorted(cmpDate);
    }

    @Override
    public Path directory() {
        return this.directory;
    }

    @Override
    public void startSection() {
    }

    @Override
    public void finishSection() {
    }

    @Override
    public Path latestFilename() {
        return this.latestFilename;
    }

    @Override
    public boolean hasExpired() {
        return LocalDate.now(this.zoneId).isAfter(this.current);
    }

    @Override
    public void rotate() {
    }

    @Override
    public Path nextFilename() {
        LocalDate nextCurrent = LocalDate.now(this.zoneId);
        if (nextCurrent.equals(this.current)) {
            // empty if block
        }
        this.current = nextCurrent;
        this.latestFilename = this.filename(nextCurrent);
        return this.latestFilename;
    }

    private Path filename(LocalDate timepoint) {
        String fn = this.baseFilename + DATE_SEP + timepoint.format(fmtDate);
        Path path = this.directory.resolve(fn);
        if (Files.exists(path, new LinkOption[0])) {
            FmtLog.warn(LOG, "Using existing file: " + fn, new Object[0]);
        }
        return path;
    }
}

