/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.elk.core.data.ILayoutMetaData;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutCategoryData;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.graph.json.JsonAdapter;
import org.eclipse.elk.graph.properties.GraphFeature;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public final class JsonMetaDataConverter {
    @Extension
    private static JsonAdapter _jsonAdapter = new JsonAdapter();

    private static JsonObject createCommon(ILayoutMetaData data) {
        String _description;
        boolean _tripleNotEquals_2;
        String _name;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        JsonObject jsonObj = _jsonAdapter.newJsonObject();
        String _id = data.getId();
        boolean bl = _tripleNotEquals = _id != null;
        if (_tripleNotEquals) {
            _jsonAdapter.addJsonObj(jsonObj, "id", data.getId());
        }
        boolean bl2 = _tripleNotEquals_1 = (_name = data.getName()) != null;
        if (_tripleNotEquals_1) {
            _jsonAdapter.addJsonObj(jsonObj, "name", data.getName());
        }
        boolean bl3 = _tripleNotEquals_2 = (_description = data.getDescription()) != null;
        if (_tripleNotEquals_2) {
            _jsonAdapter.addJsonObj(jsonObj, "description", data.getDescription());
        }
        return jsonObj;
    }

    protected static JsonObject _toJson(LayoutAlgorithmData lad) {
        boolean _isNullOrEmpty_1;
        boolean _not_1;
        boolean _isNullOrEmpty;
        boolean _not;
        boolean _tripleNotEquals;
        JsonObject jsonObj = JsonMetaDataConverter.createCommon((ILayoutMetaData)lad);
        String _categoryId = lad.getCategoryId();
        boolean bl = _tripleNotEquals = _categoryId != null;
        if (_tripleNotEquals) {
            _jsonAdapter.addJsonObj(jsonObj, "category", lad.getCategoryId());
        }
        boolean bl2 = _not = !(_isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)lad.getKnownOptionIds()));
        if (_not) {
            JsonArray jsonArr = _jsonAdapter.newJsonArray();
            _jsonAdapter.addJsonObj(jsonObj, "knownOptions", (JsonElement)jsonArr);
            Consumer<String> _function = o -> _jsonAdapter.addJsonArr(jsonArr, (JsonElement)_jsonAdapter.toJson((String)o));
            lad.getKnownOptionIds().forEach(_function);
        }
        boolean bl3 = _not_1 = !(_isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)lad.getSupportedFeatures()));
        if (_not_1) {
            JsonArray jsonArr_1 = _jsonAdapter.newJsonArray();
            _jsonAdapter.addJsonObj(jsonObj, "supportedFeatures", (JsonElement)jsonArr_1);
            Consumer<GraphFeature> _function_1 = f -> _jsonAdapter.addJsonArr(jsonArr_1, (JsonElement)_jsonAdapter.toJson(f.toString()));
            lad.getSupportedFeatures().forEach(_function_1);
        }
        return jsonObj;
    }

    protected static JsonObject _toJson(LayoutCategoryData lcd) {
        boolean _not;
        JsonObject jsonObj = JsonMetaDataConverter.createCommon((ILayoutMetaData)lcd);
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)lcd.getLayouters());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            JsonArray jsonArr = _jsonAdapter.newJsonArray();
            _jsonAdapter.addJsonObj(jsonObj, "knownLayouters", (JsonElement)jsonArr);
            Consumer<LayoutAlgorithmData> _function = l -> {
                boolean _tripleNotEquals;
                String _id = l.getId();
                boolean bl = _tripleNotEquals = _id != null;
                if (_tripleNotEquals) {
                    _jsonAdapter.addJsonArr(jsonArr, (JsonElement)_jsonAdapter.toJson(l.getId()));
                }
            };
            lcd.getLayouters().forEach(_function);
        }
        return jsonObj;
    }

    protected static JsonObject _toJson(LayoutOptionData lod) {
        boolean _isNullOrEmpty;
        boolean _not;
        LayoutOptionData.Type _type;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        JsonObject jsonObj = JsonMetaDataConverter.createCommon((ILayoutMetaData)lod);
        String _group = lod.getGroup();
        boolean bl = _tripleNotEquals = _group != null;
        if (_tripleNotEquals) {
            _jsonAdapter.addJsonObj(jsonObj, "group", lod.getGroup());
        }
        boolean bl2 = _tripleNotEquals_1 = (_type = lod.getType()) != null;
        if (_tripleNotEquals_1) {
            _jsonAdapter.addJsonObj(jsonObj, "type", lod.getType().toString());
        }
        boolean bl3 = _not = !(_isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)lod.getTargets()));
        if (_not) {
            JsonArray jsonArr = _jsonAdapter.newJsonArray();
            _jsonAdapter.addJsonObj(jsonObj, "targets", (JsonElement)jsonArr);
            Consumer<LayoutOptionData.Target> _function = t -> _jsonAdapter.addJsonArr(jsonArr, (JsonElement)_jsonAdapter.toJson(t.toString()));
            lod.getTargets().forEach(_function);
        }
        return jsonObj;
    }

    @XbaseGenerated
    public static JsonObject toJson(ILayoutMetaData lad) {
        if (lad instanceof LayoutAlgorithmData) {
            return JsonMetaDataConverter._toJson((LayoutAlgorithmData)lad);
        }
        if (lad instanceof LayoutCategoryData) {
            return JsonMetaDataConverter._toJson((LayoutCategoryData)lad);
        }
        if (lad instanceof LayoutOptionData) {
            return JsonMetaDataConverter._toJson((LayoutOptionData)lad);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(lad).toString());
    }
}

