/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.bindings.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import org.eclipse.fx.core.bindings.BindingStream;
import org.eclipse.fx.core.bindings.FXCollector;

public class BindingStreamImpl<T>
implements BindingStream<T> {
    public final ObservableValue<?> base;
    public final List<StreamStep<?, ?>> path;

    public BindingStreamImpl(ObservableValue<?> base) {
        this.base = base;
        this.path = new ArrayList();
    }

    private BindingStreamImpl(ObservableValue<?> base, List<StreamStep<?, ?>> path) {
        this.base = base;
        this.path = path;
    }

    @Override
    public <S> BindingStream<S> map(Function<T, ObservableValue<S>> map) {
        MapValue<T, S> segment = new MapValue<T, S>(map);
        this.path.add(segment);
        return new BindingStreamImpl<T>(this.base, this.path);
    }

    @Override
    public <S> BindingStream<S> mapNoObservable(Function<T, S> map) {
        MapNoObservable<T, S> segment = new MapNoObservable<T, S>(map);
        this.path.add(segment);
        return new BindingStreamImpl<T>(this.base, this.path);
    }

    @Override
    public ObjectBinding<T> toBinding() {
        return new StreamBinding(this.base, this.path);
    }

    @Override
    public <R> R collect(FXCollector<T, R> collector) {
        return collector.finish(this);
    }

    @Override
    public <S> Property<S> toProperty(Function<T, Property<S>> map) {
        ObjectBinding<Property<S>> binding = this.mapNoObservable(map).toBinding();
        SimpleObjectProperty rv = new SimpleObjectProperty<S>(binding){
            private ObjectBinding<Property<S>> b;
            {
                this.b = objectBinding;
            }
        };
        if (binding.get() != null) {
            rv.bindBidirectional((Property)binding.get());
        }
        binding.addListener((arg_0, arg_1, arg_2) -> BindingStreamImpl.lambda$0((ObjectProperty)rv, arg_0, arg_1, arg_2));
        return rv;
    }

    @Override
    public BooleanProperty toBooleanProperty(Function<T, BooleanProperty> map) {
        ObjectBinding<BooleanProperty> binding = this.mapNoObservable(map).toBinding();
        SimpleBooleanProperty rv = new SimpleBooleanProperty(binding){
            private ObjectBinding<BooleanProperty> b;
            {
                this.b = objectBinding;
            }
        };
        if (binding.get() != null) {
            rv.bindBidirectional((Property)binding.get());
        }
        binding.addListener((arg_0, arg_1, arg_2) -> BindingStreamImpl.lambda$1((BooleanProperty)rv, arg_0, arg_1, arg_2));
        return rv;
    }

    @Override
    public DoubleProperty toDoubleProperty(Function<T, DoubleProperty> map) {
        ObjectBinding<DoubleProperty> binding = this.mapNoObservable(map).toBinding();
        SimpleDoubleProperty rv = new SimpleDoubleProperty(binding){
            private ObjectBinding<DoubleProperty> b;
            {
                this.b = objectBinding;
            }
        };
        if (binding.get() != null) {
            rv.bindBidirectional((Property)binding.get());
        }
        binding.addListener((arg_0, arg_1, arg_2) -> BindingStreamImpl.lambda$2((DoubleProperty)rv, arg_0, arg_1, arg_2));
        return rv;
    }

    @Override
    public FloatProperty toFloatProperty(Function<T, FloatProperty> map) {
        ObjectBinding<FloatProperty> binding = this.mapNoObservable(map).toBinding();
        SimpleFloatProperty rv = new SimpleFloatProperty(binding){
            private ObjectBinding<FloatProperty> b;
            {
                this.b = objectBinding;
            }
        };
        if (binding.get() != null) {
            rv.bindBidirectional((Property)binding.get());
        }
        binding.addListener((arg_0, arg_1, arg_2) -> BindingStreamImpl.lambda$3((FloatProperty)rv, arg_0, arg_1, arg_2));
        return rv;
    }

    @Override
    public IntegerProperty toIntegerProperty(Function<T, IntegerProperty> map) {
        ObjectBinding<IntegerProperty> binding = this.mapNoObservable(map).toBinding();
        SimpleIntegerProperty rv = new SimpleIntegerProperty(binding){
            private ObjectBinding<IntegerProperty> b;
            {
                this.b = objectBinding;
            }
        };
        if (binding.get() != null) {
            rv.bindBidirectional((Property)binding.get());
        }
        binding.addListener((arg_0, arg_1, arg_2) -> BindingStreamImpl.lambda$4((IntegerProperty)rv, arg_0, arg_1, arg_2));
        return rv;
    }

    @Override
    public LongProperty toLongProperty(Function<T, LongProperty> map) {
        ObjectBinding<LongProperty> binding = this.mapNoObservable(map).toBinding();
        SimpleLongProperty rv = new SimpleLongProperty(binding){
            private ObjectBinding<LongProperty> b;
            {
                this.b = objectBinding;
            }
        };
        if (binding.get() != null) {
            rv.bindBidirectional((Property)binding.get());
        }
        binding.addListener((arg_0, arg_1, arg_2) -> BindingStreamImpl.lambda$5((LongProperty)rv, arg_0, arg_1, arg_2));
        return rv;
    }

    @Override
    public <S> ObjectProperty<S> toObjectProperty(Function<T, ObjectProperty<S>> map) {
        ObjectBinding<ObjectProperty<S>> binding = this.mapNoObservable(map).toBinding();
        SimpleObjectProperty rv = new SimpleObjectProperty<S>(binding){
            private ObjectBinding<ObjectProperty<S>> b;
            {
                this.b = objectBinding;
            }
        };
        if (binding.get() != null) {
            rv.bindBidirectional((Property)binding.get());
        }
        binding.addListener((arg_0, arg_1, arg_2) -> BindingStreamImpl.lambda$6((ObjectProperty)rv, arg_0, arg_1, arg_2));
        return rv;
    }

    @Override
    public StringProperty toStringProperty(Function<T, StringProperty> map) {
        ObjectBinding<StringProperty> binding = this.mapNoObservable(map).toBinding();
        SimpleStringProperty rv = new SimpleStringProperty(binding){
            private ObjectBinding<StringProperty> b;
            {
                this.b = objectBinding;
            }
        };
        if (binding.get() != null) {
            rv.bindBidirectional((Property)binding.get());
        }
        binding.addListener((arg_0, arg_1, arg_2) -> BindingStreamImpl.lambda$7((StringProperty)rv, arg_0, arg_1, arg_2));
        return rv;
    }

    private static /* synthetic */ void lambda$0(ObjectProperty objectProperty, ObservableValue o, Property ol, Property ne) {
        if (ol != null) {
            objectProperty.unbindBidirectional(ol);
        }
        if (ne != null) {
            objectProperty.bindBidirectional(ne);
        } else {
            objectProperty.set(null);
        }
    }

    private static /* synthetic */ void lambda$1(BooleanProperty booleanProperty, ObservableValue o, BooleanProperty ol, BooleanProperty ne) {
        if (ol != null) {
            booleanProperty.unbindBidirectional((Property)ol);
        }
        if (ne != null) {
            booleanProperty.bindBidirectional((Property)ne);
        } else {
            booleanProperty.set(false);
        }
    }

    private static /* synthetic */ void lambda$2(DoubleProperty doubleProperty, ObservableValue o, DoubleProperty ol, DoubleProperty ne) {
        if (ol != null) {
            doubleProperty.unbindBidirectional((Property)ol);
        }
        if (ne != null) {
            doubleProperty.bindBidirectional((Property)ne);
        } else {
            doubleProperty.set(0.0);
        }
    }

    private static /* synthetic */ void lambda$3(FloatProperty floatProperty, ObservableValue o, FloatProperty ol, FloatProperty ne) {
        if (ol != null) {
            floatProperty.unbindBidirectional((Property)ol);
        }
        if (ne != null) {
            floatProperty.bindBidirectional((Property)ne);
        } else {
            floatProperty.set(0.0f);
        }
    }

    private static /* synthetic */ void lambda$4(IntegerProperty integerProperty, ObservableValue o, IntegerProperty ol, IntegerProperty ne) {
        if (ol != null) {
            integerProperty.unbindBidirectional((Property)ol);
        }
        if (ne != null) {
            integerProperty.bindBidirectional((Property)ne);
        } else {
            integerProperty.set(0);
        }
    }

    private static /* synthetic */ void lambda$5(LongProperty longProperty, ObservableValue o, LongProperty ol, LongProperty ne) {
        if (ol != null) {
            longProperty.unbindBidirectional((Property)ol);
        }
        if (ne != null) {
            longProperty.bindBidirectional((Property)ne);
        } else {
            longProperty.set(0L);
        }
    }

    private static /* synthetic */ void lambda$6(ObjectProperty objectProperty, ObservableValue o, ObjectProperty ol, ObjectProperty ne) {
        if (ol != null) {
            objectProperty.unbindBidirectional((Property)ol);
        }
        if (ne != null) {
            objectProperty.bindBidirectional((Property)ne);
        } else {
            objectProperty.set(null);
        }
    }

    private static /* synthetic */ void lambda$7(StringProperty stringProperty, ObservableValue o, StringProperty ol, StringProperty ne) {
        if (ol != null) {
            stringProperty.unbindBidirectional((Property)ol);
        }
        if (ne != null) {
            stringProperty.bindBidirectional((Property)ne);
        } else {
            stringProperty.set(null);
        }
    }

    private static class MapNoObservable<T, S>
    implements StreamStep<T, S> {
        private final Function<T, S> map;

        public MapNoObservable(Function<T, S> map) {
            this.map = map;
        }

        @Override
        public S apply(T cur, Set<Observable> toTrack) {
            if (cur == null) {
                return null;
            }
            return this.map.apply(cur);
        }
    }

    private static class MapValue<T, S>
    implements StreamStep<T, S> {
        private final Function<T, ObservableValue<S>> map;

        public MapValue(Function<T, ObservableValue<S>> map) {
            this.map = map;
        }

        @Override
        public S apply(T cur, Set<Observable> toTrack) {
            if (cur == null) {
                return null;
            }
            ObservableValue<S> r = this.map.apply(cur);
            toTrack.add((Observable)r);
            return (S)r.getValue();
        }
    }

    public static class StreamBinding<T>
    extends ObjectBinding<T> {
        private ObservableValue<?> base;
        private List<StreamStep<?, ?>> path;
        private Set<Observable> curToTrack;

        public StreamBinding(ObservableValue<?> base, List<StreamStep<?, ?>> path) {
            this.base = base;
            this.path = new ArrayList(path);
            this.bind(new Observable[]{base});
            this.curToTrack = Collections.singleton(this.base);
        }

        public void dispose() {
            if (this.curToTrack != null) {
                this.unbind(this.curToTrack.toArray(new Observable[0]));
            }
            super.dispose();
        }

        protected T computeValue() {
            HashSet<Observable> toTrack = new HashSet<Observable>();
            toTrack.add((Observable)this.base);
            try {
                if (this.path.isEmpty()) {
                    Object object = this.base.getValue();
                    return (T)object;
                }
                Object cur = this.base.getValue();
                for (StreamStep<?, ?> s : this.path) {
                    cur = s.apply(cur, toTrack);
                }
                Object object = cur;
                return (T)object;
            }
            finally {
                if (this.curToTrack != null) {
                    this.unbind(this.curToTrack.toArray(new Observable[0]));
                }
                this.curToTrack = toTrack;
                this.bind(this.curToTrack.toArray(new Observable[0]));
            }
        }
    }

    private static interface StreamStep<T, S> {
        public S apply(T var1, Set<Observable> var2);
    }
}

