/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.model.mtl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum OpenModeKind implements Enumerator
{
    APPEND(0, "Append", "Append"),
    OVER_WRITE(1, "OverWrite", "OverWrite");

    public static final int APPEND_VALUE = 0;
    public static final int OVER_WRITE_VALUE = 1;
    private static final OpenModeKind[] VALUES_ARRAY;
    public static final List<OpenModeKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OpenModeKind[]{APPEND, OVER_WRITE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OpenModeKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OpenModeKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OpenModeKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OpenModeKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OpenModeKind get(int value) {
        switch (value) {
            case 0: {
                return APPEND;
            }
            case 1: {
                return OVER_WRITE;
            }
        }
        return null;
    }

    private OpenModeKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

