/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.sessionexception;

import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@ServerEndpoint(value="/TCKTestServer")
public class WSTestServer {
    private static final System.Logger logger = System.getLogger(WSTestServer.class.getName());
    private static final Class<?>[] TEST_ARGS = new Class[]{String.class, Session.class};
    static String testName;

    @OnOpen
    public void init(Session session) throws IOException {
        session.getBasicRemote().sendText("========TCKTestServer opened");
        if (session.isOpen()) {
            session.getBasicRemote().sendText("========session from Server is open=TRUE");
        } else {
            session.getBasicRemote().sendText("========session from Server is open=FALSE");
        }
    }

    @OnMessage
    public void respondString(String message, Session session) {
        logger.log(System.Logger.Level.INFO, "TCKTestServer got String message: " + message);
        try {
            if (message.startsWith("testName=") && message.endsWith("Test")) {
                testName = message.substring(9);
                Method method = WSTestServer.class.getMethod(testName, TEST_ARGS);
                method.invoke((Object)this, message, session);
            } else {
                session.getBasicRemote().sendText("========TCKTestServer received String:" + message);
                session.getBasicRemote().sendText("========TCKTestServer responds, please close your session");
            }
        }
        catch (InvocationTargetException ite) {
            logger.log(System.Logger.Level.ERROR, "Cannot run method " + testName);
            ite.printStackTrace();
        }
        catch (NoSuchMethodException nsme) {
            logger.log(System.Logger.Level.ERROR, "Test: " + testName + " does not exist");
            nsme.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @OnError
    public void error(Session session, Throwable t) {
        try {
            session.getBasicRemote().sendText("========TCKTestServer onError");
            if (session.isOpen()) {
                session.getBasicRemote().sendText("========onError: session from Server is open=TRUE");
                session.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        t.printStackTrace();
    }
}

