/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.spec.security.denyUncovered;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import servlet.tck.common.client.AbstractTckTest;
import servlet.tck.spec.security.denyUncovered.AllMethodsAllowedAnno;
import servlet.tck.spec.security.denyUncovered.ExcludeAuthConstraint;
import servlet.tck.spec.security.denyUncovered.PartialDDServlet;
import servlet.tck.spec.security.denyUncovered.TestServlet;
import servlet.tck.util.WebUtil;

public class DenyUncoveredTests
extends AbstractTckTest {
    private String hostname = null;
    private int portnum = 0;
    private String contextPath = "/servlet_sec_denyUncovered_web";
    private String ctxtTestServlet = this.contextPath + "/TestServlet";
    private String ctxtAllMethodsAllowedAnno = this.contextPath + "/AllMethodsAllowedAnno";
    private String ctxtExcludeAuthConstraint = this.contextPath + "/ExcludeAuthConstraint";
    private String ctxtPartialDDServlet = this.contextPath + "/PartialDDServlet";
    private String username = "";
    private String password = "";

    @Deployment(testable=false)
    public static WebArchive getTestArchive() throws Exception {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"servlet_sec_denyUncovered_web.war")).addClasses(new Class[]{AllMethodsAllowedAnno.class, ExcludeAuthConstraint.class, PartialDDServlet.class, TestServlet.class})).setWebXML(DenyUncoveredTests.class.getResource("servlet_sec_denyUncovered_web.xml"));
    }

    @Override
    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.hostname = p.getProperty("webServerHost");
            this.portnum = Integer.parseInt(p.getProperty("webServerPort"));
            this.username = p.getProperty("user");
            this.password = p.getProperty("password");
        }
        catch (Exception e) {
            this.logErr("Error: got exception: ", e);
        }
    }

    @Override
    public void cleanup() throws Exception {
    }

    @Test
    public void testAllMethodsAllowedAnno() throws Exception {
        int httpStatusCode = this.invokeServlet(this.ctxtAllMethodsAllowedAnno, "POST");
        if (httpStatusCode != 200) {
            this.logger.error("Accessing {} (POST) returns = {}", (Object)this.ctxtAllMethodsAllowedAnno, (Object)httpStatusCode);
            throw new Exception("testAllMethodsAllowedAnno : FAILED");
        }
        httpStatusCode = this.invokeServlet(this.ctxtAllMethodsAllowedAnno, "GET");
        if (httpStatusCode != 200) {
            this.logger.error("Accessing {} (GET) returns = {}", (Object)this.ctxtAllMethodsAllowedAnno, (Object)httpStatusCode);
            throw new Exception("testAllMethodsAllowedAnno : FAILED");
        }
        httpStatusCode = this.invokeServlet(this.ctxtAllMethodsAllowedAnno, "PUT");
        if (httpStatusCode != 200) {
            this.logger.debug("Accessing {} (PUT) returns = {}", (Object)this.ctxtAllMethodsAllowedAnno, (Object)httpStatusCode);
            throw new Exception("testAllMethodsAllowedAnno : FAILED");
        }
        httpStatusCode = this.invokeServlet(this.ctxtAllMethodsAllowedAnno, "DELETE");
        if (httpStatusCode != 200) {
            this.logger.debug("Accessing {} (DELETE) returns = {}", (Object)this.ctxtAllMethodsAllowedAnno, (Object)httpStatusCode);
            throw new Exception("testAllMethodsAllowedAnno : FAILED");
        }
        this.logger.debug("testAllMethodsAllowedAnno : PASSED");
    }

    @Test
    public void testAccessToMethodAllowed() throws Exception {
        int httpStatusCode = this.invokeServlet(this.ctxtTestServlet, "POST");
        if (httpStatusCode != 200) {
            this.logger.debug("Accessing {} (POST) returns = {}", (Object)this.ctxtTestServlet, (Object)httpStatusCode);
            throw new Exception("testAccessToMethodAllowed : FAILED");
        }
        httpStatusCode = this.invokeServlet(this.ctxtTestServlet, "GET");
        if (httpStatusCode != 200) {
            this.logger.debug("Accessing {} (GET) returns = {}", (Object)this.ctxtTestServlet, (Object)httpStatusCode);
            throw new Exception("testAccessToMethodAllowed : FAILED");
        }
        this.logger.debug("testAccessToMethodAllowed : PASSED");
    }

    @Test
    public void testDenySomeUncovered() throws Exception {
        int httpStatusCode = this.invokeServlet(this.ctxtTestServlet, "DELETE");
        if (httpStatusCode != 403) {
            this.logger.debug("Accessing {} (DELETE) returns = {}", (Object)this.ctxtTestServlet, (Object)httpStatusCode);
            throw new Exception("testDenySomeUncovered : FAILED");
        }
        httpStatusCode = this.invokeServlet(this.ctxtTestServlet, "PUT");
        if (httpStatusCode != 403) {
            this.logger.debug("Accessing {} (PUT) returns = {}", (Object)this.ctxtTestServlet, (Object)httpStatusCode);
            throw new Exception("testDenySomeUncovered : FAILED");
        }
        this.logger.debug("testDenySomeUncovered : PASSED");
    }

    @Test
    public void testExcludeAuthConstraint() throws Exception {
        int httpStatusCode = this.invokeServlet(this.ctxtExcludeAuthConstraint, "GET");
        if (httpStatusCode != 403) {
            this.logger.debug("Accessing {}} (GET) returns = {}", (Object)this.ctxtExcludeAuthConstraint, (Object)httpStatusCode);
            throw new Exception("testExcludeAuthConstraint : FAILED");
        }
        httpStatusCode = this.invokeServlet(this.ctxtExcludeAuthConstraint, "POST");
        if (httpStatusCode != 403) {
            this.logger.debug("Accessing {} (POST) returns = {}", (Object)this.ctxtExcludeAuthConstraint, (Object)httpStatusCode);
            throw new Exception("testExcludeAuthConstraint : FAILED");
        }
        this.logger.debug("testExcludeAuthConstraint : PASSED");
    }

    @Test
    public void testPartialDDServlet() throws Exception {
        this.logger.debug("Invoking {} (GET)", (Object)this.ctxtPartialDDServlet);
        int httpStatusCode = this.invokeServlet(this.ctxtPartialDDServlet, "GET");
        if (httpStatusCode != 200) {
            this.logger.debug("Accessing {} (GET) returns = {}", (Object)this.ctxtPartialDDServlet, (Object)httpStatusCode);
            throw new Exception("testPartialDDServlet : FAILED");
        }
        this.logger.debug("Invoking {} (POST)", (Object)this.ctxtPartialDDServlet);
        httpStatusCode = this.invokeServlet(this.ctxtPartialDDServlet, "POST");
        if (httpStatusCode != 200) {
            this.logger.debug("Accessing {} (POST) returns = {}", (Object)this.ctxtPartialDDServlet, (Object)httpStatusCode);
            throw new Exception("testPartialDDServlet : FAILED");
        }
        this.logger.debug("Invoking {} (PUT)", (Object)this.ctxtPartialDDServlet);
        httpStatusCode = this.invokeServlet(this.ctxtPartialDDServlet, "PUT");
        if (httpStatusCode != 403) {
            this.logger.debug("Accessing {} (PUT) returns = {}", (Object)this.ctxtPartialDDServlet, (Object)httpStatusCode);
            throw new Exception("testPartialDDServlet : FAILED");
        }
        this.logger.debug("Invoking {} (DELETE)", (Object)this.ctxtPartialDDServlet);
        httpStatusCode = this.invokeServlet(this.ctxtPartialDDServlet, "DELETE");
        if (httpStatusCode != 403) {
            this.logger.debug("Accessing {} (DELETE) returns = {}", (Object)this.ctxtPartialDDServlet, (Object)httpStatusCode);
            throw new Exception("testPartialDDServlet : FAILED");
        }
        this.logger.debug("testPartialDDServlet : PASSED");
    }

    private int invokeServlet(String sContext, String requestMethod) throws Exception {
        int code = 200;
        if (sContext.startsWith("/")) {
            sContext = sContext.substring(1);
        }
        String url = this.getURLString("http", this.hostname, this.portnum, sContext);
        try {
            URL newURL = new URL(url);
            String authData = this.username + ":" + this.password;
            this.logger.debug("authData : {}", (Object)authData);
            String encodedAuthData = WebUtil.encodeBase64((String)authData);
            this.logger.debug("encoded authData : {}", (Object)encodedAuthData);
            HttpURLConnection conn = (HttpURLConnection)newURL.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestProperty("Authorization", "Basic " + encodedAuthData.trim());
            conn.setRequestMethod(requestMethod);
            conn.connect();
            this.logger.debug("called HttpURLConnection.connect() for url: {}", (Object)url);
            code = conn.getResponseCode();
            this.logger.debug("Got response code of: {}", (Object)code);
            String str = conn.getResponseMessage();
            this.logger.debug("Got response string of: {}", (Object)str);
        }
        catch (Exception e) {
            this.logger.error("Abnormal return status encountered while invoking {}", (Object)sContext);
            this.logger.error("Exception Message was:  " + e.getMessage(), (Throwable)e);
            throw e;
        }
        return code;
    }
}

