/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.spec.httpservletresponse;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import servlet.tck.common.servlets.HttpTCKServlet;

public class HttpTestServlet
extends HttpTCKServlet {
    public void intHeaderTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.addIntHeader("header1", 12345);
        response.flushBuffer();
        response.addIntHeader("header2", 56789);
    }

    public void flushBufferTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int size = 40;
        response.setContentLength(size);
        PrintWriter pw = response.getWriter();
        pw.println("Test PASSED");
        StringBuffer tmp = new StringBuffer(2 * size);
        for (int i = 0; i < 8; ++i) {
            tmp = tmp.append("111111111x");
        }
        pw.println(tmp);
        response.addIntHeader("header1", 12345);
    }

    public void sendErrorCommitTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        response.sendError(200, "sendErrorCommitTest");
        response.addIntHeader("header1", 12345);
        pw.println("Test FAILED in sendErrorCommitTest");
    }

    public void sendRedirectClearBufferTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        pw.println("Test FAILED in sendRedirectClearBufferTest");
        response.sendRedirect("/RedirectedTest");
    }

    public void sendRedirectCommitTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        response.sendRedirect("/RedirectedTest");
        response.addIntHeader("header1", 12345);
        pw.println("Test FAILED in sendRedirectCommitTest");
    }
}

