/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.el.jsp;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import ee.jakarta.tck.pages.common.el.Book;
import ee.jakarta.tck.pages.common.tags.tck.SetTag;
import ee.jakarta.tck.pages.common.util.JspTestUtil;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    public URLClientIT() throws Exception {
        this.setGeneralURI("/jsp/spec/el/jsp/");
        this.setContextRoot("/jsp_el_jsp_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_el_jsp_web.war");
        archive.addClasses(new Class[]{JspTestUtil.class, SetTag.class, Book.class});
        archive.addPackages(true, Filters.exclude((Class[])new Class[]{URLClientIT.class}), new String[]{URLClientIT.class.getPackageName()});
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_el_jsp_web.xml"));
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/el_jsp.tld", "el_jsp.tld");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/TemplateTextPoundTranslationError.jsp")), "TemplateTextPoundTranslationError.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/TagLibraryPoundTranslationError.jsp")), "TagLibraryPoundTranslationError.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/positiveELDeferredValueValue.jsp")), "positiveELDeferredValueValue.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/positiveELDeferredMethodValue.jsp")), "positiveELDeferredMethodValue.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/negativeELDeferredValueValue.jsp")), "negativeELDeferredValueValue.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/negativeELDeferredMethodValue.jsp")), "negativeELDeferredMethodValue.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/ImplicitELImport.jsp")), "ImplicitELImport.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/ELDeferredValueCoercion.jsp")), "ELDeferredValueCoercion.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/ELDeferredMethodStringLiteralError2.jsp")), "ELDeferredMethodStringLiteralError2.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/ELDeferredMethodStringLiteralError1.jsp")), "ELDeferredMethodStringLiteralError1.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/ELDeferredMethodStringLiteral.jsp")), "ELDeferredMethodStringLiteral.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/DynamicAttributeSetterMethod.jsp")), "DynamicAttributeSetterMethod.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/AllowedDynamicAttributeValueTypes.jsp")), "AllowedDynamicAttributeValueTypes.jsp");
        return archive;
    }

    @Test
    public void positiveELDeferredValueValueTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_el_jsp_web/positiveELDeferredValueValue.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    public void negativeELDeferredValueValueTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_el_jsp_web/negativeELDeferredValueValue.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void eLDeferredValueCoercionTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_el_jsp_web/ELDeferredValueCoercion.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    public void positiveELDeferredMethodValueTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_el_jsp_web/positiveELDeferredMethodValue.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    public void negativeELDeferredMethodValueTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_el_jsp_web/negativeELDeferredMethodValue.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void eLDeferredMethodStringLiteralTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_el_jsp_web/ELDeferredMethodStringLiteral.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    public void eLDeferredMethodStringLiteralErrorTest1() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_el_jsp_web/ELDeferredMethodStringLiteralError1.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void eLDeferredMethodStringLiteralErrorTest2() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_el_jsp_web/ELDeferredMethodStringLiteralError2.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void templateTextPoundTranslationErrorTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_el_jsp_web/TemplateTextPoundTranslationError.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void tagLibraryPoundTranslationErrorTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_el_jsp_web/TagLibraryPoundTranslationError.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void allowedDynamicAttributeValueTypesTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_el_jsp_web/AllowedDynamicAttributeValueTypes.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    public void dynamicAttributeSetterMethodTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_el_jsp_web/DynamicAttributeSetterMethod.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void implicitImportTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_el_jsp_web/ImplicitELImport.jsp HTTP/1.1");
        this.invoke();
    }
}

