/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.config.manager.documents.DocumentInfo;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.config.processor.SharedUtils;
import com.sun.faces.util.FacesLogger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.application.NavigationHandler;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NavigationConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String NAVIGATION_RULE = "navigation-rule";
    private static final String FROM_VIEW_ID = "from-view-id";
    private static final String NAVIGATION_CASE = "navigation-case";
    private static final String FROM_ACTION = "from-action";
    private static final String FROM_OUTCOME = "from-outcome";
    private static final String IF = "if";
    private static final String TO_VIEW_ID = "to-view-id";
    private static final String TO_FLOW_DOCUMENT_ID = "to-flow-document-id";
    private static final String REDIRECT = "redirect";
    private static final String VIEW_PARAM = "view-param";
    private static final String VIEW_PARAM_NAME = "name";
    private static final String VIEW_PARAM_VALUE = "value";
    private static final String REDIRECT_PARAM = "redirect-param";
    private static final String REDIRECT_PARAM_NAME = "name";
    private static final String REDIRECT_PARAM_VALUE = "value";
    private static final String INCLUDE_VIEW_PARAMS_ATTRIBUTE = "include-view-params";
    private static final String FROM_VIEW_ID_DEFAULT = "*";

    @Override
    public void process(ServletContext sc, FacesContext facesContext, DocumentInfo[] documentInfos) throws Exception {
        NavigationHandler handler = this.getApplication().getNavigationHandler();
        for (DocumentInfo documentInfo : documentInfos) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing navigation-rule elements for document: ''{0}''", documentInfo.getSourceURI()));
            }
            Document document = documentInfo.getDocument();
            String namespace = document.getDocumentElement().getNamespaceURI();
            NodeList navigationRules = document.getDocumentElement().getElementsByTagNameNS(namespace, NAVIGATION_RULE);
            if (navigationRules == null || navigationRules.getLength() <= 0) continue;
            this.addNavigationRules(navigationRules, handler, sc);
        }
    }

    private void addNavigationRules(NodeList navigationRules, NavigationHandler navHandler, ServletContext sc) throws XPathExpressionException {
        int size = navigationRules.getLength();
        for (int i = 0; i < size; ++i) {
            Node navigationRule = navigationRules.item(i);
            if ("flow-definition".equals(navigationRule.getParentNode().getLocalName()) || navigationRule.getNodeType() != 1) continue;
            NodeList children = navigationRule.getChildNodes();
            String fromViewId = FROM_VIEW_ID_DEFAULT;
            ArrayList<Node> navigationCases = null;
            int csize = children.getLength();
            block9: for (int c = 0; c < csize; ++c) {
                Node n = children.item(c);
                if (n.getNodeType() != 1) continue;
                switch (n.getLocalName()) {
                    case "from-view-id": {
                        String t = this.getNodeText(n);
                        String string = fromViewId = t == null ? FROM_VIEW_ID_DEFAULT : t;
                        if (fromViewId.equals(FROM_VIEW_ID_DEFAULT) || fromViewId.charAt(0) == '/') continue block9;
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, "jsf.config.navigation.from_view_id_leading_slash", new String[]{fromViewId});
                        }
                        fromViewId = '/' + fromViewId;
                        continue block9;
                    }
                    case "navigation-case": {
                        if (navigationCases == null) {
                            navigationCases = new ArrayList<Node>(csize);
                        }
                        navigationCases.add(n);
                    }
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing navigation rule with 'from-view-id' of ''{0}''", fromViewId));
            }
            this.addNavigationCasesForRule(fromViewId, navigationCases, navHandler, sc);
        }
    }

    private void addNavigationCasesForRule(String fromViewId, List<Node> navigationCases, NavigationHandler navHandler, ServletContext sc) {
        if (navigationCases != null && !navigationCases.isEmpty()) {
            ApplicationAssociate associate = ApplicationAssociate.getInstance(sc);
            for (Node navigationCase : navigationCases) {
                if (navigationCase.getNodeType() != 1) continue;
                NodeList children = navigationCase.getChildNodes();
                String outcome = null;
                String action = null;
                String condition = null;
                String toViewId = null;
                String toFlowDocumentId = null;
                Map<String, List<String>> parameters = null;
                boolean redirect = false;
                boolean includeViewParams = false;
                int size = children.getLength();
                block17: for (int i = 0; i < size; ++i) {
                    Node n = children.item(i);
                    if (n.getNodeType() != 1) continue;
                    switch (n.getLocalName()) {
                        case "from-outcome": {
                            outcome = this.getNodeText(n);
                            continue block17;
                        }
                        case "from-action": {
                            action = this.getNodeText(n);
                            continue block17;
                        }
                        case "if": {
                            String expression = this.getNodeText(n);
                            if (SharedUtils.isExpression(expression) && !SharedUtils.isMixedExpression(expression)) {
                                condition = expression;
                                continue block17;
                            }
                            if (!LOGGER.isLoggable(Level.WARNING)) continue block17;
                            LOGGER.log(Level.WARNING, "jsf.config.navigation.if_invalid_expression", new String[]{expression, fromViewId});
                            continue block17;
                        }
                        case "to-view-id": {
                            String toViewIdString = this.getNodeText(n);
                            if (toViewIdString.charAt(0) != '/' && toViewIdString.charAt(0) != '#') {
                                if (LOGGER.isLoggable(Level.WARNING)) {
                                    LOGGER.log(Level.WARNING, "jsf.config.navigation.to_view_id_leading_slash", new String[]{toViewIdString, fromViewId});
                                }
                                toViewId = '/' + toViewIdString;
                                continue block17;
                            }
                            toViewId = toViewIdString;
                            continue block17;
                        }
                        case "to-flow-document-id": {
                            toFlowDocumentId = this.getNodeText(n);
                            continue block17;
                        }
                        case "redirect": {
                            parameters = this.processParameters(n.getChildNodes());
                            includeViewParams = this.isIncludeViewParams(n);
                            redirect = true;
                        }
                    }
                }
                NavigationCase cnc = new NavigationCase(fromViewId, action, outcome, condition, toViewId, toFlowDocumentId, parameters, redirect, includeViewParams);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Adding NavigationCase: {0}", cnc.toString()));
                }
                if (navHandler instanceof ConfigurableNavigationHandler) {
                    ConfigurableNavigationHandler cnav = (ConfigurableNavigationHandler)navHandler;
                    Set<NavigationCase> cases = cnav.getNavigationCases().get(fromViewId);
                    if (cases == null) {
                        cases = new LinkedHashSet<NavigationCase>();
                        cnav.getNavigationCases().put(fromViewId, cases);
                    }
                    cases.add(cnc);
                }
                associate.addNavigationCase(cnc);
            }
        }
    }

    private Map<String, List<String>> processParameters(NodeList children) {
        LinkedHashMap<String, ArrayList<String>> parameters = null;
        if (children.getLength() > 0) {
            parameters = new LinkedHashMap<String, ArrayList<String>>(4, 1.0f);
            int size = children.getLength();
            for (int i = 0; i < size; ++i) {
                Node pn;
                int j;
                int jsize;
                NodeList params;
                String value;
                String name;
                Node n = children.item(i);
                if (n.getNodeType() != 1) continue;
                if (VIEW_PARAM.equals(n.getLocalName())) {
                    name = null;
                    value = null;
                    params = n.getChildNodes();
                    jsize = params.getLength();
                    for (j = 0; j < jsize; ++j) {
                        pn = params.item(j);
                        if (pn.getNodeType() != 1) continue;
                        if ("name".equals(pn.getLocalName())) {
                            name = this.getNodeText(pn);
                        }
                        if (!"value".equals(pn.getLocalName())) continue;
                        value = this.getNodeText(pn);
                    }
                    if (name != null) {
                        ArrayList<String> values = (ArrayList<String>)parameters.get(name);
                        if (values == null && value != null) {
                            values = new ArrayList<String>(2);
                            parameters.put(name, values);
                        }
                        if (values != null) {
                            values.add(value);
                        }
                    }
                }
                if (!REDIRECT_PARAM.equals(n.getLocalName())) continue;
                name = null;
                value = null;
                params = n.getChildNodes();
                jsize = params.getLength();
                for (j = 0; j < jsize; ++j) {
                    pn = params.item(j);
                    if (pn.getNodeType() != 1) continue;
                    if ("name".equals(pn.getLocalName())) {
                        name = this.getNodeText(pn);
                    }
                    if (!"value".equals(pn.getLocalName())) continue;
                    value = this.getNodeText(pn);
                }
                if (name == null) continue;
                ArrayList<String> values = (ArrayList<String>)parameters.get(name);
                if (values == null && value != null) {
                    values = new ArrayList<String>(2);
                    parameters.put(name, values);
                }
                if (values == null) continue;
                values.add(value);
            }
        }
        return parameters;
    }

    private boolean isIncludeViewParams(Node n) {
        return Boolean.valueOf(this.getNodeText(n.getAttributes().getNamedItem(INCLUDE_VIEW_PARAMS_ATTRIBUTE)));
    }
}

