/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.util.Set;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.provider.ParameterMetaData;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.results.OptionsResult;

@Provider
@Produces(value={"application/xml"})
public class OptionsResultXmlProvider
extends BaseProvider<OptionsResult> {
    private static final String QUERY_PARAMETERS = "queryParameters";
    private static final String MESSAGE_PARAMETERS = "messageParameters";
    private static final String METHOD = "method";

    public OptionsResultXmlProvider() {
        super(OptionsResult.class, MediaType.APPLICATION_XML_TYPE);
    }

    @Override
    public String getContent(OptionsResult proxy) {
        String indent = "  ";
        String result = "<" + proxy.getName() + ">";
        result = result + this.getRespresenationForMethodMetaData(proxy, indent);
        result = result + "\n" + ProviderUtil.getEndXmlElement(proxy.getName());
        return result;
    }

    String getRespresenationForMethodMetaData(OptionsResult proxy, String indent) {
        String result = "";
        Set<String> methods = proxy.methods();
        for (String method : methods) {
            result = result + this.getMethod(method, indent);
            MethodMetaData methodMetaData = proxy.getMethodMetaData(method);
            result = result + this.getMessageParams(methodMetaData, indent + "  ");
            result = result + "\n" + indent;
            result = result + ProviderUtil.getEndXmlElement(METHOD);
        }
        return result;
    }

    private String getMethod(String method, String indent) {
        String result = "\n" + indent + "<";
        result = result + METHOD + " name=";
        result = result + ProviderUtil.quote(method);
        result = result + ">";
        return result;
    }

    private String getMessageParams(MethodMetaData methodMetaData, String indent) {
        String result = "";
        if (methodMetaData.sizeParameterMetaData() > 0) {
            result = result + "\n" + indent;
            result = result + "<" + MESSAGE_PARAMETERS + ">";
            Set<String> parameters = methodMetaData.parameters();
            for (String parameter : parameters) {
                ParameterMetaData parameterMetaData = methodMetaData.getParameterMetaData(parameter);
                result = result + this.getParameter(parameter, parameterMetaData, indent + "  ");
            }
            result = result + "\n" + indent;
            result = result + ProviderUtil.getEndXmlElement(MESSAGE_PARAMETERS);
        }
        return result;
    }

    private String getParameter(String parameter, ParameterMetaData parameterMetaData, String indent) {
        StringBuilder result = new StringBuilder("\n" + indent);
        result.append("<").append(parameter);
        Set<String> attributes = parameterMetaData.attributes();
        for (String attributeName : attributes) {
            String attributeValue = parameterMetaData.getAttributeValue(attributeName);
            result.append(this.getAttribute(attributeName, attributeValue));
        }
        result.append("/>");
        return result.toString();
    }

    private String getAttribute(String name, String value) {
        String result = " ";
        name = name.replace(' ', '-');
        result = result + name + "=" + ProviderUtil.quote(value);
        return result;
    }
}

