/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.ant;

import com.sun.tools.ws.ant.WsTask2;
import com.sun.tools.ws.wscompile.Options;
import com.sun.tools.ws.wscompile.WsimportTool;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.XMLCatalog;
import org.xml.sax.EntityResolver;

public class WsImportBase
extends WsTask2 {
    private final Commandline extraArgs = new Commandline();
    private final Commandline xjcCmdLine = new Commandline();
    private boolean xdebug = false;
    private boolean xuseBaseResourceAndURLToLoadWSDL = false;
    private boolean isGenerateJWS = false;
    private File implDestDir = null;
    private String implServiceName = null;
    private String implPortName = null;
    private boolean xadditionalHeaders = false;
    private String clientjar = null;
    private String wsdlLocation;
    private XMLCatalog xmlCatalog;
    private String pkg;
    private String module;
    protected boolean xNoAddressingDatabinding;
    private boolean quiet = false;
    private String specTarget;
    private final ArrayList<File> dependsSet = new ArrayList();
    private final ArrayList<File> producesSet = new ArrayList();
    private boolean producesSpecified = false;
    private File catalog;
    private String wsdl;
    private File xauthfile;
    private boolean disableAuthenticator;
    private final Set<File> bindingFiles = new HashSet<File>();

    public boolean isXdebug() {
        return this.xdebug;
    }

    public void setXdebug(boolean xdebug) {
        this.xdebug = xdebug;
    }

    public void setXUseBaseResourceAndURLToLoadWSDL(boolean xuseBaseResourceAndURLToLoadWSDL) {
        this.xuseBaseResourceAndURLToLoadWSDL = xuseBaseResourceAndURLToLoadWSDL;
    }

    public boolean isXUseBaseResourceAndURLToLoadWSDL() {
        return this.xuseBaseResourceAndURLToLoadWSDL;
    }

    public boolean isGenerateJWS() {
        return this.isGenerateJWS;
    }

    public void setGenerateJWS(boolean isGenerateJWS) {
        this.isGenerateJWS = isGenerateJWS;
    }

    public File getImplDestDir() {
        return this.implDestDir;
    }

    public void setImplDestDir(File base) {
        this.implDestDir = base;
    }

    public String getImplServiceName() {
        return this.implServiceName;
    }

    public void setImplServiceName(String base) {
        this.implServiceName = base;
    }

    public String getImplPortName() {
        return this.implPortName;
    }

    public void setImplPortName(String base) {
        this.implPortName = base;
    }

    public Commandline.Argument createArg() {
        return this.extraArgs.createArgument();
    }

    public boolean isXadditionalHeaders() {
        return this.xadditionalHeaders;
    }

    public void setXadditionalHeaders(boolean xadditionalHeaders) {
        this.xadditionalHeaders = xadditionalHeaders;
    }

    public String getClientjar() {
        return this.clientjar;
    }

    public void setClientjar(String clientjar) {
        this.clientjar = clientjar;
    }

    public String getWsdllocation() {
        return this.wsdlLocation;
    }

    public void setWsdllocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public void addConfiguredXMLCatalog(XMLCatalog entityResolver) {
        if (this.xmlCatalog == null) {
            this.xmlCatalog = new XMLCatalog();
            this.xmlCatalog.setProject(this.getProject());
        }
        this.xmlCatalog.addConfiguredXMLCatalog(entityResolver);
    }

    public void setPackage(String pkg) {
        this.pkg = pkg;
    }

    public String getPackage() {
        return this.pkg;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getModule() {
        return this.module;
    }

    public Commandline.Argument createXjcarg() {
        return this.xjcCmdLine.createArgument();
    }

    public boolean getxNoAddressingDatabinding() {
        return this.xNoAddressingDatabinding;
    }

    public void setxNoAddressingDatabinding(boolean xNoAddressingDatabinding) {
        this.xNoAddressingDatabinding = xNoAddressingDatabinding;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void setTarget(String version) {
        Options.Target targetVersion = Options.Target.parse(version);
        if (targetVersion == null) {
            throw new BuildException(version + " is not a valid version number");
        }
        this.specTarget = targetVersion.getVersion();
    }

    public void addConfiguredDepends(FileSet fs) {
        this.addIndividualFilesTo(fs, this.dependsSet);
    }

    public void addConfiguredProduces(FileSet fs) {
        this.producesSpecified = true;
        if (!fs.getDir(this.getProject()).exists()) {
            this.log(fs.getDir(this.getProject()).getAbsolutePath() + " is not found and thus excluded from the dependency check", 2);
        } else {
            this.addIndividualFilesTo(fs, this.producesSet);
        }
    }

    private void addIndividualFilesTo(FileSet fs, List<File> lst) {
        DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
        String[] includedFiles = ds.getIncludedFiles();
        File baseDir = ds.getBasedir();
        for (String value : includedFiles) {
            lst.add(new File(baseDir, value));
        }
    }

    private long computeTimestampFor(List<File> files, boolean findNewest) {
        long lastModified = findNewest ? Long.MIN_VALUE : Long.MAX_VALUE;
        for (File file : files) {
            this.log("Checking timestamp of " + file.toString(), 3);
            if (findNewest) {
                lastModified = Math.max(lastModified, file.lastModified());
                continue;
            }
            lastModified = Math.min(lastModified, file.lastModified());
        }
        if (lastModified == Long.MIN_VALUE) {
            return Long.MAX_VALUE;
        }
        if (lastModified == Long.MAX_VALUE) {
            return Long.MIN_VALUE;
        }
        return lastModified;
    }

    public void setBinding(String binding) {
        File f = new File(binding);
        this.bindingFiles.add(f);
        this.dependsSet.add(f);
    }

    public void setCatalog(File catalog) {
        this.catalog = catalog;
    }

    public File getCatalog() {
        return this.catalog;
    }

    public String getWsdl() {
        return this.wsdl;
    }

    public void setWsdl(String wsdl) {
        this.wsdl = wsdl;
        this.dependsSet.add(new File(wsdl));
    }

    public File getXauthfile() {
        return this.xauthfile;
    }

    public void setXauthfile(File xauthfile) {
        this.xauthfile = xauthfile;
    }

    public boolean getXdisableAuthenticator() {
        return this.disableAuthenticator;
    }

    public void setdisableAuthenticator(boolean disableAuthenticator) {
        this.disableAuthenticator = disableAuthenticator;
    }

    public void addConfiguredBinding(FileSet fs) {
        DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
        String[] includedFiles = ds.getIncludedFiles();
        File baseDir = ds.getBasedir();
        for (String includedFile : includedFiles) {
            this.bindingFiles.add(new File(baseDir, includedFile));
        }
        this.addIndividualFilesTo(fs, this.dependsSet);
    }

    @Override
    protected CommandlineJava setupCommand() {
        CommandlineJava cmd = super.setupCommand();
        if (this.getxNoAddressingDatabinding()) {
            cmd.createArgument().setValue("-Xno-addressing-databinding");
        }
        if (this.isXdebug()) {
            cmd.createArgument().setValue("-Xdebug");
        }
        if (this.isXnocompile()) {
            cmd.createArgument().setValue("-Xnocompile");
        } else {
            for (String string2 : this.getJavacargs().getArguments()) {
                cmd.createArgument().setValue("-J" + string2);
            }
        }
        if (this.isXadditionalHeaders()) {
            cmd.createArgument().setValue("-XadditionalHeaders");
        }
        if (this.isXUseBaseResourceAndURLToLoadWSDL()) {
            cmd.createArgument().setValue("-XuseBaseResourceAndURLToLoadWSDL");
        }
        if (this.getCatalog() != null && this.getCatalog().getName().length() > 0) {
            cmd.createArgument().setValue("-catalog");
            cmd.createArgument().setFile(this.getCatalog());
        }
        if (this.quiet) {
            cmd.createArgument().setValue("-quiet");
        }
        if (this.specTarget != null) {
            cmd.createArgument().setValue("-target");
            cmd.createArgument().setValue(this.specTarget);
        }
        if (this.getWsdl() != null) {
            cmd.createArgument().setValue(this.getWsdl());
        }
        if (this.getXauthfile() != null) {
            cmd.createArgument().setValue("-Xauthfile");
            cmd.createArgument().setFile(this.getXauthfile());
        }
        if (this.getXdisableAuthenticator()) {
            cmd.createArgument().setValue("-XdisableAuthenticator");
        }
        if (this.getPackage() != null && this.getPackage().length() > 0) {
            cmd.createArgument().setValue("-p");
            cmd.createArgument().setValue(this.getPackage());
        }
        if (this.module != null && !this.module.isEmpty()) {
            cmd.createArgument().setValue("-m");
            cmd.createArgument().setValue(this.module);
        }
        if (this.getClientjar() != null) {
            cmd.createArgument().setValue("-clientjar");
            cmd.createArgument().setValue(this.getClientjar());
        }
        for (String string3 : this.xjcCmdLine.getArguments()) {
            if (string3.startsWith("-")) {
                cmd.createArgument().setValue("-B" + string3);
                continue;
            }
            cmd.createArgument().setValue(string3);
        }
        if (!this.bindingFiles.isEmpty()) {
            for (File binding : this.bindingFiles) {
                cmd.createArgument().setValue("-b");
                boolean isLink = false;
                try {
                    isLink = !binding.getCanonicalPath().equals(binding.getAbsolutePath()) && (!binding.getAbsolutePath().contains("~1") || binding.getCanonicalPath().indexOf(32) < 0);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (isLink) {
                    cmd.createArgument().setValue(binding.toURI().toString());
                    continue;
                }
                cmd.createArgument().setFile(binding);
            }
        }
        if (this.wsdlLocation != null && this.wsdlLocation.length() != 0) {
            cmd.createArgument().setValue("-wsdllocation");
            cmd.createArgument().setValue(this.wsdlLocation);
        }
        if (this.isGenerateJWS()) {
            cmd.createArgument().setValue("-generateJWS");
            if (this.getImplDestDir() != null) {
                cmd.createArgument().setValue("-implDestDir");
                cmd.createArgument().setFile(this.getImplDestDir());
            }
            if (this.getImplServiceName() != null) {
                cmd.createArgument().setValue("-implServiceName");
                cmd.createArgument().setValue(this.getImplServiceName());
            }
            if (this.getImplPortName() != null) {
                cmd.createArgument().setValue("-implPortName");
                cmd.createArgument().setValue(this.getImplPortName());
            }
        }
        for (String string4 : this.extraArgs.getArguments()) {
            cmd.createArgument().setValue(string4);
        }
        return cmd;
    }

    public void execute() throws BuildException {
        if (!this.producesSpecified) {
            this.log("Consider using <depends>/<produces> so that wsimport won't do unnecessary compilation", 2);
        }
        long srcTime = this.computeTimestampFor(this.dependsSet, true);
        long dstTime = this.computeTimestampFor(this.producesSet, false);
        this.log("the last modified time of the inputs is  " + srcTime, 3);
        this.log("the last modified time of the outputs is " + dstTime, 3);
        if (srcTime < dstTime) {
            this.log("files are up to date");
            return;
        }
        this.execute("wsimport", "com.sun.tools.ws.WsImport");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean runInVm(String[] arguments, OutputStream out) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String sysPath = System.getProperty("java.class.path");
        if (loader instanceof AntClassLoader) {
            System.setProperty("java.class.path", ((AntClassLoader)loader).getClasspath());
        }
        WsimportTool compTool = new WsimportTool(out);
        if (this.xmlCatalog != null) {
            compTool.setEntityResolver((EntityResolver)this.xmlCatalog);
        }
        try {
            boolean bl = compTool.run(arguments);
            return bl;
        }
        finally {
            if (sysPath != null) {
                System.setProperty("java.class.path", sysPath);
            }
        }
    }
}

