/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.Module;
import com.sun.xml.ws.api.server.ResourceInjector;
import com.sun.xml.ws.api.server.ServerPipelineHook;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import java.lang.annotation.Annotation;
import javax.servlet.ServletContext;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.webservices.JAXWSServletModule;
import org.glassfish.webservices.ResourceInjectorImpl;
import org.glassfish.webservices.ServerPipeCreator;

public class JAXWSContainer
extends Container {
    private final ServletContext servletContext;
    private final WebServiceEndpoint endpoint;
    private final JAXWSServletModule module;

    public JAXWSContainer(ServletContext servletContext, WebServiceEndpoint ep) {
        this.servletContext = servletContext;
        this.endpoint = ep;
        this.module = servletContext != null ? JAXWSServletModule.getServletModule(servletContext.getContextPath()) : null;
    }

    public void addEndpoint(ServletAdapter adapter) {
        if (this.module != null) {
            this.module.addEndpoint(this.endpoint.getEndpointAddressUri(), adapter);
        }
    }

    public <T> T getSPI(Class<T> spiType) {
        if (ServletContext.class.isAssignableFrom(spiType)) {
            return (T)this.servletContext;
        }
        if (ServerPipelineHook.class.isAssignableFrom(spiType)) {
            ServiceLocator h = Globals.getDefaultHabitat();
            ServerPipeCreator s = (ServerPipeCreator)((Object)h.getService(ServerPipeCreator.class, new Annotation[0]));
            s.init(this.endpoint);
            return (T)((Object)s);
        }
        if (ResourceInjector.class.isAssignableFrom(spiType) && this.endpoint.implementedByWebComponent()) {
            return (T)((Object)new ResourceInjectorImpl(this.endpoint));
        }
        if (Module.class.isAssignableFrom(spiType) && this.module != null) {
            return spiType.cast((Object)this.module);
        }
        return null;
    }
}

