/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import org.jboss.classfilewriter.ClassFile;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.DuplicateMemberException;
import org.jboss.classfilewriter.code.CodeAttribute;
import org.jboss.classfilewriter.util.Boxing;
import org.jboss.classfilewriter.util.DescriptorUtils;
import org.jboss.weld.annotated.enhanced.MethodSignature;
import org.jboss.weld.annotated.enhanced.jlr.MethodSignatureImpl;
import org.jboss.weld.bean.proxy.CommonProxiedMethodFilters;
import org.jboss.weld.bean.proxy.InterceptedSubclassFactory;
import org.jboss.weld.bean.proxy.InterceptionDecorationContext;
import org.jboss.weld.bean.proxy.MethodHandler;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.bean.proxy.StackAwareMethodHandler;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.security.GetDeclaredMethodsAction;
import org.jboss.weld.util.bytecode.BytecodeUtils;
import org.jboss.weld.util.bytecode.RuntimeMethodInformation;

public class InterceptedProxyFactory<T>
extends ProxyFactory<T> {
    public static final String PROXY_SUFFIX = "InterceptedProxy";
    private static final String INVOKE = "invoke";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private final Set<MethodSignature> enhancedMethodSignatures;
    private final Set<MethodSignature> interceptedMethodSignatures;
    private final String suffix;

    public InterceptedProxyFactory(String contextId, Class<?> proxiedBeanType, Set<? extends Type> typeClosure, Set<MethodSignature> enhancedMethodSignatures, Set<MethodSignature> interceptedMethodSignatures, String suffix) {
        super(contextId, proxiedBeanType, typeClosure, null);
        this.enhancedMethodSignatures = enhancedMethodSignatures;
        this.interceptedMethodSignatures = interceptedMethodSignatures;
        this.suffix = suffix;
    }

    @Override
    protected String getProxyNameSuffix() {
        return PROXY_SUFFIX + this.suffix;
    }

    @Override
    protected void addMethodsFromClass(ClassFile proxyClassType, ClassMethod staticConstructor) {
        try {
            HashSet<MethodSignatureImpl> finalMethods = new HashSet<MethodSignatureImpl>();
            HashSet processedBridgeMethods = new HashSet();
            for (Class<?> cls = this.getBeanType(); cls != null; cls = cls.getSuperclass()) {
                HashSet<MethodSignatureImpl> declaredBridgeMethods = new HashSet<MethodSignatureImpl>();
                for (Method method : AccessController.doPrivileged(new GetDeclaredMethodsAction(cls))) {
                    MethodSignatureImpl methodSignature = new MethodSignatureImpl(method);
                    if (this.isMethodAccepted(method, this.getProxySuperclass()) && this.enhancedMethodSignatures.contains(methodSignature) && !finalMethods.contains(methodSignature) && !processedBridgeMethods.contains(methodSignature)) {
                        try {
                            String typeString;
                            int i;
                            int localVariableCount;
                            CodeAttribute b;
                            RuntimeMethodInformation methodInfo = new RuntimeMethodInformation(method);
                            ClassMethod classMethod = proxyClassType.addMethod(method);
                            if (this.interceptedMethodSignatures.contains(methodSignature)) {
                                b = classMethod.getCodeAttribute();
                                b.aload(0);
                                this.getMethodHandlerField(classMethod.getClassFile(), b);
                                b.invokestatic(InterceptionDecorationContext.class.getName(), "getStack", "()" + DescriptorUtils.makeDescriptor(InterceptionDecorationContext.Stack.class));
                                b.aload(0);
                                DEFAULT_METHOD_RESOLVER.getDeclaredMethod(classMethod, methodInfo.getDeclaringClass(), method.getName(), methodInfo.getParameterTypes(), staticConstructor);
                                b.dup();
                                b.iconst(method.getParameterTypes().length);
                                b.anewarray(JAVA_LANG_OBJECT);
                                localVariableCount = 1;
                                for (i = 0; i < method.getParameterTypes().length; ++i) {
                                    typeString = methodInfo.getParameterTypes()[i];
                                    b.dup();
                                    b.iconst(i);
                                    BytecodeUtils.addLoadInstruction(b, typeString, localVariableCount);
                                    Boxing.boxIfNessesary((CodeAttribute)b, (String)typeString);
                                    b.aastore();
                                    if (DescriptorUtils.isWide((String)typeString)) {
                                        localVariableCount += 2;
                                        continue;
                                    }
                                    ++localVariableCount;
                                }
                                b.invokeinterface(StackAwareMethodHandler.class.getName(), INVOKE, "Ljava/lang/Object;", InterceptedSubclassFactory.INVOKE_METHOD_PARAMETERS);
                                if (methodInfo.getReturnType().equals("V")) {
                                    b.returnInstruction();
                                } else if (DescriptorUtils.isPrimitive((String)methodInfo.getReturnType())) {
                                    Boxing.unbox((CodeAttribute)b, (String)classMethod.getReturnType());
                                    b.returnInstruction();
                                } else {
                                    b.checkcast(BytecodeUtils.getName(methodInfo.getReturnType()));
                                    b.returnInstruction();
                                }
                                BeanLogger.LOG.addingMethodToProxy(method);
                                continue;
                            }
                            b = classMethod.getCodeAttribute();
                            b.aload(0);
                            this.getMethodHandlerField(classMethod.getClassFile(), b);
                            b.aload(0);
                            DEFAULT_METHOD_RESOLVER.getDeclaredMethod(classMethod, methodInfo.getDeclaringClass(), method.getName(), methodInfo.getParameterTypes(), staticConstructor);
                            b.aconstNull();
                            b.iconst(method.getParameterTypes().length);
                            b.anewarray(JAVA_LANG_OBJECT);
                            localVariableCount = 1;
                            for (i = 0; i < method.getParameterTypes().length; ++i) {
                                typeString = methodInfo.getParameterTypes()[i];
                                b.dup();
                                b.iconst(i);
                                BytecodeUtils.addLoadInstruction(b, typeString, localVariableCount);
                                Boxing.boxIfNessesary((CodeAttribute)b, (String)typeString);
                                b.aastore();
                                if (DescriptorUtils.isWide((String)typeString)) {
                                    localVariableCount += 2;
                                    continue;
                                }
                                ++localVariableCount;
                            }
                            b.invokeinterface(MethodHandler.class.getName(), INVOKE, "Ljava/lang/Object;", new String[]{"Ljava/lang/Object;", "Ljava/lang/reflect/Method;", "Ljava/lang/reflect/Method;", "[Ljava/lang/Object;"});
                            if (methodInfo.getReturnType().equals("V")) {
                                b.returnInstruction();
                                continue;
                            }
                            if (DescriptorUtils.isPrimitive((String)methodInfo.getReturnType())) {
                                Boxing.unbox((CodeAttribute)b, (String)classMethod.getReturnType());
                                b.returnInstruction();
                                continue;
                            }
                            b.checkcast(BytecodeUtils.getName(methodInfo.getReturnType()));
                            b.returnInstruction();
                        }
                        catch (DuplicateMemberException duplicateMemberException) {}
                        continue;
                    }
                    if (Modifier.isFinal(method.getModifiers())) {
                        finalMethods.add(methodSignature);
                    }
                    if (!method.isBridge()) continue;
                    declaredBridgeMethods.add(methodSignature);
                }
                processedBridgeMethods.addAll(declaredBridgeMethods);
            }
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    @Override
    protected boolean isMethodAccepted(Method method, Class<?> proxySuperclass) {
        return super.isMethodAccepted(method, proxySuperclass) && CommonProxiedMethodFilters.NON_PRIVATE.accept(method, proxySuperclass) && !method.isBridge();
    }
}

