/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.resolver;

import com.sun.xml.wss.WSITXMLFactory;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.dsig.NamespaceContextImpl;
import com.sun.xml.wss.impl.misc.URI;
import com.sun.xml.wss.logging.LogStringsMessages;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResolverId
extends ResourceResolverSpi {
    private static String implementationClassName = ResolverId.class.getName();
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public static String getResolverName() {
        return implementationClassName;
    }

    @Override
    public XMLSignatureInput engineResolve(Attr uri, String BaseURI) throws ResourceResolverException {
        String uriNodeValue = uri.getNodeValue();
        Document doc = uri.getOwnerDocument();
        XMLUtils.circumventBug2650(doc);
        Element selectedElem = null;
        if (uriNodeValue.equals("")) {
            selectedElem = doc.getDocumentElement();
        } else {
            String id = uriNodeValue.substring(1);
            try {
                selectedElem = this.getElementById(doc, id);
            }
            catch (TransformerException e) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0603_XPATHAPI_TRANSFORMER_EXCEPTION(e.getMessage()), e.getMessage());
                throw new ResourceResolverException("empty", e, uri, BaseURI);
            }
        }
        if (selectedElem == null) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0604_CANNOT_FIND_ELEMENT());
            throw new ResourceResolverException("empty", uri, BaseURI);
        }
        Set resultSet = this.dereferenceSameDocumentURI(selectedElem);
        XMLSignatureInput result = new XMLSignatureInput(resultSet);
        result.setMIMEType("text/xml");
        try {
            URI uriNew = new URI(new URI(BaseURI), uri.getNodeValue());
            result.setSourceURI(uriNew.toString());
        }
        catch (URI.MalformedURIException ex) {
            result.setSourceURI(BaseURI);
        }
        return result;
    }

    @Override
    public boolean engineCanResolve(Attr uri, String BaseURI) {
        if (uri == null) {
            return false;
        }
        String uriNodeValue = uri.getNodeValue();
        return uriNodeValue.startsWith("#");
    }

    public NamespaceContext getNamespaceContext(Document doc) {
        NamespaceContextImpl nsContext = new NamespaceContextImpl();
        nsContext.add(doc.getDocumentElement().getPrefix(), doc.getDocumentElement().getNamespaceURI());
        if (doc.getDocumentElement().getNamespaceURI() == "http://www.w3.org/2003/05/soap-envelope") {
            nsContext.add("SOAP-ENV", "http://www.w3.org/2003/05/soap-envelope");
            nsContext.add("env", "http://www.w3.org/2003/05/soap-envelope");
        }
        nsContext.add("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        nsContext.add("wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        return nsContext;
    }

    private Element getElementById(Document doc, String id) throws TransformerException {
        NodeList assertions;
        int len;
        XPathExpression xpathExpr;
        Element selement = doc.getElementById(id);
        if (selement != null) {
            return selement;
        }
        Element element = null;
        NodeList elems = null;
        String xpath = "//*[@wsu:Id='" + id + "']";
        XPathFactory xpathFactory = WSITXMLFactory.createXPathFactory(WSITXMLFactory.DISABLE_SECURE_PROCESSING);
        XPath xPATH = xpathFactory.newXPath();
        xPATH.setNamespaceContext(this.getNamespaceContext(doc));
        try {
            xpathExpr = xPATH.compile(xpath);
            elems = (NodeList)xpathExpr.evaluate(doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0375_ERROR_APACHE_XPATH_API(id, ex.getMessage()), new Object[]{id, ex.getMessage()});
            throw new XWSSecurityRuntimeException(ex);
        }
        if (elems != null) {
            if (elems.getLength() > 1) {
                throw new XWSSecurityRuntimeException("XPath Query resulted in more than one node");
            }
            element = (Element)elems.item(0);
        }
        if (element == null) {
            xpath = "//*[@Id='" + id + "']";
            try {
                xpathExpr = xPATH.compile(xpath);
                elems = (NodeList)xpathExpr.evaluate(doc, XPathConstants.NODESET);
            }
            catch (XPathExpressionException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0375_ERROR_APACHE_XPATH_API(id, ex.getMessage()), new Object[]{id, ex.getMessage()});
                throw new XWSSecurityRuntimeException(ex);
            }
        }
        if (elems != null) {
            if (elems.getLength() > 1) {
                for (int i = 0; i < elems.getLength(); ++i) {
                    Element elem = (Element)elems.item(i);
                    String namespace = elem.getNamespaceURI();
                    if (!namespace.equals("http://www.w3.org/2000/09/xmldsig#") && !namespace.equals("http://www.w3.org/2001/04/xmlenc#")) continue;
                    element = elem;
                    break;
                }
            } else {
                element = (Element)elems.item(0);
            }
        }
        if (element == null && (len = (assertions = doc.getElementsByTagName("Assertion")).getLength()) > 0) {
            for (int i = 0; i < len; ++i) {
                Element elem = (Element)assertions.item(i);
                String assertionId = elem.getAttribute("AssertionID");
                if (!id.equals(assertionId)) continue;
                element = elem;
                break;
            }
        }
        return element;
    }

    private Set dereferenceSameDocumentURI(Node node) {
        HashSet nodeSet = new HashSet();
        if (node != null) {
            this.nodeSetMinusCommentNodes(node, nodeSet, null);
        }
        return nodeSet;
    }

    private void nodeSetMinusCommentNodes(Node node, Set nodeSet, Node prevSibling) {
        switch (node.getNodeType()) {
            case 1: {
                NamedNodeMap attrs = node.getAttributes();
                if (attrs != null) {
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        nodeSet.add(attrs.item(i));
                    }
                }
                nodeSet.add(node);
                Node pSibling = null;
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.nodeSetMinusCommentNodes(child, nodeSet, pSibling);
                    pSibling = child;
                }
                break;
            }
            case 3: 
            case 4: {
                if (prevSibling != null && (prevSibling.getNodeType() == 3 || prevSibling.getNodeType() == 4)) {
                    return;
                }
            }
            case 7: {
                nodeSet.add(node);
            }
        }
    }
}

