/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.mapping.ejb;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.jdbcimpl.ConnectionProvider;
import org.netbeans.modules.dbschema.jdbcimpl.SchemaElementImpl;

public class CaptureSchema {
    private static final String OUTPUTFILE_EXTENSION = ".dbschema";
    private static final String PASSWORD_MASK_STRING = "Protected value, not to be logged";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int help = 0;
        ResourceBundle bundle = ResourceBundle.getBundle("com.sun.jdo.api.persistence.mapping.ejb.Bundle");
        String driver = bundle.getString("STRING_ORACLE_DRIVER_NOI18N");
        String username = bundle.getString("STRING_IASCTS_NOI18N");
        String password = bundle.getString("STRING_IASCTS_NOI18N");
        String dburl = null;
        String dbschemaname = null;
        String outfile = null;
        LinkedList<String> tableList = new LinkedList<String>();
        LinkedList vList = new LinkedList();
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals(bundle.getString("CMD_FLAG_DRIVER"))) {
                    driver = args[++i];
                    ++help;
                    continue;
                }
                if (args[i].equals(bundle.getString("CMD_FLAG_SCHEMA_NAME"))) {
                    dbschemaname = args[++i];
                    ++help;
                    continue;
                }
                if (args[i].equals(bundle.getString("CMD_FLAG_USERNAME"))) {
                    username = args[++i];
                    ++help;
                    continue;
                }
                if (args[i].equals(bundle.getString("CMD_FLAG_PASSWORD"))) {
                    password = args[++i];
                    ++help;
                    continue;
                }
                if (args[i].equals(bundle.getString("CMD_FLAG_DBURL"))) {
                    dburl = args[++i];
                    ++help;
                    continue;
                }
                if (args[i].equals(bundle.getString("CMD_FLAG_TABLE"))) {
                    tableList.add(args[++i]);
                    ++help;
                    continue;
                }
                if (!args[i].equals(bundle.getString("CMD_FLAG_OUTPUT"))) continue;
                outfile = args[++i];
                ++help;
            }
        }
        catch (Exception e) {
            help = 0;
        }
        if (help < 1 || null == outfile) {
            System.err.println(bundle.getString("HELP_USAGE"));
            System.exit(1);
        }
        if (!outfile.endsWith(OUTPUTFILE_EXTENSION)) {
            System.err.println(bundle.getString("MESSAGE_CHANGING_OUTFILENAME") + OUTPUTFILE_EXTENSION);
            outfile = outfile + OUTPUTFILE_EXTENSION;
        }
        ConnectionProvider cp = null;
        boolean err_flag = false;
        try {
            System.err.println(bundle.getString("MESSAGE_USING_URL") + dburl);
            System.err.println(bundle.getString("MESSAGE_USING_USERNAME") + username);
            System.err.println(bundle.getString("MESSAGE_USING_PASSWORD") + PASSWORD_MASK_STRING);
            System.err.println(bundle.getString("MESSAGE_USING_DRIVER") + driver);
            System.err.println(bundle.getString("MESSAGE_USING_SCHEMANAME") + dbschemaname);
            System.err.println(bundle.getString("MESSAGE_USING_OUTFILENAME") + outfile);
            cp = new ConnectionProvider(driver, dburl, username, password);
            if (null != dbschemaname) {
                cp.setSchema(dbschemaname);
            }
            System.out.println(bundle.getString("MESSAGE_CAPTURING_SCHEMA") + dbschemaname);
            SchemaElementImpl outSchemaImpl = new SchemaElementImpl(cp);
            SchemaElement se = new SchemaElement((SchemaElement.Impl)outSchemaImpl);
            if (null != dbschemaname) {
                se.setName(DBIdentifier.create((String)(bundle.getString("STRING_SCHEMAS_SLASH_NOI18N") + dbschemaname)));
            } else {
                se.setName(DBIdentifier.create((String)""));
            }
            if (dburl.indexOf(bundle.getString("STRING_ORACLE_JDBC_URL_PREFIX_NOI18N")) > -1 && (null == dbschemaname || dbschemaname.length() == 0)) {
                System.err.println(bundle.getString("ERR_ORACLE_ARGUMENTS"));
                err_flag = true;
                return;
            }
            if (tableList.size() == 0) {
                outSchemaImpl.initTables(cp);
            } else {
                CaptureSchema.pruneTableList(tableList, cp, bundle);
                if (tableList.size() > 0) {
                    outSchemaImpl.initTables(cp, tableList, vList, false);
                } else {
                    System.err.println(bundle.getString("MESSAGE_NO_VALID_TABLES"));
                    err_flag = true;
                    return;
                }
            }
            System.out.println(bundle.getString("MESSAGE_SCHEMA_CAPTURED"));
            System.out.println(bundle.getString("MESSAGE_SAVING_SCHEMA"));
            FileOutputStream outstream = new FileOutputStream(outfile);
            se.save((OutputStream)outstream);
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println(bundle.getString("ERR_CHECK_CLASSPATH"));
            cnfe.printStackTrace(System.err);
            err_flag = true;
        }
        catch (Throwable exc) {
            exc.printStackTrace(System.err);
            err_flag = true;
        }
        finally {
            if (cp != null) {
                cp.closeConnection();
            }
        }
        System.exit(err_flag ? 1 : 0);
    }

    private static void pruneTableList(List tableList, ConnectionProvider cp, ResourceBundle bundle) throws SQLException {
        DatabaseMetaData dmd = cp.getDatabaseMetaData();
        HashMap<String, String> tables = new HashMap<String, String>();
        String catalog = cp.getConnection().getCatalog();
        String user = cp.getSchema();
        ResultSet rs = dmd.getTables(catalog, user, "%", new String[]{"TABLE"});
        if (rs != null) {
            while (rs.next()) {
                String tn = rs.getString("TABLE_NAME").trim();
                tables.put(tn, tn);
            }
            rs.close();
        }
        Iterator iter = tableList.iterator();
        String[] args = new String[1];
        while (iter.hasNext()) {
            String s = (String)iter.next();
            if (null != tables.get(s.trim())) continue;
            iter.remove();
            args[0] = s;
            System.err.println(MessageFormat.format(bundle.getString("ERR_INVALID_TABLE_GIVEN"), args));
        }
    }

    static class PropChangeReport
    implements PropertyChangeListener {
        PropChangeReport() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
        }
    }
}

