/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.contexts;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Destroyed;
import org.jboss.weld.Container;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.config.WeldConfiguration;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.ManagedConversation;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.contexts.AbstractBoundContext;
import org.jboss.weld.contexts.beanstore.BoundBeanStore;
import org.jboss.weld.contexts.beanstore.ConversationNamingScheme;
import org.jboss.weld.contexts.beanstore.NamingScheme;
import org.jboss.weld.contexts.conversation.ConversationIdGenerator;
import org.jboss.weld.contexts.conversation.ConversationImpl;
import org.jboss.weld.event.FastEvent;
import org.jboss.weld.logging.ConversationLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.serialization.BeanIdentifierIndex;
import org.jboss.weld.util.LazyValueHolder;
import org.jboss.weld.util.reflection.Reflections;

public abstract class AbstractConversationContext<R, S>
extends AbstractBoundContext<R>
implements ConversationContext {
    public static final String CONVERSATIONS_ATTRIBUTE_NAME = ConversationContext.class.getName() + ".conversations";
    public static final String DESTRUCTION_QUEUE_ATTRIBUTE_NAME = ConversationContext.class.getName() + ".destructionQueue";
    private static final String CURRENT_CONVERSATION_ATTRIBUTE_NAME = ConversationContext.class.getName() + ".currentConversation";
    private static final String PARAMETER_NAME = "cid";
    private final AtomicReference<String> parameterName;
    private final AtomicLong defaultTimeout;
    private final AtomicLong concurrentAccessTimeout;
    private final ThreadLocal<R> associated;
    private final BeanManagerImpl manager;
    private final BeanIdentifierIndex beanIdentifierIndex;
    private final LazyValueHolder<FastEvent<String>> conversationBeforeDestroyedEvent = new LazyValueHolder<FastEvent<String>>(){

        @Override
        protected FastEvent<String> computeValue() {
            return FastEvent.of(String.class, AbstractConversationContext.this.manager, AbstractConversationContext.this.manager.getGlobalLenientObserverNotifier(), new Annotation[]{BeforeDestroyed.Literal.CONVERSATION});
        }
    };
    private final LazyValueHolder<FastEvent<String>> conversationDestroyedEvent = new LazyValueHolder<FastEvent<String>>(){

        @Override
        protected FastEvent<String> computeValue() {
            return FastEvent.of(String.class, AbstractConversationContext.this.manager, AbstractConversationContext.this.manager.getGlobalLenientObserverNotifier(), new Annotation[]{Destroyed.Literal.CONVERSATION});
        }
    };

    public AbstractConversationContext(String contextId, ServiceRegistry services) {
        super(contextId, true);
        this.parameterName = new AtomicReference<String>(PARAMETER_NAME);
        WeldConfiguration configuration = services.get(WeldConfiguration.class);
        this.defaultTimeout = new AtomicLong(configuration.getLongProperty(ConfigurationKey.CONVERSATION_TIMEOUT));
        this.concurrentAccessTimeout = new AtomicLong(configuration.getLongProperty(ConfigurationKey.CONVERSATION_CONCURRENT_ACCESS_TIMEOUT));
        this.associated = new ThreadLocal();
        this.manager = Container.instance(contextId).deploymentManager();
        this.beanIdentifierIndex = services.get(BeanIdentifierIndex.class);
    }

    @Override
    public String getParameterName() {
        return this.parameterName.get();
    }

    @Override
    public void setParameterName(String cid) {
        this.parameterName.set(cid);
    }

    @Override
    public void setConcurrentAccessTimeout(long timeout) {
        this.concurrentAccessTimeout.set(timeout);
    }

    @Override
    public long getConcurrentAccessTimeout() {
        return this.concurrentAccessTimeout.get();
    }

    @Override
    public void setDefaultTimeout(long timeout) {
        this.defaultTimeout.set(timeout);
    }

    @Override
    public long getDefaultTimeout() {
        return this.defaultTimeout.get();
    }

    @Override
    public boolean associate(R request) {
        this.associated.set(request);
        return true;
    }

    @Override
    public boolean dissociate(R request) {
        if (this.isAssociated()) {
            try {
                this.copyConversationIdGeneratorAndConversationsToSession();
                boolean bl = true;
                return bl;
            }
            finally {
                this.associated.set(null);
                this.cleanup();
            }
        }
        return false;
    }

    protected void copyConversationIdGeneratorAndConversationsToSession() {
        Object conversationMap;
        R request = this.getRequest();
        if (request == null) {
            return;
        }
        Object conversationIdGenerator = this.getRequestAttribute(request, ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME);
        if (conversationIdGenerator != null && this.getSessionAttribute(request, ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME, false) == null) {
            this.setSessionAttribute(request, ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME, conversationIdGenerator, false);
        }
        if ((conversationMap = this.getRequestAttribute(request, CONVERSATIONS_ATTRIBUTE_NAME)) != null && this.getSessionAttribute(request, CONVERSATIONS_ATTRIBUTE_NAME, false) == null) {
            this.setSessionAttribute(request, CONVERSATIONS_ATTRIBUTE_NAME, conversationMap, false);
        }
    }

    public void sessionCreated() {
        this.copyConversationIdGeneratorAndConversationsToSession();
    }

    protected void associateRequestWithNewConversation() {
        ConversationImpl conversation = new ConversationImpl(this.manager);
        this.lock(conversation);
        this.setRequestAttribute(this.getRequest(), CURRENT_CONVERSATION_ATTRIBUTE_NAME, conversation);
        ConversationNamingScheme namingScheme = new ConversationNamingScheme(this.getNamingSchemePrefix(), "transient", this.beanIdentifierIndex);
        this.setBeanStore(this.createRequestBeanStore(namingScheme, this.getRequest()));
        this.setRequestAttribute(this.getRequest(), ConversationNamingScheme.PARAMETER_NAME, namingScheme);
    }

    protected void associateRequest(ManagedConversation conversation) {
        this.setRequestAttribute(this.getRequest(), CURRENT_CONVERSATION_ATTRIBUTE_NAME, conversation);
        ConversationNamingScheme namingScheme = new ConversationNamingScheme(this.getNamingSchemePrefix(), conversation.getId(), this.beanIdentifierIndex);
        this.setBeanStore(this.createRequestBeanStore(namingScheme, this.getRequest()));
        this.getBeanStore().attach();
    }

    @Override
    public void activate() {
        this.activate(null);
    }

    @Override
    public void activate(String cid) {
        if (!this.isAssociated()) {
            throw ConversationLogger.LOG.mustCallAssociateBeforeActivate();
        }
        if (!this.isActive()) {
            super.setActive(true);
        } else {
            ConversationLogger.LOG.contextAlreadyActive(this.getRequest());
        }
        this.initialize(cid);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void initialize(String cid) {
        if (cid != null && !cid.isEmpty()) {
            ManagedConversation conversation = this.getConversation(cid);
            if (conversation != null && !AbstractConversationContext.isExpired(conversation)) {
                boolean lock = this.lock(conversation);
                if (!lock) {
                    this.associateRequestWithNewConversation();
                    throw ConversationLogger.LOG.conversationLockTimedout(cid);
                }
                if (conversation.isTransient()) {
                    this.associateRequestWithNewConversation();
                    throw ConversationLogger.LOG.noConversationFoundToRestore(cid);
                }
                this.associateRequest(conversation);
                return;
            }
            this.associateRequestWithNewConversation();
            throw ConversationLogger.LOG.noConversationFoundToRestore(cid);
        }
        this.associateRequestWithNewConversation();
    }

    private boolean lock(ManagedConversation conversation) {
        return conversation.lock(this.getConcurrentAccessTimeout());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deactivate() {
        if (!this.isActive()) throw ConversationLogger.LOG.contextNotActive();
        if (!this.isAssociated()) {
            throw ConversationLogger.LOG.mustCallAssociateBeforeDeactivate();
        }
        try {
            if (this.getCurrentConversation().isTransient() && this.getRequestAttribute(this.getRequest(), ConversationNamingScheme.PARAMETER_NAME) != null) {
                this.destroy();
                return;
            } else {
                this.getCurrentConversation().touch();
                if (this.getBeanStore().isAttached()) return;
                if (!(this.getRequestAttribute(this.getRequest(), ConversationNamingScheme.PARAMETER_NAME) instanceof ConversationNamingScheme)) {
                    throw ConversationLogger.LOG.conversationNamingSchemeNotFound();
                }
                ((ConversationNamingScheme)this.getRequestAttribute(this.getRequest(), ConversationNamingScheme.PARAMETER_NAME)).setCid(this.getCurrentConversation().getId());
                this.getBeanStore().attach();
                this.getConversationMap().put(this.getCurrentConversation().getId(), this.getCurrentConversation());
            }
            return;
        }
        finally {
            this.getCurrentConversation().unlock();
            this.setBeanStore(null);
            this.cleanUpConversationMap();
            this.removeState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpConversationMap() {
        Map<String, ManagedConversation> conversations;
        Map<String, ManagedConversation> map = conversations = this.getConversationMap();
        synchronized (map) {
            Iterator<Map.Entry<String, ManagedConversation>> entryIterator = conversations.entrySet().iterator();
            S session = this.getSessionFromRequest(this.getRequest(), false);
            while (entryIterator.hasNext()) {
                Map.Entry<String, ManagedConversation> entry = entryIterator.next();
                if (!entry.getValue().isTransient()) continue;
                this.destroyConversation(session, entry.getKey());
                entryIterator.remove();
            }
        }
    }

    public void conversationPromotedToLongRunning(ConversationImpl conversation) {
        this.getConversationMap().put(conversation.getId(), conversation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        Map<String, ManagedConversation> conversations;
        ManagedConversation currentConversation = this.getCurrentConversation();
        Map<String, ManagedConversation> map = conversations = this.getConversationMap();
        synchronized (map) {
            for (Map.Entry<String, ManagedConversation> stringManagedConversationEntry : conversations.entrySet()) {
                ManagedConversation conversation = stringManagedConversationEntry.getValue();
                if (currentConversation.equals(conversation) || conversation.isTransient() || !AbstractConversationContext.isExpired(conversation)) continue;
                if (!conversation.lock(0L)) {
                    ConversationLogger.LOG.endLockedConversation(conversation.getId());
                }
                conversation.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroy(S session) {
        BoundBeanStore beanStore = this.getBeanStore();
        boolean active = this.isActive();
        if (beanStore != null) {
            beanStore.detach();
        }
        try {
            Object conversationMap = this.getSessionAttributeFromSession(session, CONVERSATIONS_ATTRIBUTE_NAME);
            if (conversationMap instanceof Map) {
                Map conversations;
                Map map = conversations = (Map)Reflections.cast(conversationMap);
                synchronized (map) {
                    if (!conversations.isEmpty()) {
                        this.setActive(true);
                        if (beanStore == null) {
                            for (Map.Entry entry : conversations.entrySet()) {
                                this.destroyConversation(session, (String)entry.getKey());
                            }
                        } else {
                            this.setDestructionQueue(conversations, session);
                        }
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.setBeanStore(beanStore);
            this.setActive(active);
            if (beanStore != null) {
                beanStore.attach();
            } else if (!active) {
                this.removeState();
                this.cleanup();
            }
        }
    }

    private void setDestructionQueue(Map<String, ManagedConversation> conversations, S session) {
        HashMap contexts = new HashMap();
        for (Map.Entry<String, ManagedConversation> entry : conversations.entrySet()) {
            ManagedConversation conversation = entry.getValue();
            if (!conversation.isTransient()) {
                conversation.end();
            }
            ArrayList<ContextualInstance> contextualInstances = new ArrayList<ContextualInstance>();
            for (String id : new ConversationNamingScheme(this.getNamingSchemePrefix(), entry.getKey(), this.beanIdentifierIndex).filterIds(this.getSessionAttributeNames(session))) {
                contextualInstances.add((ContextualInstance)this.getSessionAttributeFromSession(session, id));
            }
            contexts.put(entry.getKey(), contextualInstances);
        }
        this.setRequestAttribute(this.getRequest(), DESTRUCTION_QUEUE_ATTRIBUTE_NAME, Collections.synchronizedMap(contexts));
    }

    protected void destroyConversation(S session, String id) {
        if (session != null) {
            this.conversationBeforeDestroyedEvent.get().fire(id);
            this.setBeanStore(this.createSessionBeanStore(new ConversationNamingScheme(this.getNamingSchemePrefix(), id, this.beanIdentifierIndex), session));
            this.getBeanStore().attach();
            this.destroy();
            this.getBeanStore().detach();
            this.setBeanStore(null);
            this.conversationDestroyedEvent.get().fire(id);
        }
    }

    @Override
    public String generateConversationId() {
        ConversationIdGenerator generator = this.getConversationIdGenerator();
        this.checkContextInitialized();
        return generator.call();
    }

    protected ConversationIdGenerator getConversationIdGenerator() {
        R request = this.associated.get();
        if (request == null) {
            throw ConversationLogger.LOG.mustCallAssociateBeforeGeneratingId();
        }
        Object conversationIdGenerator = this.getRequestAttribute(request, ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME);
        if (conversationIdGenerator == null) {
            conversationIdGenerator = this.getSessionAttribute(request, ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME, false);
            if (conversationIdGenerator == null) {
                conversationIdGenerator = new ConversationIdGenerator();
                this.setRequestAttribute(request, ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME, conversationIdGenerator);
                this.setSessionAttribute(request, ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME, conversationIdGenerator, false);
            } else {
                this.setRequestAttribute(request, ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME, conversationIdGenerator);
            }
        }
        if (!(conversationIdGenerator instanceof ConversationIdGenerator)) {
            throw ConversationLogger.LOG.conversationIdGeneratorNotFound();
        }
        return (ConversationIdGenerator)conversationIdGenerator;
    }

    private static boolean isExpired(ManagedConversation conversation) {
        return System.currentTimeMillis() > conversation.getLastUsed() + conversation.getTimeout();
    }

    @Override
    public ManagedConversation getConversation(String id) {
        return this.getConversationMap().get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ManagedConversation> getConversations() {
        Map<String, ManagedConversation> conversations;
        Map<String, ManagedConversation> map = conversations = this.getConversationMap();
        synchronized (map) {
            return new HashSet<ManagedConversation>(conversations.values());
        }
    }

    private void checkIsAssociated() {
        if (!this.isAssociated()) {
            throw ConversationLogger.LOG.mustCallAssociateBeforeLoadingKnownConversations();
        }
    }

    private Map<String, ManagedConversation> getConversationMap() {
        this.checkIsAssociated();
        this.checkContextInitialized();
        R request = this.getRequest();
        Object conversationMap = this.getRequestAttribute(request, CONVERSATIONS_ATTRIBUTE_NAME);
        if (conversationMap == null) {
            conversationMap = this.getSessionAttribute(request, CONVERSATIONS_ATTRIBUTE_NAME, false);
            if (conversationMap == null) {
                conversationMap = Collections.synchronizedMap(new HashMap());
                this.setRequestAttribute(request, CONVERSATIONS_ATTRIBUTE_NAME, conversationMap);
                this.setSessionAttribute(request, CONVERSATIONS_ATTRIBUTE_NAME, conversationMap, false);
            } else {
                this.setRequestAttribute(request, CONVERSATIONS_ATTRIBUTE_NAME, conversationMap);
            }
        }
        if (conversationMap == null || !(conversationMap instanceof Map)) {
            throw ConversationLogger.LOG.unableToLoadConversations(CONVERSATIONS_ATTRIBUTE_NAME, conversationMap, request);
        }
        return (Map)Reflections.cast(conversationMap);
    }

    @Override
    public ManagedConversation getCurrentConversation() {
        this.checkIsAssociated();
        this.checkContextInitialized();
        R request = this.getRequest();
        Object attribute = this.getRequestAttribute(request, CURRENT_CONVERSATION_ATTRIBUTE_NAME);
        if (attribute == null || !(attribute instanceof ManagedConversation)) {
            throw ConversationLogger.LOG.unableToLoadCurrentConversation(CURRENT_CONVERSATION_ATTRIBUTE_NAME, attribute, request);
        }
        return (ManagedConversation)attribute;
    }

    public Class<? extends Annotation> getScope() {
        return ConversationScoped.class;
    }

    protected abstract void setSessionAttribute(R var1, String var2, Object var3, boolean var4);

    protected abstract Object getSessionAttribute(R var1, String var2, boolean var3);

    protected abstract Object getSessionAttributeFromSession(S var1, String var2);

    protected abstract void removeRequestAttribute(R var1, String var2);

    protected abstract void setRequestAttribute(R var1, String var2, Object var3);

    protected abstract Object getRequestAttribute(R var1, String var2);

    protected abstract BoundBeanStore createRequestBeanStore(NamingScheme var1, R var2);

    protected abstract BoundBeanStore createSessionBeanStore(NamingScheme var1, S var2);

    protected abstract S getSessionFromRequest(R var1, boolean var2);

    protected abstract String getNamingSchemePrefix();

    protected boolean isAssociated() {
        return this.associated.get() != null;
    }

    protected R getRequest() {
        return this.associated.get();
    }

    protected abstract Iterator<String> getSessionAttributeNames(S var1);
}

