/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.jobinstance;

import com.ibm.jbatch.container.context.impl.MetricImpl;
import com.ibm.jbatch.container.context.impl.StepContextImpl;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import javax.batch.api.partition.PartitionPlan;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;

public class StepExecutionImpl
implements StepExecution,
Serializable {
    private long commitCount = 0L;
    private Timestamp endTime = null;
    private String exitStatus = null;
    private BatchStatus batchStatus = null;
    private long filterCount = 0L;
    private long jobExecutionId = 0L;
    private Timestamp lastUpdateTime = null;
    private long processSkipCount = 0L;
    private long readCount = 0L;
    private long readSkipCount = 0L;
    private long rollbackCount = 0L;
    private Timestamp startTime = null;
    private long stepExecutionId = 0L;
    private String stepName = null;
    private long writeCount = 0L;
    private long writeSkipCount = 0L;
    private PartitionPlan plan = null;
    private Serializable persistentUserData = null;
    private StepContextImpl stepContext = null;
    private static final long serialVersionUID = 1L;

    public StepExecutionImpl(long jobExecutionId, long stepExecutionId) {
        this.jobExecutionId = jobExecutionId;
        this.stepExecutionId = stepExecutionId;
    }

    public long getStepExecutionId() {
        return this.stepExecutionId;
    }

    public Date getEndTime() {
        if (this.stepContext != null) {
            return this.stepContext.getEndTimeTS();
        }
        if (this.endTime != null) {
            return new Date(this.endTime.getTime());
        }
        return null;
    }

    public long getJobExecutionId() {
        return this.jobExecutionId;
    }

    public String getExitStatus() {
        if (this.stepContext != null) {
            return this.stepContext.getExitStatus();
        }
        return this.exitStatus;
    }

    public Date getStartTime() {
        if (this.stepContext != null) {
            return this.stepContext.getStartTimeTS();
        }
        if (this.startTime != null) {
            return new Date(this.startTime.getTime());
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("---------------------------------------------------------------------------------");
        buf.append("getStepName(): " + this.getStepName() + "\n");
        buf.append("getStepExecutionId(): " + this.stepExecutionId + "\n");
        buf.append("getJobExecutionId(): " + this.jobExecutionId + "\n");
        buf.append("getStartTime(): " + this.getStartTime() + "\n");
        buf.append("getEndTime(): " + this.getEndTime() + "\n");
        buf.append("getBatchStatus(): " + this.getBatchStatus().name() + "\n");
        buf.append("getExitStatus(): " + this.getExitStatus());
        buf.append("---------------------------------------------------------------------------------");
        return buf.toString();
    }

    public Metric[] getMetrics() {
        if (this.stepContext != null) {
            return this.stepContext.getMetrics();
        }
        Metric[] metrics = new MetricImpl[]{new MetricImpl(Metric.MetricType.READ_COUNT, this.readCount), new MetricImpl(Metric.MetricType.WRITE_COUNT, this.writeCount), new MetricImpl(Metric.MetricType.COMMIT_COUNT, this.commitCount), new MetricImpl(Metric.MetricType.ROLLBACK_COUNT, this.rollbackCount), new MetricImpl(Metric.MetricType.READ_SKIP_COUNT, this.readSkipCount), new MetricImpl(Metric.MetricType.PROCESS_SKIP_COUNT, this.processSkipCount), new MetricImpl(Metric.MetricType.FILTER_COUNT, this.filterCount), new MetricImpl(Metric.MetricType.WRITE_SKIP_COUNT, this.writeSkipCount)};
        return metrics;
    }

    public BatchStatus getBatchStatus() {
        if (this.stepContext != null) {
            return this.stepContext.getBatchStatus();
        }
        return this.batchStatus;
    }

    public Serializable getPersistentUserData() {
        if (this.stepContext != null) {
            return this.stepContext.getPersistentUserData();
        }
        return this.persistentUserData;
    }

    public void setFilterCount(long filterCnt) {
        this.filterCount = filterCnt;
    }

    public void setLastUpdateTime(Timestamp lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public void setProcessSkipCount(long processSkipCnt) {
        this.processSkipCount = processSkipCnt;
    }

    public void setReadCount(long readCnt) {
        this.readCount = readCnt;
    }

    public void setReadSkipCount(long readSkipCnt) {
        this.readSkipCount = readSkipCnt;
    }

    public void setRollbackCount(long rollbackCnt) {
        this.rollbackCount = rollbackCnt;
    }

    public void setJobExecutionId(long jobexecID) {
        this.jobExecutionId = jobexecID;
    }

    public void setStepExecutionId(long stepexecID) {
        this.stepExecutionId = stepexecID;
    }

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }

    public void setWriteCount(long writeCnt) {
        this.writeCount = writeCnt;
    }

    public void setWriteSkipCount(long writeSkipCnt) {
        this.writeSkipCount = writeSkipCnt;
    }

    public void setStepContext(StepContextImpl stepContext) {
        this.stepContext = stepContext;
    }

    public void setCommitCount(long commitCnt) {
        this.commitCount = commitCnt;
    }

    public void setBatchStatus(BatchStatus batchstatus) {
        this.batchStatus = batchstatus;
    }

    public void setExitStatus(String exitstatus) {
        this.exitStatus = exitstatus;
    }

    public void setStartTime(Timestamp startts) {
        this.startTime = startts;
    }

    public void setEndTime(Timestamp endts) {
        this.endTime = endts;
    }

    public void setPersistentUserData(Serializable data) {
        this.persistentUserData = data;
    }

    public String getStepName() {
        if (this.stepContext != null) {
            return this.stepContext.getStepName();
        }
        return this.stepName;
    }

    public void setPlan(PartitionPlan plan) {
        this.plan = plan;
    }

    public PartitionPlan getPlan() {
        return this.plan;
    }
}

