/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox.permissiondd;

import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.whitebox.Debug;
import java.io.FilePermission;
import java.net.SocketPermission;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedExceptionAction;
import java.util.PropertyPermission;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.Xid;
import javax.xml.ws.WebServicePermission;

public class PermissionDDWorkManager {
    private BootstrapContext bsc = null;
    private WorkManager wmgr;
    private Xid myxid;
    private Xid mynestxid;

    public PermissionDDWorkManager(BootstrapContext val) {
        this.debug("enterred constructor");
        this.bsc = val;
        this.wmgr = this.bsc.getWorkManager();
        this.debug("leaving constructor");
    }

    public void runTests() {
        this.debug("enterred runTests");
        this.validateCustomPerm();
        this.validateCustomPermFromAppServer();
        this.validateLocalGrantForCustomPerm();
        this.validateRequiredPermSet();
        this.validateMissingPermFails();
        this.validateRestrictedLocalPerm();
        this.validateLocalPermsInvalidName();
        this.debug("leaving runTests");
    }

    public void validateCustomPerm() {
        try {
            WebServicePermission perm = new WebServicePermission("CTSPermission1_name");
            this.doCheckPermission((Permission)perm);
            this.debug("validateCustomPerm():  CTSPermission1_name permission okay");
            ConnectorStatus.getConnectorStatus().logState("SUCCESS:  validateCustomPerm passed.");
        }
        catch (AccessControlException ex) {
            ConnectorStatus.getConnectorStatus().logState("FAILURE:  validateCustomPerm(), throwing AccessControlException.");
            this.debug("FAILURE:  CTSPermission1_name perm missing, throwing AccessControlException.");
            Debug.printDebugStack((Exception)ex);
        }
        catch (Exception ex) {
            ConnectorStatus.getConnectorStatus().logState("FAILURE:  validateCustomPerm(), throwing unexpected Exception.");
            Debug.printDebugStack((Exception)ex);
        }
    }

    public void validateCustomPermFromAppServer() {
        try {
            WebServicePermission perm = new WebServicePermission("ConnectorPermission1_name2");
            this.doCheckPermission((Permission)perm);
            this.debug("validateCustomPermFromAppServer():  ConnectorPermission1_name2 permission okay");
            ConnectorStatus.getConnectorStatus().logState("SUCCESS:  validateCustomPermFromAppServer passed.");
        }
        catch (AccessControlException ex) {
            ConnectorStatus.getConnectorStatus().logState("FAILURE:  validateCustomPermFromAppServer(), throwing AccessControlException.");
            this.debug("FAILURE:  ConnectorPermission1_name2 perm missing, throwing AccessControlException.");
            Debug.printDebugStack((Exception)ex);
        }
        catch (Exception ex) {
            ConnectorStatus.getConnectorStatus().logState("FAILURE:  validateCustomPermFromAppServer(), throwing unexpected Exception.");
            Debug.printDebugStack((Exception)ex);
        }
    }

    public void validateLocalGrantForCustomPerm() {
        try {
            WebServicePermission perm = new WebServicePermission("CTSPermission2_name");
            this.doCheckPermission((Permission)perm);
            this.debug("validateLocalGrantForCustomPerm():  CTSPermission2_name permission property granted AccessControlException.");
            ConnectorStatus.getConnectorStatus().logState("SUCCESS:  validateLocalGrantForCustomPerm passed.");
        }
        catch (AccessControlException ex) {
            ConnectorStatus.getConnectorStatus().logState("FAILURE:  validateLocalGrantForCustomPerm(), throwing AccessControlException.");
            this.debug("FAILURE:  CTSPermission2_name perm missing, throwing AccessControlException.");
            Debug.printDebugStack((Exception)ex);
        }
        catch (Exception ex) {
            this.debug("FAILURE:  validateLocalGrantForCustomPerm(), throwing unexpected Exception.");
            ConnectorStatus.getConnectorStatus().logState("FAILURE:  validateLocalGrantForCustomPerm(), throwing unexpected Exception.");
            Debug.printDebugStack((Exception)ex);
        }
        this.debug("returning from validateLocalGrantForCustomPerm()");
    }

    public void validateRequiredPermSet() {
        try {
            RuntimePermission rtperm = new RuntimePermission("loadLibrary.*");
            this.doCheckPermission(rtperm);
            this.debug("validateRequiredPermSet():  valid perm for: " + rtperm.toString());
            RuntimePermission rtperm2 = new RuntimePermission("queuePrintJob");
            this.doCheckPermission(rtperm2);
            this.debug("validateRequiredPermSet():  valid perm for: " + rtperm2.toString());
            SocketPermission socperm = new SocketPermission("*", "connect");
            this.doCheckPermission(socperm);
            this.debug("validateRequiredPermSet():  valid perm for: " + socperm.toString());
            FilePermission fperm = new FilePermission("*", "read");
            this.doCheckPermission(fperm);
            this.debug("validateRequiredPermSet():  valid perm for: " + fperm.toString());
            PropertyPermission pperm = new PropertyPermission("*", "read");
            this.doCheckPermission(pperm);
            this.debug("validateRequiredPermSet():  valid perm for: " + pperm.toString());
            this.debug("SUCCESS:  validateRequiredPermSet passed.");
            ConnectorStatus.getConnectorStatus().logState("SUCCESS:  validateRequiredPermSet passed.");
        }
        catch (AccessControlException ex) {
            this.debug("FAILURE:  validateRequiredPermSet throwing AccessControlException.");
            ConnectorStatus.getConnectorStatus().logState("FAILURE:  validateRequiredPermSet throwing AccessControlException.");
            Debug.printDebugStack((Exception)ex);
        }
        catch (Exception ex) {
            this.debug("FAILURE:  validateRequiredPermSet had unexpected Exception.");
            ConnectorStatus.getConnectorStatus().logState("FAILURE:  validateRequiredPermSet had unexpected Exception.");
            Debug.printDebugStack((Exception)ex);
        }
        this.debug("returning from validateRequiredPermSet()");
    }

    public void validateMissingPermFails() {
        try {
            WebServicePermission perm = new WebServicePermission("CTSPermission3_name");
            this.doCheckPermission((Permission)perm);
            ConnectorStatus.getConnectorStatus().logState("FAILURE:  CTSPermission3_name permission okay");
        }
        catch (AccessControlException ex) {
            this.debug("SUCCESS:  CTSPermission3_name doesnt exist and was caught.");
            ConnectorStatus.getConnectorStatus().logState("SUCCESS:  CTSPermission3_name doesnt exist and was caught.");
            ConnectorStatus.getConnectorStatus().logState("SUCCESS:  validateMissingPermFails passed.");
            Debug.printDebugStack((Exception)ex);
        }
        catch (Exception ex) {
            this.debug("FAILURE:  validateMissingPermFails threw unexpected exception.");
            ConnectorStatus.getConnectorStatus().logState("FAILURE:  validateMissingPermFails threw unexpected exception.");
            Debug.printDebugStack((Exception)ex);
        }
        this.debug("returning from validateMissingPermFails()");
    }

    public void validateRestrictedLocalPerm() {
        try {
            PropertyPermission readPropertyPerm = new PropertyPermission("TestPropertyPerm", "read");
            try {
                this.doCheckPermission(readPropertyPerm);
                this.debug("SUCCESS:  validateRestrictedLocalPerm() has grant for read of TestPropertyPerm");
            }
            catch (AccessControlException ex) {
                this.debug("FAILURE:  validateRestrictedLocalPerm() threw unexpected exception for read of TestPropertyPerm.");
                ConnectorStatus.getConnectorStatus().logState("FAILURE:  validateRestrictedLocalPerm() threw AccessControlException.");
                Debug.printDebugStack((Exception)ex);
                return;
            }
            this.debug("SUCCESS:  validateRestrictedLocalPerm passed.");
            ConnectorStatus.getConnectorStatus().logState("SUCCESS:  validateRestrictedLocalPerm passed.");
        }
        catch (Exception ex) {
            this.debug("FAILURE:  validateRestrictedLocalPerm had unexpected exception.");
            ConnectorStatus.getConnectorStatus().logState("FAILURE:  validateRestrictedLocalPerm had unexpected exception.");
            Debug.printDebugStack((Exception)ex);
        }
        this.debug("returning from validateRestrictedLocalPerm()");
    }

    public void validateLocalPermsInvalidName() {
        try {
            WebServicePermission secPerm = new WebServicePermission("NonExistingName");
            try {
                this.doCheckPermission((Permission)secPerm);
                this.debug("FAILURE:  validateLocalPermsInvalidName() did not throw expected AccessControlException.");
                ConnectorStatus.getConnectorStatus().logState("FAILURE:  validateLocalPermsInvalidName().");
                return;
            }
            catch (AccessControlException ex) {
                ConnectorStatus.getConnectorStatus().logState("SUCCESS:  validateLocalPermsInvalidName() threw expected AccessControlException");
                try {
                    WebServicePermission perm = new WebServicePermission("CTSPermission_second_name");
                    this.doCheckPermission((Permission)perm);
                    this.debug("CTSPermission_second_name permission property granted AccessControlException.");
                }
                catch (AccessControlException ex2) {
                    this.debug("FAILURE:  validateLocalPermsInvalidName() threw unexpected exception.");
                    ConnectorStatus.getConnectorStatus().logState("FAILURE:  validateLocalPermsInvalidName() threw unexpected exception.");
                    Debug.printDebugStack((Exception)ex2);
                    return;
                }
                catch (Exception ex3) {
                    this.debug("FAILURE:  validateLocalPermsInvalidName had unexpeted exception.");
                    ConnectorStatus.getConnectorStatus().logState("FAILURE:  validateLocalPermsInvalidName had unexpeted exception.");
                    Debug.printDebugStack((Exception)ex3);
                    return;
                }
                this.debug("SUCCESS:  validateLocalPermsInvalidName passed.");
                ConnectorStatus.getConnectorStatus().logState("SUCCESS:  validateLocalPermsInvalidName passed.");
            }
        }
        catch (Exception ex) {
            this.debug("FAILURE:  validateLocalPermsInvalidName had unexpected exception.");
            ConnectorStatus.getConnectorStatus().logState("FAILURE:  validateLocalPermsInvalidName had unexpected exception.");
            ex.printStackTrace();
        }
        this.debug("returning from validateLocalPermsInvalidName()");
    }

    public void doCheckPermission(Permission pp) throws Exception {
        final Permission perm = pp;
        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws AccessControlException {
                AccessController.checkPermission(perm);
                return null;
            }
        });
    }

    public void setXid(Xid xid) {
        this.myxid = xid;
    }

    public Xid getXid() {
        return this.myxid;
    }

    public void setNestXid(Xid xid) {
        this.mynestxid = xid;
    }

    public Xid getNestXid() {
        return this.mynestxid;
    }

    public void debug(String out) {
        Debug.trace((String)("PermissionDDWorkManager:  " + out));
    }
}

