/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.enhanced.jlr;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.inject.Qualifier;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotated;
import org.jboss.weld.annotated.slim.unbacked.UnbackedAnnotatedType;
import org.jboss.weld.logging.ReflectionLogger;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.ReflectionCache;
import org.jboss.weld.util.collections.Arrays2;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.collections.Multimap;
import org.jboss.weld.util.collections.Multimaps;
import org.jboss.weld.util.collections.SetMultimap;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Reflections;

public abstract class AbstractEnhancedAnnotated<T, S>
implements EnhancedAnnotated<T, S> {
    private static final Set<Annotation> DEFAULT_QUALIFIERS = Collections.singleton(Default.Literal.INSTANCE);
    private final Map<Class<? extends Annotation>, Annotation> annotationMap;
    private final Multimap<Class<? extends Annotation>, Annotation> metaAnnotationMap;
    private final Class<T> rawType;
    private final Type[] actualTypeArguments;
    private final Annotated delegate;
    private final Set<Annotation> annotations;

    protected static Map<Class<? extends Annotation>, Annotation> buildAnnotationMap(Iterable<Annotation> annotations) {
        HashMap<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : annotations) {
            annotationMap.put(annotation.annotationType(), annotation);
        }
        return annotationMap;
    }

    protected static void addMetaAnnotations(SetMultimap<Class<? extends Annotation>, Annotation> metaAnnotationMap, Annotation annotation, Iterable<Annotation> metaAnnotations, boolean declared) {
        for (Annotation metaAnnotation : metaAnnotations) {
            AbstractEnhancedAnnotated.addMetaAnnotation(metaAnnotationMap, annotation, metaAnnotation.annotationType(), declared);
        }
    }

    private static void addMetaAnnotation(SetMultimap<Class<? extends Annotation>, Annotation> metaAnnotationMap, Annotation annotation, Class<? extends Annotation> metaAnnotationType, boolean declared) {
        if (declared ? MAPPED_DECLARED_METAANNOTATIONS.contains(metaAnnotationType) : MAPPED_METAANNOTATIONS.contains(metaAnnotationType)) {
            metaAnnotationMap.put(metaAnnotationType, (Object)annotation);
        }
    }

    public AbstractEnhancedAnnotated(Annotated annotated, Map<Class<? extends Annotation>, Annotation> annotationMap, Map<Class<? extends Annotation>, Annotation> declaredAnnotationMap, ClassTransformer classTransformer) {
        this.delegate = annotated;
        this.rawType = annotated instanceof AnnotatedType ? ((AnnotatedType)Reflections.cast(annotated)).getJavaClass() : Reflections.getRawType(annotated.getBaseType());
        if (annotationMap == null) {
            throw ReflectionLogger.LOG.annotationMapNull();
        }
        this.annotationMap = WeldCollections.immutableMapView(annotationMap);
        SetMultimap<Class<? extends Annotation>, Annotation> metaAnnotationMap = SetMultimap.newSetMultimap();
        this.processMetaAnnotations(metaAnnotationMap, annotationMap.values(), classTransformer, false);
        this.metaAnnotationMap = Multimaps.unmodifiableMultimap(metaAnnotationMap);
        if (declaredAnnotationMap == null) {
            throw ReflectionLogger.LOG.declaredAnnotationMapNull();
        }
        this.actualTypeArguments = this.delegate.getBaseType() instanceof ParameterizedType ? ((ParameterizedType)this.delegate.getBaseType()).getActualTypeArguments() : Arrays2.EMPTY_TYPE_ARRAY;
        this.annotations = ImmutableSet.copyOf(this.annotationMap.values());
    }

    protected void processMetaAnnotations(SetMultimap<Class<? extends Annotation>, Annotation> metaAnnotationMap, Collection<Annotation> annotations, ClassTransformer classTransformer, boolean declared) {
        for (Annotation annotation : annotations) {
            this.processMetaAnnotations(metaAnnotationMap, annotation, classTransformer, declared);
        }
    }

    protected void processMetaAnnotations(SetMultimap<Class<? extends Annotation>, Annotation> metaAnnotationMap, Annotation[] annotations, ClassTransformer classTransformer, boolean declared) {
        for (Annotation annotation : annotations) {
            this.processMetaAnnotations(metaAnnotationMap, annotation, classTransformer, declared);
        }
    }

    protected void processMetaAnnotations(SetMultimap<Class<? extends Annotation>, Annotation> metaAnnotationMap, Annotation annotation, ClassTransformer classTransformer, boolean declared) {
        UnbackedAnnotatedType<? extends Annotation> syntheticAnnotationAnnotatedType = classTransformer.getSyntheticAnnotationAnnotatedType(annotation.annotationType());
        if (syntheticAnnotationAnnotatedType != null) {
            AbstractEnhancedAnnotated.addMetaAnnotations(metaAnnotationMap, annotation, syntheticAnnotationAnnotatedType.getAnnotations(), declared);
        } else {
            AbstractEnhancedAnnotated.addMetaAnnotations(metaAnnotationMap, annotation, classTransformer.getReflectionCache().getAnnotations(annotation.annotationType()), declared);
            ReflectionCache.AnnotationClass<? extends Annotation> annotationClass = classTransformer.getReflectionCache().getAnnotationClass(annotation.annotationType());
            if (annotationClass.isRepeatableAnnotationContainer()) {
                this.processMetaAnnotations(metaAnnotationMap, annotationClass.getRepeatableAnnotations(annotation), classTransformer, declared);
            }
        }
        AbstractEnhancedAnnotated.addMetaAnnotations(metaAnnotationMap, annotation, classTransformer.getTypeStore().get(annotation.annotationType()), declared);
    }

    @Override
    public Class<T> getJavaClass() {
        return this.rawType;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return Arrays.copyOf(this.actualTypeArguments, this.actualTypeArguments.length);
    }

    @Override
    public Set<Type> getInterfaceClosure() {
        HashSet<Type> interfaces = new HashSet<Type>();
        for (Type t : this.getTypeClosure()) {
            if (!Reflections.getRawType(t).isInterface()) continue;
            interfaces.add(t);
        }
        return WeldCollections.immutableSetView(interfaces);
    }

    public abstract S getDelegate();

    @Override
    public boolean isParameterizedType() {
        return this.rawType.getTypeParameters().length > 0;
    }

    @Override
    public boolean isPrimitive() {
        return this.getJavaClass().isPrimitive();
    }

    public Type getBaseType() {
        return this.delegate.getBaseType();
    }

    public Set<Type> getTypeClosure() {
        return this.delegate.getTypeClosure();
    }

    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public Set<Annotation> getMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
        return ImmutableSet.copyOf(this.metaAnnotationMap.get(metaAnnotationType));
    }

    @Override
    @Deprecated
    public Set<Annotation> getQualifiers() {
        Set<Annotation> qualifiers = this.getMetaAnnotations(Qualifier.class);
        if (qualifiers.size() > 0) {
            return WeldCollections.immutableSetView(qualifiers);
        }
        return DEFAULT_QUALIFIERS;
    }

    @Override
    @Deprecated
    public Annotation[] getBindingsAsArray() {
        return this.getQualifiers().toArray(Reflections.EMPTY_ANNOTATIONS);
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)((Annotation)annotationType.cast(this.annotationMap.get(annotationType)));
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.annotationMap.containsKey(annotationType);
    }

    Map<Class<? extends Annotation>, Annotation> getAnnotationMap() {
        return this.annotationMap;
    }
}

