/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.CloseListener;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ICloseType;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.npn.AlpnClientNegotiator;
import org.glassfish.grizzly.npn.AlpnServerNegotiator;
import org.glassfish.grizzly.npn.NegotiationSupport;
import org.glassfish.grizzly.ssl.SSLBaseFilter;
import org.glassfish.grizzly.ssl.SSLUtils;

public class AlpnSupport {
    private static final Logger LOGGER = Grizzly.logger(AlpnSupport.class);
    private static final Map<SSLEngine, Connection> SSL_TO_CONNECTION_MAP = new WeakHashMap<SSLEngine, Connection>();
    private static final AlpnSupport INSTANCE;
    private final Map<Object, AlpnServerNegotiator> serverSideNegotiators = new WeakHashMap<Object, AlpnServerNegotiator>();
    private final ReadWriteLock serverSideLock = new ReentrantReadWriteLock();
    private final Map<Object, AlpnClientNegotiator> clientSideNegotiators = new WeakHashMap<Object, AlpnClientNegotiator>();
    private final ReadWriteLock clientSideLock = new ReentrantReadWriteLock();
    private final SSLBaseFilter.HandshakeListener handshakeListener = new SSLBaseFilter.HandshakeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStart(Connection connection) {
            final SSLEngine sslEngine = SSLUtils.getSSLEngine(connection);
            assert (sslEngine != null);
            if (sslEngine.getUseClientMode()) {
                AlpnClientNegotiator negotiator;
                AlpnSupport.this.clientSideLock.readLock().lock();
                try {
                    negotiator = (AlpnClientNegotiator)AlpnSupport.this.clientSideNegotiators.get(connection);
                    if (negotiator == null) {
                        negotiator = (AlpnClientNegotiator)AlpnSupport.this.clientSideNegotiators.get(connection.getTransport());
                    }
                }
                finally {
                    AlpnSupport.this.clientSideLock.readLock().unlock();
                }
                if (negotiator != null) {
                    connection.addCloseListener(new CloseListener(){

                        public void onClosed(Closeable closeable, ICloseType type) throws IOException {
                            NegotiationSupport.removeClientNegotiator((SSLEngine)sslEngine);
                        }
                    });
                    AlpnSupport.setConnection(sslEngine, connection);
                    NegotiationSupport.addNegotiator((SSLEngine)sslEngine, (AlpnClientNegotiator)negotiator);
                }
            } else {
                AlpnServerNegotiator negotiator;
                AlpnSupport.this.serverSideLock.readLock().lock();
                try {
                    negotiator = (AlpnServerNegotiator)AlpnSupport.this.serverSideNegotiators.get(connection);
                    if (negotiator == null) {
                        negotiator = (AlpnServerNegotiator)AlpnSupport.this.serverSideNegotiators.get(connection.getTransport());
                    }
                }
                finally {
                    AlpnSupport.this.serverSideLock.readLock().unlock();
                }
                if (negotiator != null) {
                    connection.addCloseListener(new CloseListener(){

                        public void onClosed(Closeable closeable, ICloseType type) throws IOException {
                            NegotiationSupport.removeServerNegotiator((SSLEngine)sslEngine);
                        }
                    });
                    AlpnSupport.setConnection(sslEngine, connection);
                    NegotiationSupport.addNegotiator((SSLEngine)sslEngine, (AlpnServerNegotiator)negotiator);
                }
            }
        }

        @Override
        public void onComplete(Connection connection) {
        }

        @Override
        public void onFailure(Connection connection, Throwable t) {
        }
    };

    public static boolean isEnabled() {
        return INSTANCE != null;
    }

    public static AlpnSupport getInstance() {
        if (!AlpnSupport.isEnabled()) {
            throw new IllegalStateException("TLS ALPN is disabled");
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(SSLEngine engine) {
        Map<SSLEngine, Connection> map = SSL_TO_CONNECTION_MAP;
        synchronized (map) {
            return SSL_TO_CONNECTION_MAP.get(engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setConnection(SSLEngine engine, Connection connection) {
        Map<SSLEngine, Connection> map = SSL_TO_CONNECTION_MAP;
        synchronized (map) {
            SSL_TO_CONNECTION_MAP.put(engine, connection);
        }
    }

    private AlpnSupport() {
    }

    public void configure(SSLBaseFilter sslFilter) {
        sslFilter.addHandshakeListener(this.handshakeListener);
    }

    public void setServerSideNegotiator(Transport transport, AlpnServerNegotiator negotiator) {
        this.putServerSideNegotiator(transport, negotiator);
    }

    public void setServerSideNegotiator(Connection connection, AlpnServerNegotiator negotiator) {
        this.putServerSideNegotiator(connection, negotiator);
    }

    public void setClientSideNegotiator(Transport transport, AlpnClientNegotiator negotiator) {
        this.putClientSideNegotiator(transport, negotiator);
    }

    public void setClientSideNegotiator(Connection connection, AlpnClientNegotiator negotiator) {
        this.putClientSideNegotiator(connection, negotiator);
    }

    private void putServerSideNegotiator(Object object, AlpnServerNegotiator negotiator) {
        this.serverSideLock.writeLock().lock();
        try {
            this.serverSideNegotiators.put(object, negotiator);
        }
        finally {
            this.serverSideLock.writeLock().unlock();
        }
    }

    private void putClientSideNegotiator(Object object, AlpnClientNegotiator negotiator) {
        this.clientSideLock.writeLock().lock();
        try {
            this.clientSideNegotiators.put(object, negotiator);
        }
        finally {
            this.clientSideLock.writeLock().unlock();
        }
    }

    static {
        boolean isExtensionFound = false;
        try {
            ClassLoader.getSystemClassLoader().loadClass("sun.security.ssl.GrizzlyNPN");
            isExtensionFound = true;
        }
        catch (Throwable e) {
            LOGGER.log(Level.FINE, "TLS ALPN extension is not found:", e);
        }
        INSTANCE = isExtensionFound ? new AlpnSupport() : null;
    }
}

