/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc;

import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOQueryException;
import com.sun.jdo.spi.persistence.support.sqlstore.ValueFetcher;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.QueryValueFetcher;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.DateType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.MathType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.PrimitiveType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.StringType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.Type;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.WrapperClassType;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import com.sun.jdo.spi.persistence.utility.ParameterInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;

public class ParameterTable {
    List names = null;
    List types = null;
    transient List values = null;
    private static final String NULL_ = "null";
    private static final String TRUE_ = "true";
    private static final String FALSE_ = "false";
    private static final String OTHER_ = "other";
    private static final String NOPARAMS_ = "noparams";
    private static final char PARAMKEY_SEPARATOR = '/';
    static final Unbound unbound = new Unbound();
    protected static final ResourceBundle messages = I18NHelper.loadBundle(ParameterTable.class);

    public ParameterTable() {
    }

    public ParameterTable(ParameterTable other) {
        this.names = other.names;
        this.types = other.types;
        this.values = other.values;
    }

    public void add(String name, Type type) {
        this.names.add(name);
        this.types.add(type);
    }

    public void init() {
        this.names = new ArrayList();
        this.types = new ArrayList();
    }

    public void initValueHandling() {
        this.values = new ArrayList(this.names.size());
        int size = this.names.size();
        for (int i = 0; i < size; ++i) {
            this.values.add(unbound);
        }
    }

    public void setValues(Object[] actualParams) {
        if (actualParams != null) {
            for (int i = 0; i < actualParams.length; ++i) {
                Object value = actualParams[i];
                this.defineValueByIndex(i, value);
            }
        }
    }

    public void checkUnboundParams() {
        int size = this.values.size();
        for (int i = 0; i < size; ++i) {
            if (this.values.get(i) != unbound) continue;
            throw new JDOQueryException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.parametertable.checkunboundparams.unboundparam", this.names.get(i)));
        }
    }

    public void setValues(Map actualParams) {
        if (actualParams != null) {
            for (Map.Entry actualParam : actualParams.entrySet()) {
                String name = (String)actualParam.getKey();
                Object value = actualParam.getValue();
                this.defineValueByName(name, value);
            }
        }
    }

    public Object getValueByName(String name) {
        int index = this.names.indexOf(name);
        if (index == -1) {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.parametertable.getvaluebyname.undefined", (String)name));
        }
        return this.getValueByIndex(index);
    }

    public Object getValueByIndex(int index) {
        if (index < 0 || index >= this.values.size()) {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.parametertable.getvaluebyindex.wrongindex", (String)String.valueOf(index)));
        }
        return this.values.get(index);
    }

    public List getValues() {
        return this.values;
    }

    public ValueFetcher getValueFetcher() {
        return new QueryValueFetcher(this.values.toArray(new Object[this.values.size()]));
    }

    public String getKeyForRetrieveDescCache() {
        StringBuffer key = new StringBuffer();
        int size = this.values.size();
        for (int i = 0; i < size; ++i) {
            if (this.isInlineType(this.types.get(i))) {
                return null;
            }
            Object item = this.values.get(i);
            if (item == null) {
                key.append(NULL_);
            } else if (item instanceof Boolean) {
                if (((Boolean)item).booleanValue()) {
                    key.append(TRUE_);
                } else {
                    key.append(FALSE_);
                }
            } else {
                key.append(OTHER_);
            }
            key.append('/');
        }
        if (key.length() == 0) {
            key.append(NOPARAMS_);
        }
        return key.toString();
    }

    public boolean inline(String paramName) {
        int index = this.names.indexOf(paramName);
        Object value = this.values.get(index);
        if (this.isInlineType(this.types.get(index))) {
            return true;
        }
        if (value == null) {
            return true;
        }
        return value instanceof Boolean;
    }

    private boolean isInlineType(Object type) {
        return !(type instanceof StringType) && !(type instanceof PrimitiveType) && !(type instanceof WrapperClassType) && !(type instanceof MathType) && !(type instanceof DateType);
    }

    public Integer getIndexForParamName(String paramName) {
        return new Integer(this.names.indexOf(paramName));
    }

    public ParameterInfo getParameterInfoForParamName(String paramName) {
        return this.getParameterInfoForParamName(paramName, null);
    }

    public ParameterInfo getParameterInfoForParamName(String paramName, String associatedField) {
        int index = this.names.indexOf(paramName);
        Type type = (Type)this.types.get(index);
        return new ParameterInfo(index, type.getEnumType(), associatedField);
    }

    private void defineValueByName(String name, Object value) {
        int index = this.names.indexOf(name);
        if (index == -1) {
            throw new JDOQueryException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.parametertable.definevaluebyname.undefinedparam", (String)name));
        }
        this.defineValueByIndex(index, value);
    }

    private void defineValueByIndex(int index, Object value) {
        if (index < 0) {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.parametertable.definevaluebyindex.wrongindex", (String)String.valueOf(index)));
        }
        if (index >= this.types.size()) {
            throw new JDOQueryException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.parametertable.definevaluebyindex.wrongnumberofargs"));
        }
        Class formalType = ((Type)this.types.get(index)).getJavaClass();
        if (!this.isCompatibleValue(formalType, value)) {
            String actualTypeName = value == null ? "<type of null>" : value.getClass().getName();
            throw new JDOQueryException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.parametertable.definevaluebyindex.typemismatch", (String)actualTypeName, (String)formalType.getName()));
        }
        this.values.set(index, value);
    }

    private boolean isCompatibleValue(Class formalType, Object value) {
        boolean isCompatible = true;
        if (value == null) {
            isCompatible = !formalType.isPrimitive();
        } else {
            Class<?> actualType = value.getClass();
            if (formalType.isPrimitive()) {
                formalType = JavaTypeHelper.getWrapperClass((Class)formalType);
            }
            isCompatible = formalType.isAssignableFrom(actualType);
        }
        return isCompatible;
    }

    static class Unbound {
        Unbound() {
        }
    }
}

