/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.jms.deployment.annotation.handlers;

import com.sun.enterprise.connectors.jms.deployment.annotation.handlers.JMSDestinationDefinitionHandler;
import com.sun.enterprise.deployment.JMSDestinationDefinitionDescriptor;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import javax.jms.JMSDestinationDefinition;
import javax.jms.JMSDestinationDefinitions;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=JMSDestinationDefinitions.class)
public class JMSDestinationDefinitionsHandler
extends AbstractResourceHandler {
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JMSDestinationDefinitionsHandler.class);

    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        JMSDestinationDefinitions defns = (JMSDestinationDefinitions)ainfo.getAnnotation();
        JMSDestinationDefinition[] values = defns.value();
        HashSet<String> duplicates = new HashSet<String>();
        if (values != null && values.length > 0) {
            for (JMSDestinationDefinition defn : values) {
                String defnName = JMSDestinationDefinitionDescriptor.getJavaName((String)defn.name());
                if (duplicates.contains(defnName)) {
                    String localString = localStrings.getLocalString("enterprise.deployment.annotation.handlers.jmsdestinationdefinitionsduplicates", "@JMSDestinationDefinition cannot have multiple definitions with same name : ''{0}''", new Object[]{defnName});
                    throw new IllegalStateException(localString);
                }
                duplicates.add(defnName);
                JMSDestinationDefinitionHandler handler = new JMSDestinationDefinitionHandler();
                handler.processAnnotation(defn, ainfo, rcContexts);
            }
            duplicates.clear();
        }
        return this.getDefaultProcessedResult();
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getEjbAndWebAnnotationTypes();
    }
}

