/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.mapper;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ha.store.api.HashableKey;
import org.shoal.ha.group.GroupMemberEventListener;
import org.shoal.ha.mapper.KeyMapper;

public class DefaultKeyMapper
implements KeyMapper,
GroupMemberEventListener {
    Logger _logger = Logger.getLogger("org.shoal.ha.cache.mapper");
    private String myName;
    private String groupName;
    private ReentrantReadWriteLock.ReadLock rLock;
    private ReentrantReadWriteLock.WriteLock wLock;
    private volatile String[] members = new String[0];
    private volatile String[] previuousAliveAndReadyMembers = new String[0];
    private volatile String[] replicaChoices = new String[0];
    private static final String _EMPTY_REPLICAS = "";

    public DefaultKeyMapper(String myName, String groupName) {
        this.myName = myName;
        this.groupName = groupName;
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        this.rLock = rwLock.readLock();
        this.wLock = rwLock.writeLock();
        this._logger.log(Level.FINE, "DefaultKeyMapper created for: myName: " + myName + "; groupName: " + groupName);
    }

    protected ReentrantReadWriteLock.ReadLock getReadLock() {
        return this.rLock;
    }

    protected ReentrantReadWriteLock.WriteLock getWriteLock() {
        return this.wLock;
    }

    protected String[] getMembers() {
        return this.members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMappedInstance(String groupName, Object key1) {
        int hc = key1.hashCode();
        if (key1 instanceof HashableKey) {
            HashableKey k = (HashableKey)key1;
            int n = hc = k.getHashKey() == null ? hc : k.getHashKey().hashCode();
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "DefaultKeyMapper.getMappedInstance got a HashableKey  key = " + key1 + "; key.hc = " + key1.hashCode() + "; key.getHashKey() = " + ((HashableKey)key1).getHashKey() + "; key.getHashKey().hc = " + (k.getHashKey() == null ? "-" : Integer.valueOf(hc)) + "; Final hc = " + hc);
            }
        }
        try {
            this.rLock.lock();
            String string = this.members.length == 0 ? null : this.members[Math.abs(hc % this.members.length)];
            return string;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getReplicaChoices(String groupName, Object key) {
        int hc = this.getHashCodeForKey(key);
        try {
            this.rLock.lock();
            String string = this.members.length == 0 ? _EMPTY_REPLICAS : this.replicaChoices[Math.abs(hc % this.members.length)];
            return string;
        }
        finally {
            this.rLock.unlock();
        }
    }

    @Override
    public String[] getCurrentMembers() {
        return this.members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findReplicaInstance(String groupName, Object key1, String keyMappingInfo) {
        if (keyMappingInfo != null) {
            return keyMappingInfo.split(":");
        }
        int hc = key1.hashCode();
        if (key1 instanceof HashableKey) {
            HashableKey k = (HashableKey)key1;
            hc = k.getHashKey() == null ? hc : k.getHashKey().hashCode();
        }
        try {
            String[] stringArray;
            this.rLock.lock();
            if (this.previuousAliveAndReadyMembers.length == 0) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = _EMPTY_REPLICAS;
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = this.previuousAliveAndReadyMembers[Math.abs(hc % this.previuousAliveAndReadyMembers.length)];
            }
            String[] stringArray4 = stringArray;
            return stringArray4;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onViewChange(String memberName, Collection<String> readOnlyCurrentAliveAndReadyMembers, Collection<String> readOnlyPreviousAliveAndReadyMembers, boolean isJoinEvent) {
        try {
            this.wLock.lock();
            TreeSet<String> currentMemberSet = new TreeSet<String>();
            currentMemberSet.addAll(readOnlyCurrentAliveAndReadyMembers);
            currentMemberSet.remove(this.myName);
            this.members = currentMemberSet.toArray(new String[0]);
            int memSz = this.members.length;
            this.replicaChoices = new String[memSz];
            if (memSz == 0) {
                this.replicaChoices = new String[]{_EMPTY_REPLICAS};
            } else {
                for (int i = 0; i < memSz; ++i) {
                    StringBuilder sb = new StringBuilder();
                    int index = i;
                    String delim = _EMPTY_REPLICAS;
                    int choiceLimit = 1;
                    for (int j = 0; j < memSz && choiceLimit-- > 0; ++j) {
                        sb.append(delim).append(this.members[index++ % memSz]);
                        delim = ":";
                    }
                    this.replicaChoices[i] = sb.toString();
                }
            }
            TreeSet<String> previousView = new TreeSet<String>();
            previousView.addAll(readOnlyPreviousAliveAndReadyMembers);
            if (!isJoinEvent) {
                previousView.remove(memberName);
            }
            this.previuousAliveAndReadyMembers = previousView.toArray(new String[0]);
            if (this._logger.isLoggable(Level.FINE)) {
                this.printMemberStates("onViewChange (isJoin: " + isJoinEvent + ")");
            }
        }
        finally {
            this.wLock.unlock();
        }
    }

    private int getHashCodeForKey(Object key1) {
        int hc = key1.hashCode();
        if (key1 instanceof HashableKey) {
            HashableKey k = (HashableKey)key1;
            hc = k.getHashKey() == null ? hc : k.getHashKey().hashCode();
        }
        return hc;
    }

    private static int getDigestHashCode(String val) {
        int hc = val.hashCode();
        try {
            String hcStr = "_" + val.hashCode() + "_";
            MessageDigest dig = MessageDigest.getInstance("MD5");
            dig.update(hcStr.getBytes(Charset.defaultCharset()));
            dig.update(val.getBytes(Charset.defaultCharset()));
            dig.update(hcStr.getBytes(Charset.defaultCharset()));
            BigInteger bi = new BigInteger(dig.digest());
            hc = bi.intValue();
            return hc;
        }
        catch (NoSuchAlgorithmException nsaEx) {
            hc = val.hashCode();
            return hc;
        }
    }

    public void printMemberStates(String message) {
        StringBuilder sb = new StringBuilder("DefaultKeyMapper[" + this.myName + "]." + message + " currentView: ");
        String delim = _EMPTY_REPLICAS;
        for (String st : this.members) {
            sb.append(delim).append(st);
            delim = " : ";
        }
        sb.append("; previousView ");
        delim = _EMPTY_REPLICAS;
        for (String st : this.previuousAliveAndReadyMembers) {
            sb.append(delim).append(st);
            delim = " : ";
        }
        sb.append("\n");
        int memSz = this.members.length;
        for (int i = 0; i < memSz; ++i) {
            sb.append("\tReplicaChoices[").append(this.members[i]).append("]: ").append(this.replicaChoices[i]);
            sb.append("\n");
        }
        this._logger.log(Level.FINE, sb.toString());
    }
}

