/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.IOException;
import java.net.URI;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.enterprise.deploy.shared.ModuleType;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.appclient.client.acc.ACCClassLoader;
import org.glassfish.appclient.client.acc.Launchable;
import org.glassfish.appclient.client.acc.UserError;
import org.glassfish.appclient.client.acc.Util;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.xml.sax.SAXException;

public class UndeployedLaunchable
implements Launchable {
    private static final LocalStringsImpl localStrings = new LocalStringsImpl(UndeployedLaunchable.class);
    private final String callerSuppliedMainClassName;
    private ApplicationClientDescriptor acDesc = null;
    private AppClientArchivist archivist = null;
    private final ReadableArchive clientRA;
    private ClassLoader classLoader = null;

    static UndeployedLaunchable newUndeployedLaunchable(ServiceLocator habitat, ReadableArchive ra, String callerSuppliedMainClassName, String callerSuppliedAppName, ClassLoader classLoader) throws IOException, SAXException, UserError {
        ArchivistFactory af = Util.getArchivistFactory();
        Archivist archivist = af.getArchivist(ModuleType.CAR.toString(), classLoader);
        if (archivist == null) {
            throw new UserError(localStrings.get("appclient.invalidArchive", new Object[]{ra.getURI().toASCIIString()}));
        }
        ArchiveType moduleType = archivist.getModuleType();
        if (moduleType != null && moduleType.equals((Object)DOLUtils.carType())) {
            return new UndeployedLaunchable(habitat, ra, (AppClientArchivist)archivist, callerSuppliedMainClassName);
        }
        if (moduleType != null && moduleType.equals((Object)DOLUtils.earType())) {
            Application app = (Application)archivist.open(ra);
            for (ModuleDescriptor md : app.getModules()) {
                boolean useThisClient;
                if (!md.getModuleType().equals((Object)DOLUtils.carType())) continue;
                ApplicationClientDescriptor acd = (ApplicationClientDescriptor)md.getDescriptor();
                String displayName = acd.getDisplayName();
                String appName = acd.getModuleID();
                ArchiveFactory archiveFactory = Util.getArchiveFactory();
                ReadableArchive clientRA = archiveFactory.openArchive(ra.getURI().resolve(md.getArchiveUri()));
                boolean bl = useThisClient = displayName != null && displayName.equals(callerSuppliedAppName) || appName != null && appName.equals(callerSuppliedAppName) || callerSuppliedMainClassName != null && clientRA.exists(UndeployedLaunchable.classToResource(callerSuppliedMainClassName)) || callerSuppliedAppName == null && callerSuppliedMainClassName == null;
                if (useThisClient) {
                    return new UndeployedLaunchable(habitat, clientRA, acd, callerSuppliedMainClassName);
                }
                clientRA.close();
            }
            throw new UserError(localStrings.get("appclient.noMatchingClientInEAR", new Object[]{ra.getURI(), callerSuppliedMainClassName, callerSuppliedAppName}));
        }
        archivist = af.getArchivist(DOLUtils.carType());
        BundleDescriptor tempACD = archivist.open(ra);
        if (tempACD != null && tempACD instanceof ApplicationClientDescriptor) {
            archivist = af.getArchivist(DOLUtils.carType());
            return new UndeployedLaunchable(habitat, ra, (AppClientArchivist)archivist, callerSuppliedMainClassName);
        }
        throw new UserError(localStrings.get("appclient.unexpectedArchive", new Object[]{ra.getURI()}));
    }

    @Override
    public URI getURI() {
        return this.clientRA.getURI();
    }

    @Override
    public String getAnchorDir() {
        return null;
    }

    private static String classToResource(String className) {
        return className.replace('.', '/') + ".class";
    }

    private UndeployedLaunchable(ServiceLocator habitat, ReadableArchive clientRA, String callerSuppliedMainClass) throws IOException {
        this.callerSuppliedMainClassName = callerSuppliedMainClass;
        this.clientRA = clientRA;
    }

    private UndeployedLaunchable(ServiceLocator habitat, ReadableArchive clientRA, ApplicationClientDescriptor acd, String callerSuppliedMainClass) throws IOException {
        this(habitat, clientRA, callerSuppliedMainClass);
        this.acDesc = acd;
    }

    private UndeployedLaunchable(ServiceLocator habitat, ReadableArchive clientRA, AppClientArchivist archivist, String callerSuppliedMainClass) throws IOException {
        this(habitat, clientRA, callerSuppliedMainClass);
        this.archivist = this.completeInit(archivist);
    }

    @Override
    public Class getMainClass() throws ClassNotFoundException {
        try {
            String mainClassName = this.mainClassNameToLaunch();
            return Class.forName(mainClassName, true, this.getClassLoader());
        }
        catch (Exception e) {
            throw new ClassNotFoundException("<mainclass>");
        }
    }

    private ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }
        return this.classLoader;
    }

    private String mainClassNameToLaunch() throws IOException {
        return this.callerSuppliedMainClassName != null ? this.callerSuppliedMainClassName : this.extractMainClassFromArchive(this.clientRA);
    }

    private String extractMainClassFromArchive(ReadableArchive clientRA) throws IOException {
        Manifest mf = clientRA.getManifest();
        if (mf == null) {
            return null;
        }
        return mf.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
    }

    @Override
    public ApplicationClientDescriptor getDescriptor(final URLClassLoader loader) throws IOException, SAXException {
        this.classLoader = loader;
        if (this.acDesc == null) {
            AppClientArchivist _archivist = this.getArchivist(AccessController.doPrivileged(new PrivilegedAction<ACCClassLoader>(){

                @Override
                public ACCClassLoader run() {
                    return new ACCClassLoader(loader.getURLs(), loader.getParent());
                }
            }));
            _archivist.setAnnotationProcessingRequested(true);
            this.acDesc = (ApplicationClientDescriptor)_archivist.open(this.clientRA);
            Application.createVirtualApplication(null, (ModuleDescriptor)this.acDesc.getModuleDescriptor());
            this.acDesc.getApplication().setAppName(this.getDefaultApplicationName(this.clientRA));
        }
        return this.acDesc;
    }

    public String getDefaultApplicationName(ReadableArchive archive) {
        String appName = archive.getName();
        int lastDot = appName.lastIndexOf(46);
        if (lastDot != -1 && (appName.substring(lastDot).equalsIgnoreCase(".ear") || appName.substring(lastDot).equalsIgnoreCase(".jar"))) {
            appName = appName.substring(0, lastDot);
        }
        return appName;
    }

    private AppClientArchivist completeInit(AppClientArchivist arch) {
        arch.setDescriptor((BundleDescriptor)this.acDesc);
        arch.setAnnotationProcessingRequested(true);
        return arch;
    }

    private AppClientArchivist getArchivist(ClassLoader classLoader) throws IOException {
        if (this.archivist == null) {
            ArchivistFactory af = Util.getArchivistFactory();
            this.archivist = this.completeInit((AppClientArchivist)af.getArchivist(ModuleType.CAR.toString()));
        }
        this.archivist.setClassLoader(classLoader);
        return this.archivist;
    }

    @Override
    public void validateDescriptor() {
        try {
            this.getArchivist(this.classLoader).validate(this.classLoader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

