/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.context.impl;

import com.ibm.jbatch.container.navigator.ModelNavigator;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.jbatch.jsl.model.JSLProperties;
import com.ibm.jbatch.jsl.model.ObjectFactory;
import com.ibm.jbatch.jsl.model.Property;
import java.util.Properties;
import java.util.logging.Logger;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.context.JobContext;

public class JobContextImpl
implements JobContext {
    private static final String sourceClass = JobContextImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private BatchStatus batchStatus = null;
    private String exitStatus = null;
    private Object transientUserData = null;
    private ModelNavigator<JSLJob> navigator = null;
    private String id;
    private Properties properties = new Properties();
    private long executionId;
    private long instanceId;
    protected String restartOn;
    private static final boolean cloneContextProperties = Boolean.getBoolean("clone.context.properties");
    public static final String TOP_LEVEL_JOB_NAME_PROP = "com.ibm.jbatch.container.context.impl.JobContextImpl#getJobName";
    public static final String TOP_LEVEL_INSTANCE_ID_PROP = "com.ibm.jbatch.container.context.impl.JobContextImpl#getInstanceId";
    public static final String TOP_LEVEL_EXECUTION_ID_PROP = "com.ibm.jbatch.container.context.impl.JobContextImpl#getExecutionId";

    public ModelNavigator<JSLJob> getNavigator() {
        return this.navigator;
    }

    public JobContextImpl(ModelNavigator<JSLJob> navigator, JSLProperties jslProperties) {
        this.navigator = navigator;
        this.id = navigator.getRootModelElement().getId();
        this.batchStatus = BatchStatus.STARTING;
        this.properties = this.convertJSProperties(jslProperties);
    }

    private Properties convertJSProperties(JSLProperties jslProperties) {
        Properties jobProperties = new Properties();
        if (jslProperties != null) {
            for (Property property : jslProperties.getPropertyList()) {
                jobProperties.setProperty(property.getName(), property.getValue());
            }
        }
        return jobProperties;
    }

    public String getExitStatus() {
        return this.exitStatus;
    }

    public void setExitStatus(String exitStatus) {
        logger.fine("Setting exitStatus = " + exitStatus);
        this.exitStatus = exitStatus;
    }

    public String getJobName() {
        if (this.properties.containsKey(TOP_LEVEL_EXECUTION_ID_PROP)) {
            return this.properties.getProperty(TOP_LEVEL_JOB_NAME_PROP);
        }
        return this.id;
    }

    public BatchStatus getBatchStatus() {
        return this.batchStatus;
    }

    public void setBatchStatus(BatchStatus batchStatus) {
        this.batchStatus = batchStatus;
    }

    public Object getTransientUserData() {
        return this.transientUserData;
    }

    public Properties getJSLProperties() {
        return this.properties;
    }

    public Properties getProperties() {
        if (cloneContextProperties) {
            logger.fine("Cloning job context properties");
            return (Properties)this.properties.clone();
        }
        logger.fine("Returing ref (non-clone) to job context properties");
        return this.properties;
    }

    public void setTransientUserData(Object data) {
        this.transientUserData = data;
    }

    public long getExecutionId() {
        if (this.properties.containsKey(TOP_LEVEL_EXECUTION_ID_PROP)) {
            return Long.parseLong(this.properties.getProperty(TOP_LEVEL_EXECUTION_ID_PROP));
        }
        return this.executionId;
    }

    public long getInstanceId() {
        if (this.properties.containsKey(TOP_LEVEL_INSTANCE_ID_PROP)) {
            return Long.parseLong(this.properties.getProperty(TOP_LEVEL_INSTANCE_ID_PROP));
        }
        return this.instanceId;
    }

    public void setExecutionId(long executionId) {
        this.executionId = executionId;
    }

    public void setInstanceId(long instanceId) {
        this.instanceId = instanceId;
    }

    public String getRestartOn() {
        return this.restartOn;
    }

    public void setRestartOn(String restartOn) {
        logger.fine("Setting restartOn = " + restartOn);
        this.restartOn = restartOn;
    }

    public JSLProperties addTopLevelContextProperties(JSLProperties properties) {
        ObjectFactory jslFactory = new ObjectFactory();
        Property jobName = jslFactory.createProperty();
        jobName.setName(TOP_LEVEL_JOB_NAME_PROP);
        jobName.setValue(this.getJobName());
        properties.getPropertyList().add(jobName);
        Property instanceId = jslFactory.createProperty();
        instanceId.setName(TOP_LEVEL_INSTANCE_ID_PROP);
        instanceId.setValue(String.valueOf(this.getInstanceId()));
        properties.getPropertyList().add(instanceId);
        Property executionId = jslFactory.createProperty();
        executionId.setName(TOP_LEVEL_EXECUTION_ID_PROP);
        executionId.setValue(String.valueOf(this.getExecutionId()));
        properties.getPropertyList().add(executionId);
        return properties;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("batchStatus = " + this.batchStatus);
        buf.append(" , exitStatus = " + this.exitStatus);
        buf.append(" , id = " + this.id);
        buf.append(" , executionId = " + this.executionId);
        buf.append(" , instanceId = " + this.instanceId);
        buf.append(" , restartOn = " + this.restartOn);
        return buf.toString();
    }
}

