/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.resolver;

import com.sun.corba.ee.impl.ior.ObjectIdImpl;
import com.sun.corba.ee.impl.ior.ObjectKeyImpl;
import com.sun.corba.ee.impl.misc.ORBUtility;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.IORFactories;
import com.sun.corba.ee.spi.ior.IORTemplate;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.ior.iiop.IIOPAddress;
import com.sun.corba.ee.spi.ior.iiop.IIOPFactories;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.resolver.Resolver;
import java.util.HashSet;
import java.util.Set;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.RemarshalException;

public class BootstrapResolverImpl
implements Resolver {
    private Delegate bootstrapDelegate;
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;

    public BootstrapResolverImpl(ORB orb, String host, int port) {
        byte[] initialKey = "INIT".getBytes();
        ObjectKeyImpl okey = new ObjectKeyImpl(orb.getWireObjectKeyTemplate(), new ObjectIdImpl(initialKey));
        IIOPAddress addr = IIOPFactories.makeIIOPAddress(host, port);
        IIOPProfileTemplate ptemp = IIOPFactories.makeIIOPProfileTemplate(orb, GIOPVersion.V1_0, addr);
        IORTemplate iortemp = IORFactories.makeIORTemplate(okey.getTemplate());
        iortemp.add(ptemp);
        IOR initialIOR = iortemp.makeIOR(orb, "", okey.getId());
        this.bootstrapDelegate = ORBUtility.makeClientDelegate(initialIOR);
    }

    private InputStream invoke(String operationName, String parameter) {
        boolean remarshal = true;
        InputStream inStream = null;
        while (remarshal) {
            Object objref = null;
            remarshal = false;
            OutputStream os = this.bootstrapDelegate.request(objref, operationName, true);
            if (parameter != null) {
                os.write_string(parameter);
            }
            try {
                inStream = this.bootstrapDelegate.invoke(objref, os);
            }
            catch (ApplicationException e) {
                throw wrapper.bootstrapApplicationException((Exception)((java.lang.Object)e));
            }
            catch (RemarshalException e) {
                wrapper.bootstrapRemarshalException(e);
                remarshal = true;
            }
        }
        return inStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object resolve(String identifier) {
        InputStream inStream = null;
        Object result = null;
        try {
            inStream = this.invoke("get", identifier);
            result = inStream.read_Object();
        }
        finally {
            this.bootstrapDelegate.releaseReply(null, inStream);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> list() {
        InputStream inStream = null;
        HashSet<String> result = new HashSet<String>();
        try {
            inStream = this.invoke("list", null);
            int count = inStream.read_long();
            for (int i = 0; i < count; ++i) {
                result.add(inStream.read_string());
            }
        }
        finally {
            this.bootstrapDelegate.releaseReply(null, inStream);
        }
        return result;
    }
}

