/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.enterprise.iiop.security.SecurityContextUtil;
import com.sun.enterprise.iiop.security.SecurityMechanismSelector;
import java.lang.ref.WeakReference;
import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.glassfish.gms.bootstrap.GMSAdapterService;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;

public class Lookups {
    @Inject
    private Provider<SecurityMechanismSelector> securityMechanismSelectorProvider;
    @Inject
    private Provider<GlassFishORBHelper> glassFishORBHelperProvider;
    @Inject
    private Provider<SecurityContextUtil> securityContextUtilProvider;
    @Inject
    private Provider<GMSAdapterService> gmsAdapterServiceProvider;
    private static final ServiceLocator habitat = Globals.getDefaultHabitat();
    private static Lookups singleton;
    private static WeakReference<SecurityMechanismSelector> sms;
    private static WeakReference<GlassFishORBHelper> orb;
    private static WeakReference<SecurityContextUtil> sc;

    private Lookups() {
    }

    private static synchronized boolean checkSingleton() {
        if (singleton == null && habitat != null) {
            singleton = (Lookups)habitat.create(Lookups.class);
            habitat.inject((Object)singleton);
            habitat.postConstruct((Object)singleton);
        }
        return singleton != null;
    }

    static SecurityMechanismSelector getSecurityMechanismSelector() {
        if (sms.get() != null) {
            return (SecurityMechanismSelector)sms.get();
        }
        return Lookups._getSecurityMechanismSelector();
    }

    private static synchronized SecurityMechanismSelector _getSecurityMechanismSelector() {
        if (sms.get() == null && Lookups.checkSingleton()) {
            sms = new WeakReference<Object>(Lookups.singleton.securityMechanismSelectorProvider.get());
        }
        return (SecurityMechanismSelector)sms.get();
    }

    static GlassFishORBHelper getGlassFishORBHelper() {
        if (orb.get() != null) {
            return (GlassFishORBHelper)orb.get();
        }
        return Lookups._getGlassFishORBHelper();
    }

    private static synchronized GlassFishORBHelper _getGlassFishORBHelper() {
        if (orb.get() == null && Lookups.checkSingleton()) {
            orb = new WeakReference<Object>(Lookups.singleton.glassFishORBHelperProvider.get());
        }
        return (GlassFishORBHelper)orb.get();
    }

    static SecurityContextUtil getSecurityContextUtil() {
        if (sc.get() != null) {
            return (SecurityContextUtil)sc.get();
        }
        return Lookups._getSecurityContextUtil();
    }

    private static synchronized SecurityContextUtil _getSecurityContextUtil() {
        if (sc.get() == null && Lookups.checkSingleton()) {
            sc = new WeakReference<Object>(Lookups.singleton.securityContextUtilProvider.get());
        }
        return (SecurityContextUtil)sc.get();
    }

    static GMSAdapterService getGMSAdapterService() {
        return Lookups.checkSingleton() ? (GMSAdapterService)Lookups.singleton.gmsAdapterServiceProvider.get() : null;
    }

    static {
        sms = new WeakReference<Object>(null);
        orb = new WeakReference<Object>(null);
        sc = new WeakReference<Object>(null);
    }
}

