/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.deliverable.cts.deploy;

import com.sun.ts.lib.deliverable.cts.deploy.DMProps;
import com.sun.ts.lib.deliverable.cts.deploy.OperationStatus;
import com.sun.ts.lib.deliverable.cts.deploy.ProgressHandler;
import com.sun.ts.lib.util.TestUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;

public class DeployTestUtil {
    public static final String DEPLOYMENT_MANIFEST_ENTRY_NAME = "J2EE-DeploymentFactory-Implementation-Class";
    public static final String FILE_ARCHIVE = "FILE";
    public static final String STREAM_ARCHIVE = "STREAM";
    public static final String APPLICATION_ARCHIVE = "APPLICATION";
    public static final String STAND_ALONE_ARCHIVE = "STAND_ALONE";
    private DeploymentManager dm = null;
    private DMProps dmp;
    private DeploymentManager disconnectedDM;

    public DeployTestUtil(DMProps dmprops) throws Exception {
        this.dmp = dmprops;
        this.loadDMFactories();
    }

    public DeploymentManager getDeploymentManager() throws DeploymentManagerCreationException {
        if (this.dm == null) {
            DeploymentFactoryManager dfmanager = DeploymentFactoryManager.getInstance();
            this.dm = dfmanager.getDeploymentManager(this.dmp.getURI(), this.dmp.getUname(), this.dmp.getPasswd());
            TestUtil.logHarnessDebug((String)("$$$$$$$$$$$$$$$[" + this.dmp.getUname() + ", " + this.dmp.getPasswd() + "]"));
            TestUtil.logHarness((String)"amd Obtained FRESH DeploymentManager");
        } else {
            TestUtil.logHarness((String)"amd Obtained CACHED DeploymentManager");
        }
        System.out.println(this.dm);
        return this.dm;
    }

    public DeploymentManager getDisconnectedDeploymentManager() throws DeploymentManagerCreationException {
        if (this.disconnectedDM == null) {
            TestUtil.logHarness((String)"DeployTestUtil.getDeploymentManager called");
            DeploymentFactoryManager dfmanager = DeploymentFactoryManager.getInstance();
            this.disconnectedDM = dfmanager.getDisconnectedDeploymentManager(this.dmp.getURI());
        }
        return this.disconnectedDM;
    }

    public Vector getDeploymentFactoryClassNames() throws Exception {
        File deployPlatformJarFile;
        try {
            deployPlatformJarFile = new File(this.dmp.getJarFile());
        }
        catch (Exception e) {
            throw new Exception("Could not contruct file object: " + this.dmp.getJarFile());
        }
        TestUtil.logHarness((String)("loadDeploymentFactories loading factories from file:" + deployPlatformJarFile.getName()));
        Manifest mf = new JarFile(deployPlatformJarFile).getManifest();
        String dfClassNames = mf.getMainAttributes().getValue(DEPLOYMENT_MANIFEST_ENTRY_NAME);
        if (dfClassNames == null) {
            throw new Exception("Invalid Jar File: Jar file does not have entry for Deployment factories");
        }
        StringTokenizer st = new StringTokenizer(dfClassNames, " ");
        Vector<String> classNames = new Vector<String>();
        while (st.hasMoreTokens()) {
            classNames.add(st.nextToken());
        }
        return classNames;
    }

    private void loadDMFactories() throws Exception {
        TestUtil.logHarness((String)"DeployTestUtil.loadDMFactories called");
        TestUtil.logHarness((String)("DeployTestUtil.loadDMFactories using jarfile: " + this.dmp.getJarFile()));
        this.loadDeploymentFactories();
    }

    private void loadDeploymentFactories() throws Exception {
        File deployPlatformJarFile;
        try {
            deployPlatformJarFile = new File(this.dmp.getJarFile());
        }
        catch (Exception e) {
            throw new Exception("Could not contruct file object: " + this.dmp.getJarFile());
        }
        TestUtil.logHarness((String)("loadDeploymentFactories loading factories from file:" + deployPlatformJarFile.getName()));
        Manifest mf = new JarFile(deployPlatformJarFile).getManifest();
        TestUtil.logHarness((String)"Looking for manifest entry: J2EE-DeploymentFactory-Implementation-Class");
        String dfClassNames = mf.getMainAttributes().getValue(DEPLOYMENT_MANIFEST_ENTRY_NAME);
        if (dfClassNames == null) {
            throw new Exception("Invalid Jar File: No manifest entry.");
        }
        StringTokenizer st = new StringTokenizer(dfClassNames, " ");
        Vector<String> classNames = new Vector<String>();
        while (st.hasMoreTokens()) {
            classNames.add(st.nextToken());
        }
        try {
            URL[] urls = new URL[]{deployPlatformJarFile.toURL()};
            URLClassLoader urlClassLoader = new URLClassLoader(urls, this.getClass().getClassLoader());
            TestUtil.logHarness((String)("loadDeploymentFactories about to load classes :" + dfClassNames));
            Thread.currentThread().setContextClassLoader(urlClassLoader);
            for (int classNameIndex = 0; classNameIndex < classNames.size(); ++classNameIndex) {
                Class<?> factory = null;
                DeploymentFactory df = null;
                try {
                    factory = urlClassLoader.loadClass((String)classNames.elementAt(classNameIndex));
                    df = (DeploymentFactory)factory.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!(df instanceof DeploymentFactory)) {
                    throw new Exception("Does not implement DeploymentFactory");
                }
                DeploymentFactoryManager.getInstance().registerDeploymentFactory(df);
                TestUtil.logMsg((String)("Registered DeploymentFactory: " + df.getDisplayName()));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception("Could not load DeploymentFactory class: " + ex.getMessage());
        }
    }

    public void releaseDeploymentManager() {
        if (this.dm != null) {
            TestUtil.logHarness((String)"amd Releasing DeploymentManager amd");
            this.dm.release();
        }
        if (this.disconnectedDM != null) {
            TestUtil.logHarness((String)"amd Releasing DISCONNECTED DeploymentManager amd");
            this.disconnectedDM.release();
        }
        TestUtil.logHarness((String)" amd Released DeploymentManager amd ");
    }

    public boolean checkIfModuleExists(TargetModuleID moduleToCheck, TargetModuleID[] modulesList) {
        boolean exists = false;
        if (moduleToCheck == null) {
            return exists;
        }
        int numMods = modulesList == null ? 0 : modulesList.length;
        for (int modIndex = 0; modIndex < numMods; ++modIndex) {
            if (!moduleToCheck.getModuleID().equals(modulesList[modIndex].getModuleID()) || !moduleToCheck.getTarget().getName().equals(modulesList[modIndex].getTarget().getName())) continue;
            exists = true;
            break;
        }
        return exists;
    }

    public TargetModuleID distributeModuleArchive(Target[] targets, File moduleArchive, File deploymentPlan) throws Exception {
        DeploymentManager dm = this.getDeploymentManager();
        ProgressHandler progressHandler = new ProgressHandler();
        ProgressObject progress = dm.distribute(targets, moduleArchive, deploymentPlan);
        progress.addProgressListener((ProgressListener)progressHandler);
        progressHandler.start();
        progressHandler.join();
        StateType completionState = progressHandler.getCompletionState();
        if (completionState.getValue() != StateType.COMPLETED.getValue()) {
            return null;
        }
        TargetModuleID[] resultModuleIDs = progress.getResultTargetModuleIDs();
        if (resultModuleIDs.length < 1) {
            return null;
        }
        return resultModuleIDs[0];
    }

    public TargetModuleID distributeModuleStream(Target[] targets, ModuleType moduleType, InputStream moduleArchive, InputStream deploymentPlan, boolean oneDotFiveApi) throws Exception {
        String apiType = oneDotFiveApi ? "1.5 API" : "deprecated API";
        TestUtil.logMsg((String)("Calling distribute(): Using " + apiType));
        DeploymentManager dm = this.getDeploymentManager();
        ProgressHandler progressHandler = new ProgressHandler();
        ProgressObject progress = oneDotFiveApi ? dm.distribute(targets, moduleType, moduleArchive, deploymentPlan) : dm.distribute(targets, moduleArchive, deploymentPlan);
        progress.addProgressListener((ProgressListener)progressHandler);
        progressHandler.start();
        progressHandler.join();
        StateType completionState = progressHandler.getCompletionState();
        if (completionState.getValue() != StateType.COMPLETED.getValue()) {
            return null;
        }
        TargetModuleID[] resultModuleIDs = progress.getResultTargetModuleIDs();
        if (resultModuleIDs.length < 1) {
            return null;
        }
        return resultModuleIDs[0];
    }

    public TargetModuleID startModule(TargetModuleID moduleToStart) throws Exception {
        DeploymentManager dm = this.getDeploymentManager();
        ProgressHandler progressHandler = new ProgressHandler();
        ProgressObject progress = dm.start(new TargetModuleID[]{moduleToStart});
        progress.addProgressListener((ProgressListener)progressHandler);
        progressHandler.start();
        progressHandler.join();
        StateType completionState = progressHandler.getCompletionState();
        if (completionState.getValue() != StateType.COMPLETED.getValue()) {
            return null;
        }
        TargetModuleID[] resultModuleIDs = progress.getResultTargetModuleIDs();
        if (resultModuleIDs.length < 1) {
            return null;
        }
        return resultModuleIDs[0];
    }

    public TargetModuleID stopModule(TargetModuleID moduleToStop) throws Exception {
        DeploymentManager dm = this.getDeploymentManager();
        ProgressHandler progressHandler = new ProgressHandler();
        ProgressObject progress = dm.stop(new TargetModuleID[]{moduleToStop});
        progress.addProgressListener((ProgressListener)progressHandler);
        progressHandler.start();
        progressHandler.join();
        StateType completionState = progressHandler.getCompletionState();
        if (completionState.getValue() != StateType.COMPLETED.getValue()) {
            return null;
        }
        TargetModuleID[] resultModuleIDs = progress.getResultTargetModuleIDs();
        if (resultModuleIDs.length < 1) {
            return null;
        }
        return resultModuleIDs[0];
    }

    public TargetModuleID undeployModule(TargetModuleID moduleToUndeploy) throws Exception {
        DeploymentManager dm = this.getDeploymentManager();
        ProgressHandler progressHandler = new ProgressHandler();
        ProgressObject progress = dm.undeploy(new TargetModuleID[]{moduleToUndeploy});
        progress.addProgressListener((ProgressListener)progressHandler);
        progressHandler.start();
        progressHandler.join();
        StateType completionState = progressHandler.getCompletionState();
        if (completionState.getValue() != StateType.COMPLETED.getValue()) {
            return null;
        }
        TargetModuleID[] resultModuleIDs = progress.getResultTargetModuleIDs();
        if (resultModuleIDs.length < 1) {
            return null;
        }
        return resultModuleIDs[0];
    }

    public TargetModuleID redeployModuleArchive(TargetModuleID[] targetModuleIds, File moduleArchive, File deploymentPlan) throws Exception {
        DeploymentManager dm = this.getDeploymentManager();
        ProgressHandler progressHandler = new ProgressHandler();
        ProgressObject progress = dm.redeploy(targetModuleIds, moduleArchive, deploymentPlan);
        progress.addProgressListener((ProgressListener)progressHandler);
        progressHandler.start();
        progressHandler.join();
        StateType completionState = progressHandler.getCompletionState();
        if (completionState.getValue() != StateType.COMPLETED.getValue()) {
            return null;
        }
        TargetModuleID[] resultModuleIDs = progress.getResultTargetModuleIDs();
        if (resultModuleIDs.length < 1) {
            return null;
        }
        return resultModuleIDs[0];
    }

    public TargetModuleID redeployModuleStream(TargetModuleID[] targetModuleIds, InputStream moduleArchive, InputStream deploymentPlan) throws Exception {
        DeploymentManager dm = this.getDeploymentManager();
        ProgressHandler progressHandler = new ProgressHandler();
        ProgressObject progress = dm.redeploy(targetModuleIds, moduleArchive, deploymentPlan);
        progress.addProgressListener((ProgressListener)progressHandler);
        progressHandler.start();
        progressHandler.join();
        StateType completionState = progressHandler.getCompletionState();
        if (completionState.getValue() != StateType.COMPLETED.getValue()) {
            return null;
        }
        TargetModuleID[] resultModuleIDs = progress.getResultTargetModuleIDs();
        if (resultModuleIDs.length < 1) {
            return null;
        }
        return resultModuleIDs[0];
    }

    public boolean testDistributeModule(ModuleType moduleType, File moduleArchive, File deploymentPlan, String archiveType, boolean oneDotFiveApi) throws Exception {
        DeploymentManager dm = this.getDeploymentManager();
        Target[] targets = dm.getTargets();
        if (targets.length == 0) {
            return false;
        }
        Target targetToDeploy = targets[0];
        TargetModuleID distributedModuleID = null;
        TargetModuleID[] moduleIDsBeforeDistribute = dm.getAvailableModules(moduleType, new Target[]{targetToDeploy});
        if (archiveType.equals(FILE_ARCHIVE)) {
            distributedModuleID = this.distributeModuleArchive(new Target[]{targetToDeploy}, moduleArchive, deploymentPlan);
        } else {
            FileInputStream moduleStream = moduleArchive == null ? null : new FileInputStream(moduleArchive);
            FileInputStream planStream = deploymentPlan == null ? null : new FileInputStream(deploymentPlan);
            distributedModuleID = this.distributeModuleStream(new Target[]{targetToDeploy}, moduleType, moduleStream, planStream, oneDotFiveApi);
        }
        if (distributedModuleID == null) {
            return false;
        }
        if (!distributedModuleID.getTarget().getName().equals(targetToDeploy.getName())) {
            return false;
        }
        TargetModuleID[] moduleIDsAfterDistribute = dm.getAvailableModules(moduleType, new Target[]{targetToDeploy});
        boolean moduleExistsBeforeDistribute = this.checkIfModuleExists(distributedModuleID, moduleIDsBeforeDistribute);
        boolean moduleExistsAfterDistribute = this.checkIfModuleExists(distributedModuleID, moduleIDsAfterDistribute);
        this.undeployModule(distributedModuleID);
        return !moduleExistsBeforeDistribute && moduleExistsAfterDistribute;
    }

    public boolean testStartModule(ModuleType moduleType, File moduleArchive, File deploymentPlan, String archiveType) throws Exception {
        DeploymentManager dm = this.getDeploymentManager();
        Target[] targets = dm.getTargets();
        if (targets.length == 0) {
            return false;
        }
        Target targetToDeploy = targets[0];
        TargetModuleID distributedModuleID = null;
        TargetModuleID[] moduleIDsBeforeDistribute = dm.getAvailableModules(moduleType, new Target[]{targetToDeploy});
        distributedModuleID = archiveType.equals(FILE_ARCHIVE) ? this.distributeModuleArchive(new Target[]{targetToDeploy}, moduleArchive, deploymentPlan) : this.distributeModuleStream(new Target[]{targetToDeploy}, moduleType, new FileInputStream(moduleArchive), new FileInputStream(deploymentPlan), true);
        if (distributedModuleID == null) {
            return false;
        }
        if (!distributedModuleID.getTarget().getName().equals(targetToDeploy.getName())) {
            return false;
        }
        TargetModuleID[] moduleIDsAfterDistribute = dm.getAvailableModules(moduleType, new Target[]{targetToDeploy});
        boolean moduleExistsBeforeDistribute = this.checkIfModuleExists(distributedModuleID, moduleIDsBeforeDistribute);
        boolean moduleExistsAfterDistribute = this.checkIfModuleExists(distributedModuleID, moduleIDsAfterDistribute);
        if (moduleExistsBeforeDistribute || !moduleExistsAfterDistribute) {
            return false;
        }
        TargetModuleID startedModuleID = null;
        startedModuleID = this.startModule(distributedModuleID);
        if (startedModuleID == null) {
            return false;
        }
        if (!startedModuleID.getModuleID().equals(distributedModuleID.getModuleID())) {
            return false;
        }
        TargetModuleID[] runningModules = dm.getRunningModules(moduleType, new Target[]{targetToDeploy});
        boolean result = false;
        if (this.checkIfModuleExists(startedModuleID, runningModules)) {
            result = true;
        }
        this.stopModule(startedModuleID);
        this.undeployModule(startedModuleID);
        return result;
    }

    public boolean testStopModule(ModuleType moduleType, File moduleArchive, File deploymentPlan, String archiveType) throws Exception {
        DeploymentManager dm = this.getDeploymentManager();
        Target[] targets = dm.getTargets();
        if (targets.length == 0) {
            return false;
        }
        Target targetToDeploy = targets[0];
        TargetModuleID distributedModuleID = null;
        TargetModuleID[] moduleIDsBeforeDistribute = dm.getAvailableModules(moduleType, new Target[]{targetToDeploy});
        distributedModuleID = archiveType.equals(FILE_ARCHIVE) ? this.distributeModuleArchive(new Target[]{targetToDeploy}, moduleArchive, deploymentPlan) : this.distributeModuleStream(new Target[]{targetToDeploy}, moduleType, new FileInputStream(moduleArchive), new FileInputStream(deploymentPlan), true);
        if (distributedModuleID == null) {
            return false;
        }
        if (!distributedModuleID.getTarget().getName().equals(targetToDeploy.getName())) {
            return false;
        }
        TargetModuleID[] moduleIDsAfterDistribute = dm.getAvailableModules(moduleType, new Target[]{targetToDeploy});
        boolean moduleExistsBeforeDistribute = this.checkIfModuleExists(distributedModuleID, moduleIDsBeforeDistribute);
        boolean moduleExistsAfterDistribute = this.checkIfModuleExists(distributedModuleID, moduleIDsAfterDistribute);
        if (moduleExistsBeforeDistribute || !moduleExistsAfterDistribute) {
            return false;
        }
        TargetModuleID startedModuleID = null;
        startedModuleID = this.startModule(distributedModuleID);
        if (startedModuleID == null) {
            return false;
        }
        if (!startedModuleID.getModuleID().equals(distributedModuleID.getModuleID())) {
            return false;
        }
        TargetModuleID[] runningModules = dm.getRunningModules(moduleType, new Target[]{targetToDeploy});
        if (!this.checkIfModuleExists(startedModuleID, runningModules)) {
            return false;
        }
        TargetModuleID stoppedModuleID = null;
        stoppedModuleID = this.stopModule(startedModuleID);
        if (stoppedModuleID == null) {
            return false;
        }
        if (!startedModuleID.getModuleID().equals(stoppedModuleID.getModuleID())) {
            return false;
        }
        boolean modExistsInRunningMods = this.checkIfModuleExists(stoppedModuleID, dm.getRunningModules(moduleType, new Target[]{targetToDeploy}));
        boolean modExistsInNonRunningMods = this.checkIfModuleExists(stoppedModuleID, dm.getNonRunningModules(moduleType, new Target[]{targetToDeploy}));
        this.undeployModule(stoppedModuleID);
        return !modExistsInRunningMods && modExistsInNonRunningMods;
    }

    public boolean testRedeployModule(ModuleType moduleType, File moduleArchive, File deploymentPlan, String archiveType) throws Exception {
        DeploymentManager dm = this.getDeploymentManager();
        Target[] targets = dm.getTargets();
        if (targets.length == 0) {
            return false;
        }
        Target targetToDeploy = targets[0];
        TargetModuleID distributedModuleID = null;
        TargetModuleID[] moduleIDsBeforeDistribute = dm.getAvailableModules(moduleType, new Target[]{targetToDeploy});
        distributedModuleID = archiveType.equals(FILE_ARCHIVE) ? this.distributeModuleArchive(new Target[]{targetToDeploy}, moduleArchive, deploymentPlan) : this.distributeModuleStream(new Target[]{targetToDeploy}, moduleType, new FileInputStream(moduleArchive), new FileInputStream(deploymentPlan), true);
        if (distributedModuleID == null) {
            return false;
        }
        if (!distributedModuleID.getTarget().getName().equals(targetToDeploy.getName())) {
            return false;
        }
        TargetModuleID[] moduleIDsAfterDistribute = dm.getAvailableModules(moduleType, new Target[]{targetToDeploy});
        boolean moduleExistsBeforeDistribute = this.checkIfModuleExists(distributedModuleID, moduleIDsBeforeDistribute);
        boolean moduleExistsAfterDistribute = this.checkIfModuleExists(distributedModuleID, moduleIDsAfterDistribute);
        if (moduleExistsBeforeDistribute || !moduleExistsAfterDistribute) {
            return false;
        }
        TargetModuleID startedModuleID = null;
        startedModuleID = this.startModule(distributedModuleID);
        if (startedModuleID == null) {
            return false;
        }
        if (!startedModuleID.getModuleID().equals(distributedModuleID.getModuleID())) {
            return false;
        }
        TargetModuleID[] runningModules = dm.getRunningModules(moduleType, new Target[]{targetToDeploy});
        if (!this.checkIfModuleExists(startedModuleID, runningModules)) {
            return false;
        }
        TargetModuleID redeployedModuleID = null;
        redeployedModuleID = archiveType.equals(FILE_ARCHIVE) ? this.redeployModuleArchive(new TargetModuleID[]{startedModuleID}, moduleArchive, deploymentPlan) : this.redeployModuleStream(new TargetModuleID[]{startedModuleID}, new FileInputStream(moduleArchive), new FileInputStream(deploymentPlan));
        if (redeployedModuleID == null) {
            return false;
        }
        if (!startedModuleID.getModuleID().equals(redeployedModuleID.getModuleID())) {
            return false;
        }
        TargetModuleID[] runningModulesAfterRedeploy = dm.getRunningModules(moduleType, new Target[]{targetToDeploy});
        boolean result = false;
        if (this.checkIfModuleExists(redeployedModuleID, runningModulesAfterRedeploy)) {
            result = true;
        }
        this.stopModule(redeployedModuleID);
        this.undeployModule(redeployedModuleID);
        return result;
    }

    public boolean testUndeployModule(ModuleType moduleType, File moduleArchive, File deploymentPlan, String archiveType) throws Exception {
        DeploymentManager dm = this.getDeploymentManager();
        Target[] targets = dm.getTargets();
        if (targets.length == 0) {
            return false;
        }
        Target targetToDeploy = targets[0];
        TargetModuleID distributedModuleID = null;
        TargetModuleID[] moduleIDsBeforeDistribute = dm.getAvailableModules(moduleType, new Target[]{targetToDeploy});
        distributedModuleID = archiveType.equals(FILE_ARCHIVE) ? this.distributeModuleArchive(new Target[]{targetToDeploy}, moduleArchive, deploymentPlan) : this.distributeModuleStream(new Target[]{targetToDeploy}, moduleType, new FileInputStream(moduleArchive), new FileInputStream(deploymentPlan), true);
        if (distributedModuleID == null) {
            return false;
        }
        if (!distributedModuleID.getTarget().getName().equals(targetToDeploy.getName())) {
            return false;
        }
        TargetModuleID[] moduleIDsAfterDistribute = dm.getAvailableModules(moduleType, new Target[]{targetToDeploy});
        boolean moduleExistsBeforeDistribute = this.checkIfModuleExists(distributedModuleID, moduleIDsBeforeDistribute);
        boolean moduleExistsAfterDistribute = this.checkIfModuleExists(distributedModuleID, moduleIDsAfterDistribute);
        if (moduleExistsBeforeDistribute || !moduleExistsAfterDistribute) {
            return false;
        }
        TargetModuleID undeployedModuleID = null;
        undeployedModuleID = this.undeployModule(distributedModuleID);
        if (undeployedModuleID == null) {
            return false;
        }
        if (!undeployedModuleID.getModuleID().equals(distributedModuleID.getModuleID())) {
            return false;
        }
        return !this.checkIfModuleExists(undeployedModuleID, dm.getAvailableModules(moduleType, new Target[]{targetToDeploy}));
    }

    public boolean testTargetModuleID(File moduleArchive, File deploymentPlan, String archiveType) {
        try {
            DeploymentManager dm = this.getDeploymentManager();
            Target[] targets = dm.getTargets();
            if (targets.length == 0) {
                return false;
            }
            Target targetToDeploy = targets[0];
            TargetModuleID distributedModuleID = null;
            distributedModuleID = this.distributeModuleArchive(new Target[]{targetToDeploy}, moduleArchive, deploymentPlan);
            if (distributedModuleID == null) {
                return false;
            }
            if (!distributedModuleID.getTarget().getName().equals(targetToDeploy.getName())) {
                return false;
            }
            this.undeployModule(distributedModuleID);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private OperationStatus commandStatus(Target[] targets, ProgressObject progress) {
        OperationStatus status = null;
        int sleepCount = 0;
        int deployWaitMinutes = this.getDeployDelay();
        int MAX_SLEEP_COUNT = deployWaitMinutes * 60;
        while (!progress.getDeploymentStatus().isCompleted() && !progress.getDeploymentStatus().isFailed()) {
            try {
                Thread.sleep(1000L);
                if (++sleepCount < MAX_SLEEP_COUNT) continue;
                TestUtil.logErr((String)"Error: DeployTestUtil.commandStatus() timed out waiting for operation to complete");
                status = new OperationStatus(progress, targets, true);
                break;
            }
            catch (InterruptedException ie) {
                // empty catch block
                break;
            }
        }
        if (status == null) {
            status = new OperationStatus(progress, targets);
        }
        return status;
    }

    private int getDeployDelay() {
        int result = 5;
        String delayStr = System.getProperty("DEPLOY_DELAY_IN_MINUTES", "5");
        try {
            result = Integer.parseInt(delayStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        TestUtil.logTrace((String)("Maximum wait time for deployment is " + result + " minutes."));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File aFile) {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(aFile);
            out = new FileOutputStream("/tmp/" + aFile.getName());
            byte[] buf = new byte[2048];
            int start = 0;
            int i = 0;
            while ((i = in.read(buf)) != -1) {
                out.write(buf, 0, i);
                start += i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    public OperationStatus distributeModuleStreams(Target[] targets, InputStream moduleArchive, InputStream deploymentPlan) throws Exception {
        ProgressObject progress = null;
        try {
            progress = this.getDeploymentManager().distribute(targets, moduleArchive, deploymentPlan);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (progress.isCancelSupported()) {
                progress.cancel();
            }
            throw e;
        }
        OperationStatus result = this.commandStatus(targets, progress);
        this.delay();
        return result;
    }

    public OperationStatus distributeModuleFiles(Target[] targets, File moduleArchive, File deploymentPlan) throws Exception {
        ProgressObject progress = null;
        try {
            progress = this.getDeploymentManager().distribute(targets, moduleArchive, deploymentPlan);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (progress.isCancelSupported()) {
                progress.cancel();
            }
            throw e;
        }
        OperationStatus result = this.commandStatus(targets, progress);
        this.delay();
        return result;
    }

    public Target[] getTargets() throws Exception {
        Target[] result = null;
        result = this.getDeploymentManager().getTargets();
        return result;
    }

    public OperationStatus stopModule(TargetModuleID[] modulesIDsToStop) throws Exception {
        ProgressObject progress = null;
        try {
            progress = this.getDeploymentManager().stop(modulesIDsToStop);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.commandStatus(this.convertTargets(modulesIDsToStop), progress);
    }

    public OperationStatus startModule(TargetModuleID[] modulesIDsToStart) throws Exception {
        ProgressObject progress = null;
        try {
            progress = this.getDeploymentManager().start(modulesIDsToStart);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.commandStatus(this.convertTargets(modulesIDsToStart), progress);
    }

    public OperationStatus undeployModule(TargetModuleID[] modulesIDsToUndeploy) throws Exception {
        ProgressObject progress = null;
        try {
            progress = this.getDeploymentManager().undeploy(modulesIDsToUndeploy);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        OperationStatus result = this.commandStatus(this.convertTargets(modulesIDsToUndeploy), progress);
        this.delay();
        return result;
    }

    private void delay() {
        try {
            int delayTime = Integer.parseInt(System.getProperty("delay.after.deploy", "0"));
            if (delayTime != 0) {
                System.err.println("%%%%%%%%% SLEEPING FOR " + delayTime + " SECONDS");
                Thread.sleep(delayTime * 1000);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Target[] convertTargets(TargetModuleID[] targets) {
        if (targets == null) {
            return null;
        }
        Target[] result = new Target[targets.length];
        for (int i = 0; i < targets.length; ++i) {
            result[i] = targets[i].getTarget();
        }
        return result;
    }
}

