/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entityTransaction;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import jakarta.persistence.EntityTransaction;
import java.util.Properties;

public class Client
extends PMClientBase {
    Properties props = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("done cleanup, calling super.cleanup");
        super.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        try {
            EntityTransaction t = this.getEntityTransaction();
            t.begin();
            if (t.isActive()) {
                try {
                    t.begin();
                    this.logErr("IllegalStateException was not thrown");
                }
                catch (IllegalStateException ise) {
                    this.logTrace("IllegalStateException Caught as Expected.");
                    pass = true;
                }
            } else {
                this.logErr("isActive() returned false when a transaction was active");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("beginIllegalStateExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        try {
            EntityTransaction t = this.getEntityTransaction();
            if (!t.isActive()) {
                try {
                    t.commit();
                    this.logErr("IllegalStateException was not thrown");
                }
                catch (IllegalStateException ise) {
                    this.logTrace("IllegalStateException Caught as Expected.");
                    pass = true;
                }
            } else {
                this.logErr("isActive() returened true when no transaction  was active");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("commitIllegalStateExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRollbackOnlyIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        try {
            EntityTransaction t = this.getEntityTransaction();
            if (!t.isActive()) {
                try {
                    t.getRollbackOnly();
                    this.logErr("IllegalStateException was not thrown");
                }
                catch (IllegalStateException ise) {
                    this.logTrace("IllegalStateException Caught as Expected.");
                    pass = true;
                }
            } else {
                this.logErr("isActive() returned true when no transaction  was active");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("getRollbackOnlyIllegalStateExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        try {
            EntityTransaction t = this.getEntityTransaction();
            if (!t.isActive()) {
                try {
                    t.rollback();
                    this.logErr("IllegalStateException was not thrown");
                }
                catch (IllegalStateException ise) {
                    this.logTrace("IllegalStateException Caught as Expected.");
                    pass = true;
                }
            } else {
                this.logErr("isActive() returned true when no transaction  was active");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("rollbackIllegalStateExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRollbackOnlyIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        try {
            EntityTransaction t = this.getEntityTransaction();
            if (!t.isActive()) {
                try {
                    t.setRollbackOnly();
                    this.logErr("IllegalStateException was not thrown");
                }
                catch (IllegalStateException ise) {
                    this.logTrace("IllegalStateException Caught as Expected.");
                    pass = true;
                }
            } else {
                this.logErr("isActive() returned true when no transaction  was active");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("setRollbackOnlyIllegalStateExceptionTest failed");
        }
    }
}

